/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegLinetoAbs.h"

#include "SVGPathSegLineto.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathSegLinetoAbsTableValues[] =
{
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegLinetoAbsX), (intptr_t)setJSSVGPathSegLinetoAbsX, NoIntrinsic },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegLinetoAbsY), (intptr_t)setJSSVGPathSegLinetoAbsY, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegLinetoAbsConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegLinetoAbsTable = { 9, 7, JSSVGPathSegLinetoAbsTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathSegLinetoAbsConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegLinetoAbsConstructorTable = { 1, 0, JSSVGPathSegLinetoAbsConstructorTableValues, 0 };
const ClassInfo JSSVGPathSegLinetoAbsConstructor::s_info = { "SVGPathSegLinetoAbsConstructor", &Base::s_info, &JSSVGPathSegLinetoAbsConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegLinetoAbsConstructor) };

JSSVGPathSegLinetoAbsConstructor::JSSVGPathSegLinetoAbsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathSegLinetoAbsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPathSegLinetoAbsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPathSegLinetoAbsConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegLinetoAbsConstructor, JSDOMWrapper>(exec, &JSSVGPathSegLinetoAbsConstructorTable, jsCast<JSSVGPathSegLinetoAbsConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathSegLinetoAbsConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegLinetoAbsConstructor, JSDOMWrapper>(exec, &JSSVGPathSegLinetoAbsConstructorTable, jsCast<JSSVGPathSegLinetoAbsConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegLinetoAbsPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegLinetoAbsPrototypeTable = { 1, 0, JSSVGPathSegLinetoAbsPrototypeTableValues, 0 };
const ClassInfo JSSVGPathSegLinetoAbsPrototype::s_info = { "SVGPathSegLinetoAbsPrototype", &Base::s_info, &JSSVGPathSegLinetoAbsPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegLinetoAbsPrototype) };

JSObject* JSSVGPathSegLinetoAbsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegLinetoAbs>(exec, globalObject);
}

const ClassInfo JSSVGPathSegLinetoAbs::s_info = { "SVGPathSegLinetoAbs", &Base::s_info, &JSSVGPathSegLinetoAbsTable, 0 , CREATE_METHOD_TABLE(JSSVGPathSegLinetoAbs) };

JSSVGPathSegLinetoAbs::JSSVGPathSegLinetoAbs(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegLinetoAbs> impl)
    : JSSVGPathSeg(structure, globalObject, impl)
{
}

void JSSVGPathSegLinetoAbs::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathSegLinetoAbs::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathSegLinetoAbsPrototype::create(exec->vm(), globalObject, JSSVGPathSegLinetoAbsPrototype::createStructure(exec->vm(), globalObject, JSSVGPathSegPrototype::self(exec, globalObject)));
}

bool JSSVGPathSegLinetoAbs::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathSegLinetoAbs* thisObject = jsCast<JSSVGPathSegLinetoAbs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathSegLinetoAbs, Base>(exec, &JSSVGPathSegLinetoAbsTable, thisObject, propertyName, slot);
}

bool JSSVGPathSegLinetoAbs::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathSegLinetoAbs* thisObject = jsCast<JSSVGPathSegLinetoAbs*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathSegLinetoAbs, Base>(exec, &JSSVGPathSegLinetoAbsTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathSegLinetoAbsX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegLinetoAbs* castedThis = jsCast<JSSVGPathSegLinetoAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegLinetoAbs* impl = static_cast<SVGPathSegLinetoAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->x());
    return result;
}


JSValue jsSVGPathSegLinetoAbsY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegLinetoAbs* castedThis = jsCast<JSSVGPathSegLinetoAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegLinetoAbs* impl = static_cast<SVGPathSegLinetoAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->y());
    return result;
}


JSValue jsSVGPathSegLinetoAbsConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegLinetoAbs* domObject = jsCast<JSSVGPathSegLinetoAbs*>(asObject(slotBase));
    return JSSVGPathSegLinetoAbs::getConstructor(exec, domObject->globalObject());
}

void JSSVGPathSegLinetoAbs::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPathSegLinetoAbs* thisObject = jsCast<JSSVGPathSegLinetoAbs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPathSegLinetoAbs, Base>(exec, propertyName, value, &JSSVGPathSegLinetoAbsTable, thisObject, slot);
}

void setJSSVGPathSegLinetoAbsX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegLinetoAbs* castedThis = jsCast<JSSVGPathSegLinetoAbs*>(thisObject);
    SVGPathSegLinetoAbs* impl = static_cast<SVGPathSegLinetoAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setX(nativeValue);
}


void setJSSVGPathSegLinetoAbsY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegLinetoAbs* castedThis = jsCast<JSSVGPathSegLinetoAbs*>(thisObject);
    SVGPathSegLinetoAbs* impl = static_cast<SVGPathSegLinetoAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setY(nativeValue);
}


JSValue JSSVGPathSegLinetoAbs::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegLinetoAbsConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
