/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegCurvetoCubicAbs.h"

#include "SVGPathSegCurvetoCubic.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathSegCurvetoCubicAbsTableValues[] =
{
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsX), (intptr_t)setJSSVGPathSegCurvetoCubicAbsX, NoIntrinsic },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsY), (intptr_t)setJSSVGPathSegCurvetoCubicAbsY, NoIntrinsic },
    { "x1", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsX1), (intptr_t)setJSSVGPathSegCurvetoCubicAbsX1, NoIntrinsic },
    { "y1", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsY1), (intptr_t)setJSSVGPathSegCurvetoCubicAbsY1, NoIntrinsic },
    { "x2", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsX2), (intptr_t)setJSSVGPathSegCurvetoCubicAbsX2, NoIntrinsic },
    { "y2", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsY2), (intptr_t)setJSSVGPathSegCurvetoCubicAbsY2, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegCurvetoCubicAbsConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegCurvetoCubicAbsTable = { 16, 15, JSSVGPathSegCurvetoCubicAbsTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathSegCurvetoCubicAbsConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegCurvetoCubicAbsConstructorTable = { 1, 0, JSSVGPathSegCurvetoCubicAbsConstructorTableValues, 0 };
const ClassInfo JSSVGPathSegCurvetoCubicAbsConstructor::s_info = { "SVGPathSegCurvetoCubicAbsConstructor", &Base::s_info, &JSSVGPathSegCurvetoCubicAbsConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoCubicAbsConstructor) };

JSSVGPathSegCurvetoCubicAbsConstructor::JSSVGPathSegCurvetoCubicAbsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathSegCurvetoCubicAbsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPathSegCurvetoCubicAbsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPathSegCurvetoCubicAbsConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegCurvetoCubicAbsConstructor, JSDOMWrapper>(exec, &JSSVGPathSegCurvetoCubicAbsConstructorTable, jsCast<JSSVGPathSegCurvetoCubicAbsConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathSegCurvetoCubicAbsConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegCurvetoCubicAbsConstructor, JSDOMWrapper>(exec, &JSSVGPathSegCurvetoCubicAbsConstructorTable, jsCast<JSSVGPathSegCurvetoCubicAbsConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegCurvetoCubicAbsPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegCurvetoCubicAbsPrototypeTable = { 1, 0, JSSVGPathSegCurvetoCubicAbsPrototypeTableValues, 0 };
const ClassInfo JSSVGPathSegCurvetoCubicAbsPrototype::s_info = { "SVGPathSegCurvetoCubicAbsPrototype", &Base::s_info, &JSSVGPathSegCurvetoCubicAbsPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoCubicAbsPrototype) };

JSObject* JSSVGPathSegCurvetoCubicAbsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegCurvetoCubicAbs>(exec, globalObject);
}

const ClassInfo JSSVGPathSegCurvetoCubicAbs::s_info = { "SVGPathSegCurvetoCubicAbs", &Base::s_info, &JSSVGPathSegCurvetoCubicAbsTable, 0 , CREATE_METHOD_TABLE(JSSVGPathSegCurvetoCubicAbs) };

JSSVGPathSegCurvetoCubicAbs::JSSVGPathSegCurvetoCubicAbs(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegCurvetoCubicAbs> impl)
    : JSSVGPathSeg(structure, globalObject, impl)
{
}

void JSSVGPathSegCurvetoCubicAbs::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathSegCurvetoCubicAbs::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathSegCurvetoCubicAbsPrototype::create(exec->vm(), globalObject, JSSVGPathSegCurvetoCubicAbsPrototype::createStructure(exec->vm(), globalObject, JSSVGPathSegPrototype::self(exec, globalObject)));
}

bool JSSVGPathSegCurvetoCubicAbs::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathSegCurvetoCubicAbs* thisObject = jsCast<JSSVGPathSegCurvetoCubicAbs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathSegCurvetoCubicAbs, Base>(exec, &JSSVGPathSegCurvetoCubicAbsTable, thisObject, propertyName, slot);
}

bool JSSVGPathSegCurvetoCubicAbs::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathSegCurvetoCubicAbs* thisObject = jsCast<JSSVGPathSegCurvetoCubicAbs*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathSegCurvetoCubicAbs, Base>(exec, &JSSVGPathSegCurvetoCubicAbsTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathSegCurvetoCubicAbsX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->x());
    return result;
}


JSValue jsSVGPathSegCurvetoCubicAbsY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->y());
    return result;
}


JSValue jsSVGPathSegCurvetoCubicAbsX1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->x1());
    return result;
}


JSValue jsSVGPathSegCurvetoCubicAbsY1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->y1());
    return result;
}


JSValue jsSVGPathSegCurvetoCubicAbsX2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->x2());
    return result;
}


JSValue jsSVGPathSegCurvetoCubicAbsY2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    JSValue result = jsNumber(impl->y2());
    return result;
}


JSValue jsSVGPathSegCurvetoCubicAbsConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegCurvetoCubicAbs* domObject = jsCast<JSSVGPathSegCurvetoCubicAbs*>(asObject(slotBase));
    return JSSVGPathSegCurvetoCubicAbs::getConstructor(exec, domObject->globalObject());
}

void JSSVGPathSegCurvetoCubicAbs::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPathSegCurvetoCubicAbs* thisObject = jsCast<JSSVGPathSegCurvetoCubicAbs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPathSegCurvetoCubicAbs, Base>(exec, propertyName, value, &JSSVGPathSegCurvetoCubicAbsTable, thisObject, slot);
}

void setJSSVGPathSegCurvetoCubicAbsX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(thisObject);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setX(nativeValue);
}


void setJSSVGPathSegCurvetoCubicAbsY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(thisObject);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setY(nativeValue);
}


void setJSSVGPathSegCurvetoCubicAbsX1(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(thisObject);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setX1(nativeValue);
}


void setJSSVGPathSegCurvetoCubicAbsY1(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(thisObject);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setY1(nativeValue);
}


void setJSSVGPathSegCurvetoCubicAbsX2(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(thisObject);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setX2(nativeValue);
}


void setJSSVGPathSegCurvetoCubicAbsY2(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegCurvetoCubicAbs* castedThis = jsCast<JSSVGPathSegCurvetoCubicAbs*>(thisObject);
    SVGPathSegCurvetoCubicAbs* impl = static_cast<SVGPathSegCurvetoCubicAbs*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setY2(nativeValue);
}


JSValue JSSVGPathSegCurvetoCubicAbs::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegCurvetoCubicAbsConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
