/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLocatable.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "SVGElement.h"
#include "SVGLocatable.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGLocatableTableValues[] =
{
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLocatableNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLocatableFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLocatableTable = { 4, 3, JSSVGLocatableTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGLocatablePrototypeTableValues[] =
{
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLocatablePrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLocatablePrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLocatablePrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLocatablePrototypeFunctionGetTransformToElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLocatablePrototypeTable = { 8, 7, JSSVGLocatablePrototypeTableValues, 0 };
const ClassInfo JSSVGLocatablePrototype::s_info = { "SVGLocatablePrototype", &Base::s_info, &JSSVGLocatablePrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGLocatablePrototype) };

JSObject* JSSVGLocatablePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLocatable>(exec, globalObject);
}

bool JSSVGLocatablePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLocatablePrototype* thisObject = jsCast<JSSVGLocatablePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGLocatablePrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGLocatablePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLocatablePrototype* thisObject = jsCast<JSSVGLocatablePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGLocatablePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGLocatable::s_info = { "SVGLocatable", &Base::s_info, &JSSVGLocatableTable, 0 , CREATE_METHOD_TABLE(JSSVGLocatable) };

JSSVGLocatable::JSSVGLocatable(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLocatable> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGLocatable::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGLocatable::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGLocatablePrototype::create(exec->vm(), globalObject, JSSVGLocatablePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGLocatable::destroy(JSC::JSCell* cell)
{
    JSSVGLocatable* thisObject = static_cast<JSSVGLocatable*>(cell);
    thisObject->JSSVGLocatable::~JSSVGLocatable();
}

JSSVGLocatable::~JSSVGLocatable()
{
    releaseImplIfNotNull();
}

bool JSSVGLocatable::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLocatable* thisObject = jsCast<JSSVGLocatable*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGLocatable, Base>(exec, &JSSVGLocatableTable, thisObject, propertyName, slot);
}

bool JSSVGLocatable::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLocatable* thisObject = jsCast<JSSVGLocatable*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGLocatable, Base>(exec, &JSSVGLocatableTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGLocatableNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLocatable* castedThis = jsCast<JSSVGLocatable*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLocatable* impl = static_cast<SVGLocatable*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGLocatableFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLocatable* castedThis = jsCast<JSSVGLocatable*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLocatable* impl = static_cast<SVGLocatable*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsSVGLocatablePrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLocatable::s_info))
        return throwVMTypeError(exec);
    JSSVGLocatable* castedThis = jsCast<JSSVGLocatable*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLocatable::s_info);
    SVGLocatable* impl = static_cast<SVGLocatable*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLocatablePrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLocatable::s_info))
        return throwVMTypeError(exec);
    JSSVGLocatable* castedThis = jsCast<JSSVGLocatable*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLocatable::s_info);
    SVGLocatable* impl = static_cast<SVGLocatable*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLocatablePrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLocatable::s_info))
        return throwVMTypeError(exec);
    JSSVGLocatable* castedThis = jsCast<JSSVGLocatable*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLocatable::s_info);
    SVGLocatable* impl = static_cast<SVGLocatable*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLocatablePrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLocatable::s_info))
        return throwVMTypeError(exec);
    JSSVGLocatable* castedThis = jsCast<JSSVGLocatable*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLocatable::s_info);
    SVGLocatable* impl = static_cast<SVGLocatable*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGLocatable* jsSVGLocatable)
{
    if (jsSVGLocatable->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGLocatableOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGLocatable* jsSVGLocatable = jsCast<JSSVGLocatable*>(handle.get().asCell());
    if (!isObservable(jsSVGLocatable))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGLocatableOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGLocatable* jsSVGLocatable = jsCast<JSSVGLocatable*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGLocatable->impl(), jsSVGLocatable);
    jsSVGLocatable->releaseImpl();
}

SVGLocatable* toSVGLocatable(JSC::JSValue value)
{
    return value.inherits(&JSSVGLocatable::s_info) ? jsCast<JSSVGLocatable*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
