/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLineElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGLineElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGLineElementTableValues[] =
{
    { "x1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementX1), (intptr_t)0, NoIntrinsic },
    { "y1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementY1), (intptr_t)0, NoIntrinsic },
    { "x2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementX2), (intptr_t)0, NoIntrinsic },
    { "y2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementY2), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementXmllang), (intptr_t)setJSSVGLineElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementXmlspace), (intptr_t)setJSSVGLineElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLineElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLineElementTable = { 36, 31, JSSVGLineElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGLineElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLineElementConstructorTable = { 1, 0, JSSVGLineElementConstructorTableValues, 0 };
const ClassInfo JSSVGLineElementConstructor::s_info = { "SVGLineElementConstructor", &Base::s_info, &JSSVGLineElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGLineElementConstructor) };

JSSVGLineElementConstructor::JSSVGLineElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGLineElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGLineElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGLineElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLineElementConstructor, JSDOMWrapper>(exec, &JSSVGLineElementConstructorTable, jsCast<JSSVGLineElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGLineElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLineElementConstructor, JSDOMWrapper>(exec, &JSSVGLineElementConstructorTable, jsCast<JSSVGLineElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGLineElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLineElementPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLineElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLineElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLineElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLineElementPrototypeFunctionGetTransformToElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLineElementPrototypeTable = { 17, 15, JSSVGLineElementPrototypeTableValues, 0 };
const ClassInfo JSSVGLineElementPrototype::s_info = { "SVGLineElementPrototype", &Base::s_info, &JSSVGLineElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGLineElementPrototype) };

JSObject* JSSVGLineElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLineElement>(exec, globalObject);
}

bool JSSVGLineElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLineElementPrototype* thisObject = jsCast<JSSVGLineElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGLineElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGLineElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLineElementPrototype* thisObject = jsCast<JSSVGLineElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGLineElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGLineElement::s_info = { "SVGLineElement", &Base::s_info, &JSSVGLineElementTable, 0 , CREATE_METHOD_TABLE(JSSVGLineElement) };

JSSVGLineElement::JSSVGLineElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLineElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGLineElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGLineElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGLineElementPrototype::create(exec->vm(), globalObject, JSSVGLineElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGLineElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLineElement* thisObject = jsCast<JSSVGLineElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGLineElement, Base>(exec, &JSSVGLineElementTable, thisObject, propertyName, slot);
}

bool JSSVGLineElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLineElement* thisObject = jsCast<JSSVGLineElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGLineElement, Base>(exec, &JSSVGLineElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGLineElementX1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->x1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLineElementY1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->y1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLineElementX2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->x2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLineElementY2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->y2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLineElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGLineElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGLineElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGLineElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGLineElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGLineElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLineElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLineElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGLineElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGLineElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLineElement* domObject = jsCast<JSSVGLineElement*>(asObject(slotBase));
    return JSSVGLineElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGLineElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGLineElement* thisObject = jsCast<JSSVGLineElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGLineElement, Base>(exec, propertyName, value, &JSSVGLineElementTable, thisObject, slot);
}

void setJSSVGLineElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(thisObject);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGLineElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(thisObject);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


JSValue JSSVGLineElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLineElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGLineElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLineElement::s_info);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLineElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLineElement::s_info);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLineElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLineElement::s_info);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLineElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLineElement::s_info);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGLineElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGLineElement* castedThis = jsCast<JSSVGLineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLineElement::s_info);
    SVGLineElement* impl = static_cast<SVGLineElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
