/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLangSpace.h"

#include "KURL.h"
#include "SVGLangSpace.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGLangSpaceTableValues[] =
{
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLangSpaceXmllang), (intptr_t)setJSSVGLangSpaceXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLangSpaceXmlspace), (intptr_t)setJSSVGLangSpaceXmlspace, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLangSpaceTable = { 5, 3, JSSVGLangSpaceTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGLangSpacePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLangSpacePrototypeTable = { 1, 0, JSSVGLangSpacePrototypeTableValues, 0 };
const ClassInfo JSSVGLangSpacePrototype::s_info = { "SVGLangSpacePrototype", &Base::s_info, &JSSVGLangSpacePrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGLangSpacePrototype) };

JSObject* JSSVGLangSpacePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLangSpace>(exec, globalObject);
}

const ClassInfo JSSVGLangSpace::s_info = { "SVGLangSpace", &Base::s_info, &JSSVGLangSpaceTable, 0 , CREATE_METHOD_TABLE(JSSVGLangSpace) };

JSSVGLangSpace::JSSVGLangSpace(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLangSpace> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGLangSpace::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGLangSpace::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGLangSpacePrototype::create(exec->vm(), globalObject, JSSVGLangSpacePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGLangSpace::destroy(JSC::JSCell* cell)
{
    JSSVGLangSpace* thisObject = static_cast<JSSVGLangSpace*>(cell);
    thisObject->JSSVGLangSpace::~JSSVGLangSpace();
}

JSSVGLangSpace::~JSSVGLangSpace()
{
    releaseImplIfNotNull();
}

bool JSSVGLangSpace::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLangSpace* thisObject = jsCast<JSSVGLangSpace*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGLangSpace, Base>(exec, &JSSVGLangSpaceTable, thisObject, propertyName, slot);
}

bool JSSVGLangSpace::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLangSpace* thisObject = jsCast<JSSVGLangSpace*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGLangSpace, Base>(exec, &JSSVGLangSpaceTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGLangSpaceXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLangSpace* castedThis = jsCast<JSSVGLangSpace*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLangSpace* impl = static_cast<SVGLangSpace*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGLangSpaceXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLangSpace* castedThis = jsCast<JSSVGLangSpace*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLangSpace* impl = static_cast<SVGLangSpace*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


void JSSVGLangSpace::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGLangSpace* thisObject = jsCast<JSSVGLangSpace*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGLangSpace, Base>(exec, propertyName, value, &JSSVGLangSpaceTable, thisObject, slot);
}

void setJSSVGLangSpaceXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGLangSpace* castedThis = jsCast<JSSVGLangSpace*>(thisObject);
    SVGLangSpace* impl = static_cast<SVGLangSpace*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGLangSpaceXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGLangSpace* castedThis = jsCast<JSSVGLangSpace*>(thisObject);
    SVGLangSpace* impl = static_cast<SVGLangSpace*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


static inline bool isObservable(JSSVGLangSpace* jsSVGLangSpace)
{
    if (jsSVGLangSpace->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGLangSpaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGLangSpace* jsSVGLangSpace = jsCast<JSSVGLangSpace*>(handle.get().asCell());
    if (!isObservable(jsSVGLangSpace))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGLangSpaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGLangSpace* jsSVGLangSpace = jsCast<JSSVGLangSpace*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGLangSpace->impl(), jsSVGLangSpace);
    jsSVGLangSpace->releaseImpl();
}

SVGLangSpace* toSVGLangSpace(JSC::JSValue value)
{
    return value.inherits(&JSSVGLangSpace::s_info) ? jsCast<JSSVGLangSpace*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
