/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGGradientElement.h"

#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "SVGGradientElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGGradientElementTableValues[] =
{
    { "gradientUnits", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementGradientUnits), (intptr_t)0, NoIntrinsic },
    { "gradientTransform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementGradientTransform), (intptr_t)0, NoIntrinsic },
    { "spreadMethod", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSpreadMethod), (intptr_t)0, NoIntrinsic },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementHref), (intptr_t)0, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGGradientElementTable = { 16, 15, JSSVGGradientElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGGradientElementConstructorTableValues[] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_SPREADMETHOD_PAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_PAD), (intptr_t)0, NoIntrinsic },
    { "SVG_SPREADMETHOD_REFLECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REFLECT), (intptr_t)0, NoIntrinsic },
    { "SVG_SPREADMETHOD_REPEAT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REPEAT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGGradientElementConstructorTable = { 8, 7, JSSVGGradientElementConstructorTableValues, 0 };
const ClassInfo JSSVGGradientElementConstructor::s_info = { "SVGGradientElementConstructor", &Base::s_info, &JSSVGGradientElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGGradientElementConstructor) };

JSSVGGradientElementConstructor::JSSVGGradientElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGGradientElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGGradientElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGGradientElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGradientElementConstructor, JSDOMWrapper>(exec, &JSSVGGradientElementConstructorTable, jsCast<JSSVGGradientElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGGradientElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGradientElementConstructor, JSDOMWrapper>(exec, &JSSVGGradientElementConstructorTable, jsCast<JSSVGGradientElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGGradientElementPrototypeTableValues[] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_SPREADMETHOD_PAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_PAD), (intptr_t)0, NoIntrinsic },
    { "SVG_SPREADMETHOD_REFLECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REFLECT), (intptr_t)0, NoIntrinsic },
    { "SVG_SPREADMETHOD_REPEAT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REPEAT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGGradientElementPrototypeTable = { 8, 7, JSSVGGradientElementPrototypeTableValues, 0 };
const ClassInfo JSSVGGradientElementPrototype::s_info = { "SVGGradientElementPrototype", &Base::s_info, &JSSVGGradientElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGGradientElementPrototype) };

JSObject* JSSVGGradientElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGGradientElement>(exec, globalObject);
}

bool JSSVGGradientElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGGradientElementPrototype* thisObject = jsCast<JSSVGGradientElementPrototype*>(cell);
    return getStaticValueSlot<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGGradientElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGGradientElementPrototype* thisObject = jsCast<JSSVGGradientElementPrototype*>(object);
    return getStaticValueDescriptor<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGGradientElement::s_info = { "SVGGradientElement", &Base::s_info, &JSSVGGradientElementTable, 0 , CREATE_METHOD_TABLE(JSSVGGradientElement) };

JSSVGGradientElement::JSSVGGradientElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGGradientElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGGradientElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGGradientElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGGradientElementPrototype::create(exec->vm(), globalObject, JSSVGGradientElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGGradientElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGGradientElement* thisObject = jsCast<JSSVGGradientElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGGradientElement, Base>(exec, &JSSVGGradientElementTable, thisObject, propertyName, slot);
}

bool JSSVGGradientElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGGradientElement* thisObject = jsCast<JSSVGGradientElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGGradientElement, Base>(exec, &JSSVGGradientElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGGradientElementGradientUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGradientElement* castedThis = jsCast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* impl = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->gradientUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementGradientTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGradientElement* castedThis = jsCast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* impl = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->gradientTransformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementSpreadMethod(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGradientElement* castedThis = jsCast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* impl = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->spreadMethodAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGradientElement* castedThis = jsCast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* impl = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGradientElement* castedThis = jsCast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* impl = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGradientElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGradientElement* domObject = jsCast<JSSVGGradientElement*>(asObject(slotBase));
    return JSSVGGradientElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGGradientElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGradientElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_PAD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_REFLECT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_REPEAT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}


}

#endif // ENABLE(SVG)
