/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGFitToViewBox.h"

#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "SVGFitToViewBox.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFitToViewBoxTableValues[] =
{
    { "viewBox", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFitToViewBoxViewBox), (intptr_t)0, NoIntrinsic },
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFitToViewBoxPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFitToViewBoxTable = { 5, 3, JSSVGFitToViewBoxTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGFitToViewBoxPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFitToViewBoxPrototypeTable = { 1, 0, JSSVGFitToViewBoxPrototypeTableValues, 0 };
const ClassInfo JSSVGFitToViewBoxPrototype::s_info = { "SVGFitToViewBoxPrototype", &Base::s_info, &JSSVGFitToViewBoxPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFitToViewBoxPrototype) };

JSObject* JSSVGFitToViewBoxPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFitToViewBox>(exec, globalObject);
}

const ClassInfo JSSVGFitToViewBox::s_info = { "SVGFitToViewBox", &Base::s_info, &JSSVGFitToViewBoxTable, 0 , CREATE_METHOD_TABLE(JSSVGFitToViewBox) };

JSSVGFitToViewBox::JSSVGFitToViewBox(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFitToViewBox> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGFitToViewBox::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFitToViewBox::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFitToViewBoxPrototype::create(exec->vm(), globalObject, JSSVGFitToViewBoxPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGFitToViewBox::destroy(JSC::JSCell* cell)
{
    JSSVGFitToViewBox* thisObject = static_cast<JSSVGFitToViewBox*>(cell);
    thisObject->JSSVGFitToViewBox::~JSSVGFitToViewBox();
}

JSSVGFitToViewBox::~JSSVGFitToViewBox()
{
    releaseImplIfNotNull();
}

bool JSSVGFitToViewBox::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFitToViewBox* thisObject = jsCast<JSSVGFitToViewBox*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFitToViewBox, Base>(exec, &JSSVGFitToViewBoxTable, thisObject, propertyName, slot);
}

bool JSSVGFitToViewBox::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFitToViewBox* thisObject = jsCast<JSSVGFitToViewBox*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFitToViewBox, Base>(exec, &JSSVGFitToViewBoxTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFitToViewBoxViewBox(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFitToViewBox* castedThis = jsCast<JSSVGFitToViewBox*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFitToViewBox* impl = static_cast<SVGFitToViewBox*>(castedThis->impl());
    RefPtr<SVGAnimatedRect> obj = impl->viewBoxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFitToViewBoxPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFitToViewBox* castedThis = jsCast<JSSVGFitToViewBox*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFitToViewBox* impl = static_cast<SVGFitToViewBox*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


static inline bool isObservable(JSSVGFitToViewBox* jsSVGFitToViewBox)
{
    if (jsSVGFitToViewBox->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGFitToViewBoxOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGFitToViewBox* jsSVGFitToViewBox = jsCast<JSSVGFitToViewBox*>(handle.get().asCell());
    if (!isObservable(jsSVGFitToViewBox))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGFitToViewBoxOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGFitToViewBox* jsSVGFitToViewBox = jsCast<JSSVGFitToViewBox*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGFitToViewBox->impl(), jsSVGFitToViewBox);
    jsSVGFitToViewBox->releaseImpl();
}

SVGFitToViewBox* toSVGFitToViewBox(JSC::JSValue value)
{
    return value.inherits(&JSSVGFitToViewBox::s_info) ? jsCast<JSSVGFitToViewBox*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
