/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGFilterPrimitiveStandardAttributes.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFilterPrimitiveStandardAttributes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFilterPrimitiveStandardAttributesTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterPrimitiveStandardAttributesX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterPrimitiveStandardAttributesY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterPrimitiveStandardAttributesWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterPrimitiveStandardAttributesHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterPrimitiveStandardAttributesResult), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFilterPrimitiveStandardAttributesTable = { 16, 15, JSSVGFilterPrimitiveStandardAttributesTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGFilterPrimitiveStandardAttributesPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFilterPrimitiveStandardAttributesPrototypeTable = { 1, 0, JSSVGFilterPrimitiveStandardAttributesPrototypeTableValues, 0 };
const ClassInfo JSSVGFilterPrimitiveStandardAttributesPrototype::s_info = { "SVGFilterPrimitiveStandardAttributesPrototype", &Base::s_info, &JSSVGFilterPrimitiveStandardAttributesPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFilterPrimitiveStandardAttributesPrototype) };

JSObject* JSSVGFilterPrimitiveStandardAttributesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFilterPrimitiveStandardAttributes>(exec, globalObject);
}

const ClassInfo JSSVGFilterPrimitiveStandardAttributes::s_info = { "SVGFilterPrimitiveStandardAttributes", &Base::s_info, &JSSVGFilterPrimitiveStandardAttributesTable, 0 , CREATE_METHOD_TABLE(JSSVGFilterPrimitiveStandardAttributes) };

JSSVGFilterPrimitiveStandardAttributes::JSSVGFilterPrimitiveStandardAttributes(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFilterPrimitiveStandardAttributes> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGFilterPrimitiveStandardAttributes::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFilterPrimitiveStandardAttributes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFilterPrimitiveStandardAttributesPrototype::create(exec->vm(), globalObject, JSSVGFilterPrimitiveStandardAttributesPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGFilterPrimitiveStandardAttributes::destroy(JSC::JSCell* cell)
{
    JSSVGFilterPrimitiveStandardAttributes* thisObject = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(cell);
    thisObject->JSSVGFilterPrimitiveStandardAttributes::~JSSVGFilterPrimitiveStandardAttributes();
}

JSSVGFilterPrimitiveStandardAttributes::~JSSVGFilterPrimitiveStandardAttributes()
{
    releaseImplIfNotNull();
}

bool JSSVGFilterPrimitiveStandardAttributes::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* thisObject = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFilterPrimitiveStandardAttributes, Base>(exec, &JSSVGFilterPrimitiveStandardAttributesTable, thisObject, propertyName, slot);
}

bool JSSVGFilterPrimitiveStandardAttributes::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFilterPrimitiveStandardAttributes* thisObject = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFilterPrimitiveStandardAttributes, Base>(exec, &JSSVGFilterPrimitiveStandardAttributesTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFilterPrimitiveStandardAttributesX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* impl = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFilterPrimitiveStandardAttributesY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* impl = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFilterPrimitiveStandardAttributesWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* impl = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFilterPrimitiveStandardAttributesHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* impl = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFilterPrimitiveStandardAttributesResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* impl = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


static inline bool isObservable(JSSVGFilterPrimitiveStandardAttributes* jsSVGFilterPrimitiveStandardAttributes)
{
    if (jsSVGFilterPrimitiveStandardAttributes->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGFilterPrimitiveStandardAttributesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGFilterPrimitiveStandardAttributes* jsSVGFilterPrimitiveStandardAttributes = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(handle.get().asCell());
    if (!isObservable(jsSVGFilterPrimitiveStandardAttributes))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGFilterPrimitiveStandardAttributesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGFilterPrimitiveStandardAttributes* jsSVGFilterPrimitiveStandardAttributes = jsCast<JSSVGFilterPrimitiveStandardAttributes*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGFilterPrimitiveStandardAttributes->impl(), jsSVGFilterPrimitiveStandardAttributes);
    jsSVGFilterPrimitiveStandardAttributes->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGFilterPrimitiveStandardAttributes@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore36SVGFilterPrimitiveStandardAttributesE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGFilterPrimitiveStandardAttributes* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGFilterPrimitiveStandardAttributes>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SVGFilterPrimitiveStandardAttributes@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore36SVGFilterPrimitiveStandardAttributesE[2];
#if COMPILER(CLANG)
    // If this fails SVGFilterPrimitiveStandardAttributes does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SVGFilterPrimitiveStandardAttributes), SVGFilterPrimitiveStandardAttributes_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SVGFilterPrimitiveStandardAttributes has subclasses. If SVGFilterPrimitiveStandardAttributes has subclasses that get passed
    // to toJS() we currently require SVGFilterPrimitiveStandardAttributes you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SVGFilterPrimitiveStandardAttributes>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGFilterPrimitiveStandardAttributes>(exec, globalObject, impl);
}

SVGFilterPrimitiveStandardAttributes* toSVGFilterPrimitiveStandardAttributes(JSC::JSValue value)
{
    return value.inherits(&JSSVGFilterPrimitiveStandardAttributes::s_info) ? jsCast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
