/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFESpecularLightingElement.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFESpecularLightingElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFESpecularLightingElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementIn1), (intptr_t)0, NoIntrinsic },
    { "surfaceScale", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementSurfaceScale), (intptr_t)0, NoIntrinsic },
    { "specularConstant", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementSpecularConstant), (intptr_t)0, NoIntrinsic },
    { "specularExponent", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementSpecularExponent), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementResult), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpecularLightingElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFESpecularLightingElementTable = { 35, 31, JSSVGFESpecularLightingElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFESpecularLightingElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFESpecularLightingElementConstructorTable = { 1, 0, JSSVGFESpecularLightingElementConstructorTableValues, 0 };
const ClassInfo JSSVGFESpecularLightingElementConstructor::s_info = { "SVGFESpecularLightingElementConstructor", &Base::s_info, &JSSVGFESpecularLightingElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFESpecularLightingElementConstructor) };

JSSVGFESpecularLightingElementConstructor::JSSVGFESpecularLightingElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFESpecularLightingElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGFESpecularLightingElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGFESpecularLightingElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFESpecularLightingElementConstructor, JSDOMWrapper>(exec, &JSSVGFESpecularLightingElementConstructorTable, jsCast<JSSVGFESpecularLightingElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFESpecularLightingElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFESpecularLightingElementConstructor, JSDOMWrapper>(exec, &JSSVGFESpecularLightingElementConstructorTable, jsCast<JSSVGFESpecularLightingElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFESpecularLightingElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFESpecularLightingElementPrototypeTable = { 1, 0, JSSVGFESpecularLightingElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFESpecularLightingElementPrototype::s_info = { "SVGFESpecularLightingElementPrototype", &Base::s_info, &JSSVGFESpecularLightingElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFESpecularLightingElementPrototype) };

JSObject* JSSVGFESpecularLightingElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFESpecularLightingElement>(exec, globalObject);
}

const ClassInfo JSSVGFESpecularLightingElement::s_info = { "SVGFESpecularLightingElement", &Base::s_info, &JSSVGFESpecularLightingElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFESpecularLightingElement) };

JSSVGFESpecularLightingElement::JSSVGFESpecularLightingElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFESpecularLightingElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFESpecularLightingElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFESpecularLightingElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFESpecularLightingElementPrototype::create(exec->vm(), globalObject, JSSVGFESpecularLightingElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFESpecularLightingElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFESpecularLightingElement* thisObject = jsCast<JSSVGFESpecularLightingElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFESpecularLightingElement, Base>(exec, &JSSVGFESpecularLightingElementTable, thisObject, propertyName, slot);
}

bool JSSVGFESpecularLightingElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFESpecularLightingElement* thisObject = jsCast<JSSVGFESpecularLightingElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFESpecularLightingElement, Base>(exec, &JSSVGFESpecularLightingElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFESpecularLightingElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementSurfaceScale(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->surfaceScaleAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementSpecularConstant(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->specularConstantAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementSpecularExponent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->specularExponentAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* castedThis = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpecularLightingElement* impl = static_cast<SVGFESpecularLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFESpecularLightingElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFESpecularLightingElement* domObject = jsCast<JSSVGFESpecularLightingElement*>(asObject(slotBase));
    return JSSVGFESpecularLightingElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFESpecularLightingElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFESpecularLightingElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
