/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEGaussianBlurElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEGaussianBlurElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEGaussianBlurElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementIn1), (intptr_t)0, NoIntrinsic },
    { "stdDeviationX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementStdDeviationX), (intptr_t)0, NoIntrinsic },
    { "stdDeviationY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementStdDeviationY), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementResult), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEGaussianBlurElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEGaussianBlurElementTable = { 33, 31, JSSVGFEGaussianBlurElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEGaussianBlurElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEGaussianBlurElementConstructorTable = { 1, 0, JSSVGFEGaussianBlurElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEGaussianBlurElementConstructor::s_info = { "SVGFEGaussianBlurElementConstructor", &Base::s_info, &JSSVGFEGaussianBlurElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEGaussianBlurElementConstructor) };

JSSVGFEGaussianBlurElementConstructor::JSSVGFEGaussianBlurElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEGaussianBlurElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGFEGaussianBlurElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGFEGaussianBlurElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEGaussianBlurElementConstructor, JSDOMWrapper>(exec, &JSSVGFEGaussianBlurElementConstructorTable, jsCast<JSSVGFEGaussianBlurElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEGaussianBlurElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEGaussianBlurElementConstructor, JSDOMWrapper>(exec, &JSSVGFEGaussianBlurElementConstructorTable, jsCast<JSSVGFEGaussianBlurElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEGaussianBlurElementPrototypeTableValues[] =
{
    { "setStdDeviation", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEGaussianBlurElementPrototypeFunctionSetStdDeviation), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEGaussianBlurElementPrototypeTable = { 2, 1, JSSVGFEGaussianBlurElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEGaussianBlurElementPrototype::s_info = { "SVGFEGaussianBlurElementPrototype", &Base::s_info, &JSSVGFEGaussianBlurElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEGaussianBlurElementPrototype) };

JSObject* JSSVGFEGaussianBlurElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEGaussianBlurElement>(exec, globalObject);
}

bool JSSVGFEGaussianBlurElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEGaussianBlurElementPrototype* thisObject = jsCast<JSSVGFEGaussianBlurElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEGaussianBlurElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFEGaussianBlurElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEGaussianBlurElementPrototype* thisObject = jsCast<JSSVGFEGaussianBlurElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEGaussianBlurElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFEGaussianBlurElement::s_info = { "SVGFEGaussianBlurElement", &Base::s_info, &JSSVGFEGaussianBlurElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEGaussianBlurElement) };

JSSVGFEGaussianBlurElement::JSSVGFEGaussianBlurElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEGaussianBlurElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFEGaussianBlurElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEGaussianBlurElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEGaussianBlurElementPrototype::create(exec->vm(), globalObject, JSSVGFEGaussianBlurElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEGaussianBlurElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEGaussianBlurElement* thisObject = jsCast<JSSVGFEGaussianBlurElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEGaussianBlurElement, Base>(exec, &JSSVGFEGaussianBlurElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEGaussianBlurElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEGaussianBlurElement* thisObject = jsCast<JSSVGFEGaussianBlurElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEGaussianBlurElement, Base>(exec, &JSSVGFEGaussianBlurElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEGaussianBlurElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementStdDeviationX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->stdDeviationXAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementStdDeviationY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->stdDeviationYAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEGaussianBlurElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEGaussianBlurElement* domObject = jsCast<JSSVGFEGaussianBlurElement*>(asObject(slotBase));
    return JSSVGFEGaussianBlurElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEGaussianBlurElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEGaussianBlurElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFEGaussianBlurElementPrototypeFunctionSetStdDeviation(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFEGaussianBlurElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFEGaussianBlurElement* castedThis = jsCast<JSSVGFEGaussianBlurElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFEGaussianBlurElement::s_info);
    SVGFEGaussianBlurElement* impl = static_cast<SVGFEGaussianBlurElement*>(castedThis->impl());
    float stdDeviationX(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float stdDeviationY(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStdDeviation(stdDeviationX, stdDeviationY);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
