/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEDiffuseLightingElement.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEDiffuseLightingElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEDiffuseLightingElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementIn1), (intptr_t)0, NoIntrinsic },
    { "surfaceScale", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementSurfaceScale), (intptr_t)0, NoIntrinsic },
    { "diffuseConstant", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementDiffuseConstant), (intptr_t)0, NoIntrinsic },
    { "kernelUnitLengthX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementKernelUnitLengthX), (intptr_t)0, NoIntrinsic },
    { "kernelUnitLengthY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementKernelUnitLengthY), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementResult), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDiffuseLightingElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEDiffuseLightingElementTable = { 34, 31, JSSVGFEDiffuseLightingElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEDiffuseLightingElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEDiffuseLightingElementConstructorTable = { 1, 0, JSSVGFEDiffuseLightingElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEDiffuseLightingElementConstructor::s_info = { "SVGFEDiffuseLightingElementConstructor", &Base::s_info, &JSSVGFEDiffuseLightingElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEDiffuseLightingElementConstructor) };

JSSVGFEDiffuseLightingElementConstructor::JSSVGFEDiffuseLightingElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEDiffuseLightingElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGFEDiffuseLightingElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGFEDiffuseLightingElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEDiffuseLightingElementConstructor, JSDOMWrapper>(exec, &JSSVGFEDiffuseLightingElementConstructorTable, jsCast<JSSVGFEDiffuseLightingElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEDiffuseLightingElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEDiffuseLightingElementConstructor, JSDOMWrapper>(exec, &JSSVGFEDiffuseLightingElementConstructorTable, jsCast<JSSVGFEDiffuseLightingElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEDiffuseLightingElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEDiffuseLightingElementPrototypeTable = { 1, 0, JSSVGFEDiffuseLightingElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEDiffuseLightingElementPrototype::s_info = { "SVGFEDiffuseLightingElementPrototype", &Base::s_info, &JSSVGFEDiffuseLightingElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEDiffuseLightingElementPrototype) };

JSObject* JSSVGFEDiffuseLightingElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEDiffuseLightingElement>(exec, globalObject);
}

const ClassInfo JSSVGFEDiffuseLightingElement::s_info = { "SVGFEDiffuseLightingElement", &Base::s_info, &JSSVGFEDiffuseLightingElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEDiffuseLightingElement) };

JSSVGFEDiffuseLightingElement::JSSVGFEDiffuseLightingElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEDiffuseLightingElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFEDiffuseLightingElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEDiffuseLightingElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEDiffuseLightingElementPrototype::create(exec->vm(), globalObject, JSSVGFEDiffuseLightingElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEDiffuseLightingElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEDiffuseLightingElement* thisObject = jsCast<JSSVGFEDiffuseLightingElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEDiffuseLightingElement, Base>(exec, &JSSVGFEDiffuseLightingElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEDiffuseLightingElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEDiffuseLightingElement* thisObject = jsCast<JSSVGFEDiffuseLightingElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEDiffuseLightingElement, Base>(exec, &JSSVGFEDiffuseLightingElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEDiffuseLightingElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementSurfaceScale(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->surfaceScaleAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementDiffuseConstant(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->diffuseConstantAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementKernelUnitLengthX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->kernelUnitLengthXAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementKernelUnitLengthY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->kernelUnitLengthYAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* castedThis = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDiffuseLightingElement* impl = static_cast<SVGFEDiffuseLightingElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDiffuseLightingElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDiffuseLightingElement* domObject = jsCast<JSSVGFEDiffuseLightingElement*>(asObject(slotBase));
    return JSSVGFEDiffuseLightingElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEDiffuseLightingElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEDiffuseLightingElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
