/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEColorMatrixElement.h"

#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumberList.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEColorMatrixElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEColorMatrixElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementIn1), (intptr_t)0, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementType), (intptr_t)0, NoIntrinsic },
    { "values", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementValues), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementResult), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEColorMatrixElementTable = { 33, 31, JSSVGFEColorMatrixElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEColorMatrixElementConstructorTableValues[] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEColorMatrixElementConstructorTable = { 17, 15, JSSVGFEColorMatrixElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEColorMatrixElementConstructor::s_info = { "SVGFEColorMatrixElementConstructor", &Base::s_info, &JSSVGFEColorMatrixElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEColorMatrixElementConstructor) };

JSSVGFEColorMatrixElementConstructor::JSSVGFEColorMatrixElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEColorMatrixElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGFEColorMatrixElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEColorMatrixElementConstructor, JSDOMWrapper>(exec, &JSSVGFEColorMatrixElementConstructorTable, jsCast<JSSVGFEColorMatrixElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEColorMatrixElementConstructor, JSDOMWrapper>(exec, &JSSVGFEColorMatrixElementConstructorTable, jsCast<JSSVGFEColorMatrixElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEColorMatrixElementPrototypeTableValues[] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEColorMatrixElementPrototypeTable = { 17, 15, JSSVGFEColorMatrixElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEColorMatrixElementPrototype::s_info = { "SVGFEColorMatrixElementPrototype", &Base::s_info, &JSSVGFEColorMatrixElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEColorMatrixElementPrototype) };

JSObject* JSSVGFEColorMatrixElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEColorMatrixElement>(exec, globalObject);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEColorMatrixElementPrototype* thisObject = jsCast<JSSVGFEColorMatrixElementPrototype*>(cell);
    return getStaticValueSlot<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEColorMatrixElementPrototype* thisObject = jsCast<JSSVGFEColorMatrixElementPrototype*>(object);
    return getStaticValueDescriptor<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFEColorMatrixElement::s_info = { "SVGFEColorMatrixElement", &Base::s_info, &JSSVGFEColorMatrixElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEColorMatrixElement) };

JSSVGFEColorMatrixElement::JSSVGFEColorMatrixElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEColorMatrixElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFEColorMatrixElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEColorMatrixElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEColorMatrixElementPrototype::create(exec->vm(), globalObject, JSSVGFEColorMatrixElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEColorMatrixElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEColorMatrixElement* thisObject = jsCast<JSSVGFEColorMatrixElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEColorMatrixElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEColorMatrixElement* thisObject = jsCast<JSSVGFEColorMatrixElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEColorMatrixElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->typeAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementValues(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumberList> obj = impl->valuesAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* castedThis = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEColorMatrixElement* impl = static_cast<SVGFEColorMatrixElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEColorMatrixElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEColorMatrixElement* domObject = jsCast<JSSVGFEColorMatrixElement*>(asObject(slotBase));
    return JSSVGFEColorMatrixElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEColorMatrixElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEColorMatrixElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
