/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGExternalResourcesRequired.h"

#include "JSSVGAnimatedBoolean.h"
#include "SVGExternalResourcesRequired.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGExternalResourcesRequiredTableValues[] =
{
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGExternalResourcesRequiredExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGExternalResourcesRequiredTable = { 2, 1, JSSVGExternalResourcesRequiredTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGExternalResourcesRequiredPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGExternalResourcesRequiredPrototypeTable = { 1, 0, JSSVGExternalResourcesRequiredPrototypeTableValues, 0 };
const ClassInfo JSSVGExternalResourcesRequiredPrototype::s_info = { "SVGExternalResourcesRequiredPrototype", &Base::s_info, &JSSVGExternalResourcesRequiredPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGExternalResourcesRequiredPrototype) };

JSObject* JSSVGExternalResourcesRequiredPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGExternalResourcesRequired>(exec, globalObject);
}

const ClassInfo JSSVGExternalResourcesRequired::s_info = { "SVGExternalResourcesRequired", &Base::s_info, &JSSVGExternalResourcesRequiredTable, 0 , CREATE_METHOD_TABLE(JSSVGExternalResourcesRequired) };

JSSVGExternalResourcesRequired::JSSVGExternalResourcesRequired(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGExternalResourcesRequired> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGExternalResourcesRequired::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGExternalResourcesRequired::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGExternalResourcesRequiredPrototype::create(exec->vm(), globalObject, JSSVGExternalResourcesRequiredPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGExternalResourcesRequired::destroy(JSC::JSCell* cell)
{
    JSSVGExternalResourcesRequired* thisObject = static_cast<JSSVGExternalResourcesRequired*>(cell);
    thisObject->JSSVGExternalResourcesRequired::~JSSVGExternalResourcesRequired();
}

JSSVGExternalResourcesRequired::~JSSVGExternalResourcesRequired()
{
    releaseImplIfNotNull();
}

bool JSSVGExternalResourcesRequired::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGExternalResourcesRequired* thisObject = jsCast<JSSVGExternalResourcesRequired*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGExternalResourcesRequired, Base>(exec, &JSSVGExternalResourcesRequiredTable, thisObject, propertyName, slot);
}

bool JSSVGExternalResourcesRequired::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGExternalResourcesRequired* thisObject = jsCast<JSSVGExternalResourcesRequired*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGExternalResourcesRequired, Base>(exec, &JSSVGExternalResourcesRequiredTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGExternalResourcesRequiredExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGExternalResourcesRequired* castedThis = jsCast<JSSVGExternalResourcesRequired*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGExternalResourcesRequired* impl = static_cast<SVGExternalResourcesRequired*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


static inline bool isObservable(JSSVGExternalResourcesRequired* jsSVGExternalResourcesRequired)
{
    if (jsSVGExternalResourcesRequired->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGExternalResourcesRequiredOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGExternalResourcesRequired* jsSVGExternalResourcesRequired = jsCast<JSSVGExternalResourcesRequired*>(handle.get().asCell());
    if (!isObservable(jsSVGExternalResourcesRequired))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGExternalResourcesRequiredOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGExternalResourcesRequired* jsSVGExternalResourcesRequired = jsCast<JSSVGExternalResourcesRequired*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGExternalResourcesRequired->impl(), jsSVGExternalResourcesRequired);
    jsSVGExternalResourcesRequired->releaseImpl();
}

SVGExternalResourcesRequired* toSVGExternalResourcesRequired(JSC::JSValue value)
{
    return value.inherits(&JSSVGExternalResourcesRequired::s_info) ? jsCast<JSSVGExternalResourcesRequired*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
