/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGDescElement.h"

#include "KURL.h"
#include "SVGDescElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGDescElementTableValues[] =
{
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementXmllang), (intptr_t)setJSSVGDescElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementXmlspace), (intptr_t)setJSSVGDescElementXmlspace, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDescElementTable = { 9, 7, JSSVGDescElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGDescElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDescElementConstructorTable = { 1, 0, JSSVGDescElementConstructorTableValues, 0 };
const ClassInfo JSSVGDescElementConstructor::s_info = { "SVGDescElementConstructor", &Base::s_info, &JSSVGDescElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGDescElementConstructor) };

JSSVGDescElementConstructor::JSSVGDescElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGDescElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGDescElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGDescElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDescElementConstructor, JSDOMWrapper>(exec, &JSSVGDescElementConstructorTable, jsCast<JSSVGDescElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGDescElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGDescElementConstructor, JSDOMWrapper>(exec, &JSSVGDescElementConstructorTable, jsCast<JSSVGDescElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGDescElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDescElementPrototypeTable = { 1, 0, JSSVGDescElementPrototypeTableValues, 0 };
const ClassInfo JSSVGDescElementPrototype::s_info = { "SVGDescElementPrototype", &Base::s_info, &JSSVGDescElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGDescElementPrototype) };

JSObject* JSSVGDescElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGDescElement>(exec, globalObject);
}

const ClassInfo JSSVGDescElement::s_info = { "SVGDescElement", &Base::s_info, &JSSVGDescElementTable, 0 , CREATE_METHOD_TABLE(JSSVGDescElement) };

JSSVGDescElement::JSSVGDescElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGDescElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGDescElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGDescElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGDescElementPrototype::create(exec->vm(), globalObject, JSSVGDescElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGDescElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGDescElement* thisObject = jsCast<JSSVGDescElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGDescElement, Base>(exec, &JSSVGDescElementTable, thisObject, propertyName, slot);
}

bool JSSVGDescElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGDescElement* thisObject = jsCast<JSSVGDescElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGDescElement, Base>(exec, &JSSVGDescElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGDescElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGDescElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGDescElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* domObject = jsCast<JSSVGDescElement*>(asObject(slotBase));
    return JSSVGDescElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGDescElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGDescElement* thisObject = jsCast<JSSVGDescElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGDescElement, Base>(exec, propertyName, value, &JSSVGDescElementTable, thisObject, slot);
}

void setJSSVGDescElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(thisObject);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGDescElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(thisObject);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


JSValue JSSVGDescElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGDescElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
