/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedPreserveAspectRatio.h"

#include "JSSVGPreserveAspectRatio.h"
#include "SVGPreserveAspectRatio.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedPreserveAspectRatioTableValues[] =
{
    { "baseVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedPreserveAspectRatioBaseVal), (intptr_t)0, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedPreserveAspectRatioAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedPreserveAspectRatioConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedPreserveAspectRatioTable = { 8, 7, JSSVGAnimatedPreserveAspectRatioTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedPreserveAspectRatioConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedPreserveAspectRatioConstructorTable = { 1, 0, JSSVGAnimatedPreserveAspectRatioConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedPreserveAspectRatioConstructor::s_info = { "SVGAnimatedPreserveAspectRatioConstructor", &Base::s_info, &JSSVGAnimatedPreserveAspectRatioConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedPreserveAspectRatioConstructor) };

JSSVGAnimatedPreserveAspectRatioConstructor::JSSVGAnimatedPreserveAspectRatioConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedPreserveAspectRatioConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAnimatedPreserveAspectRatioPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAnimatedPreserveAspectRatioConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedPreserveAspectRatioConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedPreserveAspectRatioConstructorTable, jsCast<JSSVGAnimatedPreserveAspectRatioConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedPreserveAspectRatioConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedPreserveAspectRatioConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedPreserveAspectRatioConstructorTable, jsCast<JSSVGAnimatedPreserveAspectRatioConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedPreserveAspectRatioPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedPreserveAspectRatioPrototypeTable = { 1, 0, JSSVGAnimatedPreserveAspectRatioPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedPreserveAspectRatioPrototype::s_info = { "SVGAnimatedPreserveAspectRatioPrototype", &Base::s_info, &JSSVGAnimatedPreserveAspectRatioPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedPreserveAspectRatioPrototype) };

JSObject* JSSVGAnimatedPreserveAspectRatioPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedPreserveAspectRatio>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedPreserveAspectRatio::s_info = { "SVGAnimatedPreserveAspectRatio", &Base::s_info, &JSSVGAnimatedPreserveAspectRatioTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedPreserveAspectRatio) };

JSSVGAnimatedPreserveAspectRatio::JSSVGAnimatedPreserveAspectRatio(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedPreserveAspectRatio> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedPreserveAspectRatio::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedPreserveAspectRatio::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedPreserveAspectRatioPrototype::create(exec->vm(), globalObject, JSSVGAnimatedPreserveAspectRatioPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedPreserveAspectRatio::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedPreserveAspectRatio* thisObject = static_cast<JSSVGAnimatedPreserveAspectRatio*>(cell);
    thisObject->JSSVGAnimatedPreserveAspectRatio::~JSSVGAnimatedPreserveAspectRatio();
}

JSSVGAnimatedPreserveAspectRatio::~JSSVGAnimatedPreserveAspectRatio()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedPreserveAspectRatio::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedPreserveAspectRatio* thisObject = jsCast<JSSVGAnimatedPreserveAspectRatio*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedPreserveAspectRatio, Base>(exec, &JSSVGAnimatedPreserveAspectRatioTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedPreserveAspectRatio::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedPreserveAspectRatio* thisObject = jsCast<JSSVGAnimatedPreserveAspectRatio*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedPreserveAspectRatio, Base>(exec, &JSSVGAnimatedPreserveAspectRatioTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedPreserveAspectRatioBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedPreserveAspectRatio* castedThis = jsCast<JSSVGAnimatedPreserveAspectRatio*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedPreserveAspectRatio* impl = static_cast<SVGAnimatedPreserveAspectRatio*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<SVGPreserveAspectRatio>*>(impl->baseVal())));
    return result;
}


JSValue jsSVGAnimatedPreserveAspectRatioAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedPreserveAspectRatio* castedThis = jsCast<JSSVGAnimatedPreserveAspectRatio*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedPreserveAspectRatio* impl = static_cast<SVGAnimatedPreserveAspectRatio*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<SVGPreserveAspectRatio>*>(impl->animVal())));
    return result;
}


JSValue jsSVGAnimatedPreserveAspectRatioConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedPreserveAspectRatio* domObject = jsCast<JSSVGAnimatedPreserveAspectRatio*>(asObject(slotBase));
    return JSSVGAnimatedPreserveAspectRatio::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAnimatedPreserveAspectRatio::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedPreserveAspectRatioConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedPreserveAspectRatio* jsSVGAnimatedPreserveAspectRatio)
{
    if (jsSVGAnimatedPreserveAspectRatio->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedPreserveAspectRatioOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedPreserveAspectRatio* jsSVGAnimatedPreserveAspectRatio = jsCast<JSSVGAnimatedPreserveAspectRatio*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedPreserveAspectRatio))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedPreserveAspectRatioOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedPreserveAspectRatio* jsSVGAnimatedPreserveAspectRatio = jsCast<JSSVGAnimatedPreserveAspectRatio*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedPreserveAspectRatio->impl(), jsSVGAnimatedPreserveAspectRatio);
    jsSVGAnimatedPreserveAspectRatio->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedPreserveAspectRatio* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedPreserveAspectRatio>(exec, impl))
        return result;
    ReportMemoryCost<SVGAnimatedPreserveAspectRatio>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGAnimatedPreserveAspectRatio>(exec, globalObject, impl);
}

SVGAnimatedPreserveAspectRatio* toSVGAnimatedPreserveAspectRatio(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedPreserveAspectRatio::s_info) ? jsCast<JSSVGAnimatedPreserveAspectRatio*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
