/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedLength.h"

#include "JSSVGLength.h"
#include "SVGLength.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedLengthTableValues[] =
{
    { "baseVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedLengthBaseVal), (intptr_t)0, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedLengthAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedLengthConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedLengthTable = { 8, 7, JSSVGAnimatedLengthTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedLengthConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedLengthConstructorTable = { 1, 0, JSSVGAnimatedLengthConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedLengthConstructor::s_info = { "SVGAnimatedLengthConstructor", &Base::s_info, &JSSVGAnimatedLengthConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedLengthConstructor) };

JSSVGAnimatedLengthConstructor::JSSVGAnimatedLengthConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedLengthConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAnimatedLengthPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAnimatedLengthConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedLengthConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedLengthConstructorTable, jsCast<JSSVGAnimatedLengthConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedLengthConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedLengthConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedLengthConstructorTable, jsCast<JSSVGAnimatedLengthConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedLengthPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedLengthPrototypeTable = { 1, 0, JSSVGAnimatedLengthPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedLengthPrototype::s_info = { "SVGAnimatedLengthPrototype", &Base::s_info, &JSSVGAnimatedLengthPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedLengthPrototype) };

JSObject* JSSVGAnimatedLengthPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedLength>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedLength::s_info = { "SVGAnimatedLength", &Base::s_info, &JSSVGAnimatedLengthTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedLength) };

JSSVGAnimatedLength::JSSVGAnimatedLength(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedLength> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedLength::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedLength::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedLengthPrototype::create(exec->vm(), globalObject, JSSVGAnimatedLengthPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedLength::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedLength* thisObject = static_cast<JSSVGAnimatedLength*>(cell);
    thisObject->JSSVGAnimatedLength::~JSSVGAnimatedLength();
}

JSSVGAnimatedLength::~JSSVGAnimatedLength()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedLength::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedLength* thisObject = jsCast<JSSVGAnimatedLength*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedLength, Base>(exec, &JSSVGAnimatedLengthTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedLength::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedLength* thisObject = jsCast<JSSVGAnimatedLength*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedLength, Base>(exec, &JSSVGAnimatedLengthTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedLengthBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedLength* castedThis = jsCast<JSSVGAnimatedLength*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedLength* impl = static_cast<SVGAnimatedLength*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<SVGLength>*>(impl->baseVal())));
    return result;
}


JSValue jsSVGAnimatedLengthAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedLength* castedThis = jsCast<JSSVGAnimatedLength*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedLength* impl = static_cast<SVGAnimatedLength*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<SVGLength>*>(impl->animVal())));
    return result;
}


JSValue jsSVGAnimatedLengthConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedLength* domObject = jsCast<JSSVGAnimatedLength*>(asObject(slotBase));
    return JSSVGAnimatedLength::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAnimatedLength::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedLengthConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedLength* jsSVGAnimatedLength)
{
    if (jsSVGAnimatedLength->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedLengthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedLength* jsSVGAnimatedLength = jsCast<JSSVGAnimatedLength*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedLength))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedLengthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedLength* jsSVGAnimatedLength = jsCast<JSSVGAnimatedLength*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedLength->impl(), jsSVGAnimatedLength);
    jsSVGAnimatedLength->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedLength* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedLength>(exec, impl))
        return result;
    ReportMemoryCost<SVGAnimatedLength>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGAnimatedLength>(exec, globalObject, impl);
}

SVGAnimatedLength* toSVGAnimatedLength(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedLength::s_info) ? jsCast<JSSVGAnimatedLength*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
