/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGAElement.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAElementTableValues[] =
{
    { "target", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementTarget), (intptr_t)0, NoIntrinsic },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementHref), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementXmllang), (intptr_t)setJSSVGAElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementXmlspace), (intptr_t)setJSSVGAElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAElementTable = { 34, 31, JSSVGAElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAElementConstructorTable = { 1, 0, JSSVGAElementConstructorTableValues, 0 };
const ClassInfo JSSVGAElementConstructor::s_info = { "SVGAElementConstructor", &Base::s_info, &JSSVGAElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAElementConstructor) };

JSSVGAElementConstructor::JSSVGAElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAElementConstructor, JSDOMWrapper>(exec, &JSSVGAElementConstructorTable, jsCast<JSSVGAElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGAElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAElementConstructor, JSDOMWrapper>(exec, &JSSVGAElementConstructorTable, jsCast<JSSVGAElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAElementPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAElementPrototypeFunctionGetTransformToElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAElementPrototypeTable = { 17, 15, JSSVGAElementPrototypeTableValues, 0 };
const ClassInfo JSSVGAElementPrototype::s_info = { "SVGAElementPrototype", &Base::s_info, &JSSVGAElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAElementPrototype) };

JSObject* JSSVGAElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAElement>(exec, globalObject);
}

bool JSSVGAElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAElementPrototype* thisObject = jsCast<JSSVGAElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGAElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGAElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAElementPrototype* thisObject = jsCast<JSSVGAElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGAElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGAElement::s_info = { "SVGAElement", &Base::s_info, &JSSVGAElementTable, 0 , CREATE_METHOD_TABLE(JSSVGAElement) };

JSSVGAElement::JSSVGAElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGAElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAElementPrototype::create(exec->vm(), globalObject, JSSVGAElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGAElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAElement* thisObject = jsCast<JSSVGAElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAElement, Base>(exec, &JSSVGAElementTable, thisObject, propertyName, slot);
}

bool JSSVGAElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAElement* thisObject = jsCast<JSSVGAElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAElement, Base>(exec, &JSSVGAElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAElementTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->svgTargetAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGAElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGAElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGAElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGAElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGAElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGAElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGAElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGAElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGAElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGAElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGAElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* domObject = jsCast<JSSVGAElement*>(asObject(slotBase));
    return JSSVGAElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGAElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGAElement* thisObject = jsCast<JSSVGAElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGAElement, Base>(exec, propertyName, value, &JSSVGAElementTable, thisObject, slot);
}

void setJSSVGAElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(thisObject);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGAElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(thisObject);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


JSValue JSSVGAElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGAElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAElement::s_info);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAElement::s_info);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAElement::s_info);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAElement::s_info);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAElement::s_info);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
