/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SQL_DATABASE)

#include "JSSQLResultSet.h"

#include "JSSQLResultSetRowList.h"
#include "SQLResultSet.h"
#include "SQLResultSetRowList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSQLResultSetTableValues[] =
{
    { "rows", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRows), (intptr_t)0, NoIntrinsic },
    { "insertId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetInsertId), (intptr_t)0, NoIntrinsic },
    { "rowsAffected", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRowsAffected), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSQLResultSetTable = { 9, 7, JSSQLResultSetTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSQLResultSetPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSQLResultSetPrototypeTable = { 1, 0, JSSQLResultSetPrototypeTableValues, 0 };
static const HashTable* getJSSQLResultSetPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSSQLResultSetPrototypeTable);
}

const ClassInfo JSSQLResultSetPrototype::s_info = { "SQLResultSetPrototype", &Base::s_info, 0, getJSSQLResultSetPrototypeTable, CREATE_METHOD_TABLE(JSSQLResultSetPrototype) };

JSObject* JSSQLResultSetPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLResultSet>(exec, globalObject);
}

static const HashTable* getJSSQLResultSetTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSSQLResultSetTable);
}

const ClassInfo JSSQLResultSet::s_info = { "SQLResultSet", &Base::s_info, 0, getJSSQLResultSetTable , CREATE_METHOD_TABLE(JSSQLResultSet) };

JSSQLResultSet::JSSQLResultSet(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SQLResultSet> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSQLResultSet::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSQLResultSet::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSQLResultSetPrototype::create(exec->vm(), globalObject, JSSQLResultSetPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSQLResultSet::destroy(JSC::JSCell* cell)
{
    JSSQLResultSet* thisObject = static_cast<JSSQLResultSet*>(cell);
    thisObject->JSSQLResultSet::~JSSQLResultSet();
}

JSSQLResultSet::~JSSQLResultSet()
{
    releaseImplIfNotNull();
}

bool JSSQLResultSet::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSQLResultSet* thisObject = jsCast<JSSQLResultSet*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSQLResultSet, Base>(exec, getJSSQLResultSetTable(exec), thisObject, propertyName, slot);
}

bool JSSQLResultSet::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSQLResultSet* thisObject = jsCast<JSSQLResultSet*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSQLResultSet, Base>(exec, getJSSQLResultSetTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsSQLResultSetRows(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSQLResultSet* castedThis = jsCast<JSSQLResultSet*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SQLResultSet* impl = static_cast<SQLResultSet*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->rows()));
    return result;
}


JSValue jsSQLResultSetInsertId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSQLResultSet* castedThis = jsCast<JSSQLResultSet*>(asObject(slotBase));
    ExceptionCode ec = 0;
    SQLResultSet* impl = static_cast<SQLResultSet*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->insertId(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsSQLResultSetRowsAffected(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSQLResultSet* castedThis = jsCast<JSSQLResultSet*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SQLResultSet* impl = static_cast<SQLResultSet*>(castedThis->impl());
    JSValue result = jsNumber(impl->rowsAffected());
    return result;
}


static inline bool isObservable(JSSQLResultSet* jsSQLResultSet)
{
    if (jsSQLResultSet->hasCustomProperties())
        return true;
    return false;
}

bool JSSQLResultSetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSQLResultSet* jsSQLResultSet = jsCast<JSSQLResultSet*>(handle.get().asCell());
    if (!isObservable(jsSQLResultSet))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLResultSetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSQLResultSet* jsSQLResultSet = jsCast<JSSQLResultSet*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSQLResultSet->impl(), jsSQLResultSet);
    jsSQLResultSet->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SQLResultSet* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLResultSet>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLResultSet.
    COMPILE_ASSERT(!__is_polymorphic(SQLResultSet), SQLResultSet_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<SQLResultSet>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSQLResultSet>(exec, globalObject, impl);
}

SQLResultSet* toSQLResultSet(JSC::JSValue value)
{
    return value.inherits(&JSSQLResultSet::s_info) ? jsCast<JSSQLResultSet*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SQL_DATABASE)
