/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRangeException.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "RangeException.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSRangeExceptionTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionCode), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionName), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionMessage), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSRangeExceptionTable = { 10, 7, JSRangeExceptionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSRangeExceptionConstructorTableValues[] =
{
    { "BAD_BOUNDARYPOINTS_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionBAD_BOUNDARYPOINTS_ERR), (intptr_t)0, NoIntrinsic },
    { "INVALID_NODE_TYPE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionINVALID_NODE_TYPE_ERR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSRangeExceptionConstructorTable = { 4, 3, JSRangeExceptionConstructorTableValues, 0 };
const ClassInfo JSRangeExceptionConstructor::s_info = { "RangeExceptionConstructor", &Base::s_info, &JSRangeExceptionConstructorTable, 0, CREATE_METHOD_TABLE(JSRangeExceptionConstructor) };

JSRangeExceptionConstructor::JSRangeExceptionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSRangeExceptionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSRangeExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSRangeExceptionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeExceptionConstructor, JSDOMWrapper>(exec, &JSRangeExceptionConstructorTable, jsCast<JSRangeExceptionConstructor*>(cell), propertyName, slot);
}

bool JSRangeExceptionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRangeExceptionConstructor, JSDOMWrapper>(exec, &JSRangeExceptionConstructorTable, jsCast<JSRangeExceptionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSRangeExceptionPrototypeTableValues[] =
{
    { "BAD_BOUNDARYPOINTS_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionBAD_BOUNDARYPOINTS_ERR), (intptr_t)0, NoIntrinsic },
    { "INVALID_NODE_TYPE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeExceptionINVALID_NODE_TYPE_ERR), (intptr_t)0, NoIntrinsic },
    { "toString", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsRangeExceptionPrototypeFunctionToString), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSRangeExceptionPrototypeTable = { 8, 7, JSRangeExceptionPrototypeTableValues, 0 };
const ClassInfo JSRangeExceptionPrototype::s_info = { "RangeExceptionPrototype", &Base::s_info, &JSRangeExceptionPrototypeTable, 0, CREATE_METHOD_TABLE(JSRangeExceptionPrototype) };

JSObject* JSRangeExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRangeException>(exec, globalObject);
}

bool JSRangeExceptionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSRangeExceptionPrototype* thisObject = jsCast<JSRangeExceptionPrototype*>(cell);
    return getStaticPropertySlot<JSRangeExceptionPrototype, JSObject>(exec, &JSRangeExceptionPrototypeTable, thisObject, propertyName, slot);
}

bool JSRangeExceptionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSRangeExceptionPrototype* thisObject = jsCast<JSRangeExceptionPrototype*>(object);
    return getStaticPropertyDescriptor<JSRangeExceptionPrototype, JSObject>(exec, &JSRangeExceptionPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSRangeException::s_info = { "RangeException", &Base::s_info, &JSRangeExceptionTable, 0 , CREATE_METHOD_TABLE(JSRangeException) };

JSRangeException::JSRangeException(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<RangeException> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSRangeException::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSRangeException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSRangeExceptionPrototype::create(exec->vm(), globalObject, JSRangeExceptionPrototype::createStructure(globalObject->vm(), globalObject, globalObject->errorPrototype()));
}

void JSRangeException::destroy(JSC::JSCell* cell)
{
    JSRangeException* thisObject = static_cast<JSRangeException*>(cell);
    thisObject->JSRangeException::~JSRangeException();
}

JSRangeException::~JSRangeException()
{
    releaseImplIfNotNull();
}

bool JSRangeException::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSRangeException* thisObject = jsCast<JSRangeException*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSRangeException, Base>(exec, &JSRangeExceptionTable, thisObject, propertyName, slot);
}

bool JSRangeException::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSRangeException* thisObject = jsCast<JSRangeException*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSRangeException, Base>(exec, &JSRangeExceptionTable, thisObject, propertyName, descriptor);
}

JSValue jsRangeExceptionCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRangeException* castedThis = jsCast<JSRangeException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RangeException* impl = static_cast<RangeException*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsRangeExceptionName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRangeException* castedThis = jsCast<JSRangeException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RangeException* impl = static_cast<RangeException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsRangeExceptionMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRangeException* castedThis = jsCast<JSRangeException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RangeException* impl = static_cast<RangeException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


JSValue jsRangeExceptionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSRangeException* domObject = jsCast<JSRangeException*>(asObject(slotBase));
    return JSRangeException::getConstructor(exec, domObject->globalObject());
}

JSValue JSRangeException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRangeExceptionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsRangeExceptionPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRangeException::s_info))
        return throwVMTypeError(exec);
    JSRangeException* castedThis = jsCast<JSRangeException*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSRangeException::s_info);
    RangeException* impl = static_cast<RangeException*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->toString());
    return JSValue::encode(result);
}

// Constant getters

JSValue jsRangeExceptionBAD_BOUNDARYPOINTS_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsRangeExceptionINVALID_NODE_TYPE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSRangeException* jsRangeException)
{
    if (jsRangeException->hasCustomProperties())
        return true;
    return false;
}

bool JSRangeExceptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSRangeException* jsRangeException = jsCast<JSRangeException*>(handle.get().asCell());
    if (!isObservable(jsRangeException))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSRangeExceptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSRangeException* jsRangeException = jsCast<JSRangeException*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsRangeException->impl(), jsRangeException);
    jsRangeException->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, RangeException* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSRangeException>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RangeException.
    COMPILE_ASSERT(!__is_polymorphic(RangeException), RangeException_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<RangeException>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSRangeException>(exec, globalObject, impl);
}

RangeException* toRangeException(JSC::JSValue value)
{
    return value.inherits(&JSRangeException::s_info) ? jsCast<JSRangeException*>(asObject(value))->impl() : 0;
}

}
