/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MICRODATA)

#include "JSPropertyNodeList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSMicroDataItemValue.h"
#include "JSNode.h"
#include "MicroDataItemValue.h"
#include "Node.h"
#include "PropertyNodeList.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPropertyNodeListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPropertyNodeListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPropertyNodeListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPropertyNodeListTable = { 5, 3, JSPropertyNodeListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSPropertyNodeListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPropertyNodeListConstructorTable = { 1, 0, JSPropertyNodeListConstructorTableValues, 0 };
const ClassInfo JSPropertyNodeListConstructor::s_info = { "PropertyNodeListConstructor", &Base::s_info, &JSPropertyNodeListConstructorTable, 0, CREATE_METHOD_TABLE(JSPropertyNodeListConstructor) };

JSPropertyNodeListConstructor::JSPropertyNodeListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPropertyNodeListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSPropertyNodeListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSPropertyNodeListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPropertyNodeListConstructor, JSDOMWrapper>(exec, &JSPropertyNodeListConstructorTable, jsCast<JSPropertyNodeListConstructor*>(cell), propertyName, slot);
}

bool JSPropertyNodeListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPropertyNodeListConstructor, JSDOMWrapper>(exec, &JSPropertyNodeListConstructorTable, jsCast<JSPropertyNodeListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPropertyNodeListPrototypeTableValues[] =
{
    { "getValues", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsPropertyNodeListPrototypeFunctionGetValues), (intptr_t)0, NoIntrinsic },
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsPropertyNodeListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPropertyNodeListPrototypeTable = { 4, 3, JSPropertyNodeListPrototypeTableValues, 0 };
const ClassInfo JSPropertyNodeListPrototype::s_info = { "PropertyNodeListPrototype", &Base::s_info, &JSPropertyNodeListPrototypeTable, 0, CREATE_METHOD_TABLE(JSPropertyNodeListPrototype) };

JSObject* JSPropertyNodeListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPropertyNodeList>(exec, globalObject);
}

bool JSPropertyNodeListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPropertyNodeListPrototype* thisObject = jsCast<JSPropertyNodeListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSPropertyNodeListPrototypeTable, thisObject, propertyName, slot);
}

bool JSPropertyNodeListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPropertyNodeListPrototype* thisObject = jsCast<JSPropertyNodeListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPropertyNodeListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSPropertyNodeList::s_info = { "PropertyNodeList", &Base::s_info, &JSPropertyNodeListTable, 0 , CREATE_METHOD_TABLE(JSPropertyNodeList) };

JSPropertyNodeList::JSPropertyNodeList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PropertyNodeList> impl)
    : JSNodeList(structure, globalObject, impl)
{
}

void JSPropertyNodeList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSPropertyNodeList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPropertyNodeListPrototype::create(exec->vm(), globalObject, JSPropertyNodeListPrototype::createStructure(exec->vm(), globalObject, JSNodeListPrototype::self(exec, globalObject)));
}

bool JSPropertyNodeList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPropertyNodeList* thisObject = jsCast<JSPropertyNodeList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSPropertyNodeList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<PropertyNodeList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSPropertyNodeList, Base>(exec, &JSPropertyNodeListTable, thisObject, propertyName, slot);
}

bool JSPropertyNodeList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPropertyNodeList* thisObject = jsCast<JSPropertyNodeList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSPropertyNodeListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<PropertyNodeList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSPropertyNodeList, Base>(exec, &JSPropertyNodeListTable, thisObject, propertyName, descriptor);
}

bool JSPropertyNodeList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSPropertyNodeList* thisObject = jsCast<JSPropertyNodeList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<PropertyNodeList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsPropertyNodeListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPropertyNodeList* castedThis = jsCast<JSPropertyNodeList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PropertyNodeList* impl = static_cast<PropertyNodeList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsPropertyNodeListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPropertyNodeList* domObject = jsCast<JSPropertyNodeList*>(asObject(slotBase));
    return JSPropertyNodeList::getConstructor(exec, domObject->globalObject());
}

void JSPropertyNodeList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSPropertyNodeList* thisObject = jsCast<JSPropertyNodeList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<PropertyNodeList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSPropertyNodeList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPropertyNodeListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsPropertyNodeListPrototypeFunctionGetValues(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPropertyNodeList::s_info))
        return throwVMTypeError(exec);
    JSPropertyNodeList* castedThis = jsCast<JSPropertyNodeList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPropertyNodeList::s_info);
    PropertyNodeList* impl = static_cast<PropertyNodeList*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->getValues());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsPropertyNodeListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPropertyNodeList::s_info))
        return throwVMTypeError(exec);
    JSPropertyNodeList* castedThis = jsCast<JSPropertyNodeList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPropertyNodeList::s_info);
    PropertyNodeList* impl = static_cast<PropertyNodeList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSPropertyNodeList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSPropertyNodeList* thisObj = jsCast<JSPropertyNodeList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<PropertyNodeList*>(thisObj->impl())->item(index));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PropertyNodeList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16PropertyNodeListE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PropertyNodeList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPropertyNodeList>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7PropertyNodeList@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16PropertyNodeListE[2];
#if COMPILER(CLANG)
    // If this fails PropertyNodeList does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(PropertyNodeList), PropertyNodeList_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // PropertyNodeList has subclasses. If PropertyNodeList has subclasses that get passed
    // to toJS() we currently require PropertyNodeList you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<PropertyNodeList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSPropertyNodeList>(exec, globalObject, impl);
}


}

#endif // ENABLE(MICRODATA)
