/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSPositionError.h"

#include "KURL.h"
#include "PositionError.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPositionErrorTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorCode), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorMessage), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPositionErrorTable = { 4, 3, JSPositionErrorTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSPositionErrorPrototypeTableValues[] =
{
    { "PERMISSION_DENIED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPERMISSION_DENIED), (intptr_t)0, NoIntrinsic },
    { "POSITION_UNAVAILABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorPOSITION_UNAVAILABLE), (intptr_t)0, NoIntrinsic },
    { "TIMEOUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorTIMEOUT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPositionErrorPrototypeTable = { 9, 7, JSPositionErrorPrototypeTableValues, 0 };
const ClassInfo JSPositionErrorPrototype::s_info = { "PositionErrorPrototype", &Base::s_info, &JSPositionErrorPrototypeTable, 0, CREATE_METHOD_TABLE(JSPositionErrorPrototype) };

JSObject* JSPositionErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPositionError>(exec, globalObject);
}

bool JSPositionErrorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPositionErrorPrototype* thisObject = jsCast<JSPositionErrorPrototype*>(cell);
    return getStaticValueSlot<JSPositionErrorPrototype, JSObject>(exec, &JSPositionErrorPrototypeTable, thisObject, propertyName, slot);
}

bool JSPositionErrorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPositionErrorPrototype* thisObject = jsCast<JSPositionErrorPrototype*>(object);
    return getStaticValueDescriptor<JSPositionErrorPrototype, JSObject>(exec, &JSPositionErrorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSPositionError::s_info = { "PositionError", &Base::s_info, &JSPositionErrorTable, 0 , CREATE_METHOD_TABLE(JSPositionError) };

JSPositionError::JSPositionError(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PositionError> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSPositionError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSPositionError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPositionErrorPrototype::create(exec->vm(), globalObject, JSPositionErrorPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSPositionError::destroy(JSC::JSCell* cell)
{
    JSPositionError* thisObject = static_cast<JSPositionError*>(cell);
    thisObject->JSPositionError::~JSPositionError();
}

JSPositionError::~JSPositionError()
{
    releaseImplIfNotNull();
}

bool JSPositionError::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPositionError* thisObject = jsCast<JSPositionError*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPositionError, Base>(exec, &JSPositionErrorTable, thisObject, propertyName, slot);
}

bool JSPositionError::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPositionError* thisObject = jsCast<JSPositionError*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPositionError, Base>(exec, &JSPositionErrorTable, thisObject, propertyName, descriptor);
}

JSValue jsPositionErrorCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPositionError* castedThis = jsCast<JSPositionError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PositionError* impl = static_cast<PositionError*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsPositionErrorMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPositionError* castedThis = jsCast<JSPositionError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PositionError* impl = static_cast<PositionError*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


// Constant getters

JSValue jsPositionErrorPERMISSION_DENIED(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsPositionErrorPOSITION_UNAVAILABLE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsPositionErrorTIMEOUT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

static inline bool isObservable(JSPositionError* jsPositionError)
{
    if (jsPositionError->hasCustomProperties())
        return true;
    return false;
}

bool JSPositionErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSPositionError* jsPositionError = jsCast<JSPositionError*>(handle.get().asCell());
    if (!isObservable(jsPositionError))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSPositionErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSPositionError* jsPositionError = jsCast<JSPositionError*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPositionError->impl(), jsPositionError);
    jsPositionError->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PositionError* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPositionError>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PositionError.
    COMPILE_ASSERT(!__is_polymorphic(PositionError), PositionError_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<PositionError>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSPositionError>(exec, globalObject, impl);
}

PositionError* toPositionError(JSC::JSValue value)
{
    return value.inherits(&JSPositionError::s_info) ? jsCast<JSPositionError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
