/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformance.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSPerformanceNavigation.h"
#include "JSPerformanceTiming.h"
#include "Performance.h"
#include "PerformanceNavigation.h"
#include "PerformanceTiming.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPerformanceTableValues[] =
{
    { "navigation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigation), (intptr_t)0, NoIntrinsic },
    { "timing", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTiming), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceTable = { 8, 7, JSPerformanceTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSPerformanceConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceConstructorTable = { 1, 0, JSPerformanceConstructorTableValues, 0 };
const ClassInfo JSPerformanceConstructor::s_info = { "PerformanceConstructor", &Base::s_info, &JSPerformanceConstructorTable, 0, CREATE_METHOD_TABLE(JSPerformanceConstructor) };

JSPerformanceConstructor::JSPerformanceConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPerformanceConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSPerformancePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSPerformanceConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPerformanceConstructor, JSDOMWrapper>(exec, &JSPerformanceConstructorTable, jsCast<JSPerformanceConstructor*>(cell), propertyName, slot);
}

bool JSPerformanceConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPerformanceConstructor, JSDOMWrapper>(exec, &JSPerformanceConstructorTable, jsCast<JSPerformanceConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPerformancePrototypeTableValues[] =
{
    { "now", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsPerformancePrototypeFunctionNow), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformancePrototypeTable = { 2, 1, JSPerformancePrototypeTableValues, 0 };
const ClassInfo JSPerformancePrototype::s_info = { "PerformancePrototype", &Base::s_info, &JSPerformancePrototypeTable, 0, CREATE_METHOD_TABLE(JSPerformancePrototype) };

JSObject* JSPerformancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformance>(exec, globalObject);
}

bool JSPerformancePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformancePrototype* thisObject = jsCast<JSPerformancePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSPerformancePrototypeTable, thisObject, propertyName, slot);
}

bool JSPerformancePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformancePrototype* thisObject = jsCast<JSPerformancePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPerformancePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSPerformance::s_info = { "Performance", &Base::s_info, &JSPerformanceTable, 0 , CREATE_METHOD_TABLE(JSPerformance) };

JSPerformance::JSPerformance(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Performance> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSPerformance::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSPerformance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPerformancePrototype::create(exec->vm(), globalObject, JSPerformancePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSPerformance::destroy(JSC::JSCell* cell)
{
    JSPerformance* thisObject = static_cast<JSPerformance*>(cell);
    thisObject->JSPerformance::~JSPerformance();
}

JSPerformance::~JSPerformance()
{
    releaseImplIfNotNull();
}

bool JSPerformance::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformance* thisObject = jsCast<JSPerformance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPerformance, Base>(exec, &JSPerformanceTable, thisObject, propertyName, slot);
}

bool JSPerformance::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformance* thisObject = jsCast<JSPerformance*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPerformance, Base>(exec, &JSPerformanceTable, thisObject, propertyName, descriptor);
}

JSValue jsPerformanceNavigation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* impl = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->navigation()));
    return result;
}


JSValue jsPerformanceTiming(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* impl = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->timing()));
    return result;
}


JSValue jsPerformanceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformance* domObject = jsCast<JSPerformance*>(asObject(slotBase));
    return JSPerformance::getConstructor(exec, domObject->globalObject());
}

JSValue JSPerformance::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsPerformancePrototypeFunctionNow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPerformance::s_info))
        return throwVMTypeError(exec);
    JSPerformance* castedThis = jsCast<JSPerformance*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSPerformance::s_info);
    Performance* impl = static_cast<Performance*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->now());
    return JSValue::encode(result);
}

void JSPerformance::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSPerformance* thisObject = jsCast<JSPerformance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSPerformance* jsPerformance)
{
    if (jsPerformance->hasCustomProperties())
        return true;
    if (jsPerformance->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSPerformanceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSPerformance* jsPerformance = jsCast<JSPerformance*>(handle.get().asCell());
    if (jsPerformance->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsPerformance))
        return false;
    Frame* root = jsPerformance->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSPerformanceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSPerformance* jsPerformance = jsCast<JSPerformance*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPerformance->impl(), jsPerformance);
    jsPerformance->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Performance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11PerformanceE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Performance* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPerformance>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Performance@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11PerformanceE[2];
#if COMPILER(CLANG)
    // If this fails Performance does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Performance), Performance_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Performance has subclasses. If Performance has subclasses that get passed
    // to toJS() we currently require Performance you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<Performance>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSPerformance>(exec, globalObject, impl);
}

Performance* toPerformance(JSC::JSValue value)
{
    return value.inherits(&JSPerformance::s_info) ? jsCast<JSPerformance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
