/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOscillatorNode.h"

#include "AudioParam.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSAudioParam.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "JSWaveTable.h"
#include "KURL.h"
#include "OscillatorNode.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSOscillatorNodeTableValues[] =
{
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeType), (intptr_t)setJSOscillatorNodeType, NoIntrinsic },
    { "playbackState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodePlaybackState), (intptr_t)0, NoIntrinsic },
    { "frequency", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeFrequency), (intptr_t)0, NoIntrinsic },
    { "detune", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeDetune), (intptr_t)0, NoIntrinsic },
    { "onended", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeOnended), (intptr_t)setJSOscillatorNodeOnended, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOscillatorNodeTable = { 16, 15, JSOscillatorNodeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSOscillatorNodeConstructorTableValues[] =
{
    { "SINE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSINE), (intptr_t)0, NoIntrinsic },
    { "SQUARE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSQUARE), (intptr_t)0, NoIntrinsic },
    { "SAWTOOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSAWTOOTH), (intptr_t)0, NoIntrinsic },
    { "TRIANGLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeTRIANGLE), (intptr_t)0, NoIntrinsic },
    { "CUSTOM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeCUSTOM), (intptr_t)0, NoIntrinsic },
    { "UNSCHEDULED_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeUNSCHEDULED_STATE), (intptr_t)0, NoIntrinsic },
    { "SCHEDULED_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSCHEDULED_STATE), (intptr_t)0, NoIntrinsic },
    { "PLAYING_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodePLAYING_STATE), (intptr_t)0, NoIntrinsic },
    { "FINISHED_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeFINISHED_STATE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOscillatorNodeConstructorTable = { 33, 31, JSOscillatorNodeConstructorTableValues, 0 };

COMPILE_ASSERT(0 == OscillatorNode::SINE, OscillatorNodeEnumSINEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == OscillatorNode::SQUARE, OscillatorNodeEnumSQUAREIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == OscillatorNode::SAWTOOTH, OscillatorNodeEnumSAWTOOTHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == OscillatorNode::TRIANGLE, OscillatorNodeEnumTRIANGLEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == OscillatorNode::CUSTOM, OscillatorNodeEnumCUSTOMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == OscillatorNode::UNSCHEDULED_STATE, OscillatorNodeEnumUNSCHEDULED_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == OscillatorNode::SCHEDULED_STATE, OscillatorNodeEnumSCHEDULED_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == OscillatorNode::PLAYING_STATE, OscillatorNodeEnumPLAYING_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == OscillatorNode::FINISHED_STATE, OscillatorNodeEnumFINISHED_STATEIsWrongUseDoNotCheckConstants);

const ClassInfo JSOscillatorNodeConstructor::s_info = { "OscillatorNodeConstructor", &Base::s_info, &JSOscillatorNodeConstructorTable, 0, CREATE_METHOD_TABLE(JSOscillatorNodeConstructor) };

JSOscillatorNodeConstructor::JSOscillatorNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSOscillatorNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSOscillatorNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSOscillatorNodeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOscillatorNodeConstructor, JSDOMWrapper>(exec, &JSOscillatorNodeConstructorTable, jsCast<JSOscillatorNodeConstructor*>(cell), propertyName, slot);
}

bool JSOscillatorNodeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSOscillatorNodeConstructor, JSDOMWrapper>(exec, &JSOscillatorNodeConstructorTable, jsCast<JSOscillatorNodeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSOscillatorNodePrototypeTableValues[] =
{
    { "SINE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSINE), (intptr_t)0, NoIntrinsic },
    { "SQUARE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSQUARE), (intptr_t)0, NoIntrinsic },
    { "SAWTOOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSAWTOOTH), (intptr_t)0, NoIntrinsic },
    { "TRIANGLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeTRIANGLE), (intptr_t)0, NoIntrinsic },
    { "CUSTOM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeCUSTOM), (intptr_t)0, NoIntrinsic },
    { "UNSCHEDULED_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeUNSCHEDULED_STATE), (intptr_t)0, NoIntrinsic },
    { "SCHEDULED_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeSCHEDULED_STATE), (intptr_t)0, NoIntrinsic },
    { "PLAYING_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodePLAYING_STATE), (intptr_t)0, NoIntrinsic },
    { "FINISHED_STATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeFINISHED_STATE), (intptr_t)0, NoIntrinsic },
    { "start", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionStart), (intptr_t)1, NoIntrinsic },
    { "stop", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionStop), (intptr_t)1, NoIntrinsic },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteOn", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionNoteOn), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteOff", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionNoteOff), (intptr_t)1, NoIntrinsic },
#endif
    { "setWaveTable", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionSetWaveTable), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOscillatorNodePrototypeTable = { 35, 31, JSOscillatorNodePrototypeTableValues, 0 };
const ClassInfo JSOscillatorNodePrototype::s_info = { "OscillatorNodePrototype", &Base::s_info, &JSOscillatorNodePrototypeTable, 0, CREATE_METHOD_TABLE(JSOscillatorNodePrototype) };

JSObject* JSOscillatorNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOscillatorNode>(exec, globalObject);
}

bool JSOscillatorNodePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSOscillatorNodePrototype* thisObject = jsCast<JSOscillatorNodePrototype*>(cell);
    return getStaticPropertySlot<JSOscillatorNodePrototype, JSObject>(exec, &JSOscillatorNodePrototypeTable, thisObject, propertyName, slot);
}

bool JSOscillatorNodePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSOscillatorNodePrototype* thisObject = jsCast<JSOscillatorNodePrototype*>(object);
    return getStaticPropertyDescriptor<JSOscillatorNodePrototype, JSObject>(exec, &JSOscillatorNodePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSOscillatorNode::s_info = { "OscillatorNode", &Base::s_info, &JSOscillatorNodeTable, 0 , CREATE_METHOD_TABLE(JSOscillatorNode) };

JSOscillatorNode::JSOscillatorNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<OscillatorNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSOscillatorNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSOscillatorNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSOscillatorNodePrototype::create(exec->vm(), globalObject, JSOscillatorNodePrototype::createStructure(exec->vm(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSOscillatorNode::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSOscillatorNode* thisObject = jsCast<JSOscillatorNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSOscillatorNode, Base>(exec, &JSOscillatorNodeTable, thisObject, propertyName, slot);
}

bool JSOscillatorNode::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSOscillatorNode* thisObject = jsCast<JSOscillatorNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSOscillatorNode, Base>(exec, &JSOscillatorNodeTable, thisObject, propertyName, descriptor);
}

JSValue jsOscillatorNodeType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsOscillatorNodePlaybackState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->playbackState());
    return result;
}


JSValue jsOscillatorNodeFrequency(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->frequency()));
    return result;
}


JSValue jsOscillatorNodeDetune(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->detune()));
    return result;
}


JSValue jsOscillatorNodeOnended(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    if (EventListener* listener = impl->onended()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsOscillatorNodeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSOscillatorNode* domObject = jsCast<JSOscillatorNode*>(asObject(slotBase));
    return JSOscillatorNode::getConstructor(exec, domObject->globalObject());
}

void JSOscillatorNode::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSOscillatorNode* thisObject = jsCast<JSOscillatorNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSOscillatorNode, Base>(exec, propertyName, value, &JSOscillatorNodeTable, thisObject, slot);
}

void setJSOscillatorNodeType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSOscillatorNode*>(thisObject)->setType(exec, value);
}


void setJSOscillatorNodeOnended(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(thisObject);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    impl->setOnended(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSOscillatorNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOscillatorNodeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSOscillatorNode::s_info))
        return throwVMTypeError(exec);
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSOscillatorNode::s_info);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double when(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->start(when);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStop(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSOscillatorNode::s_info))
        return throwVMTypeError(exec);
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSOscillatorNode::s_info);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double when(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->stop(when);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionNoteOn(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSOscillatorNode::s_info))
        return throwVMTypeError(exec);
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSOscillatorNode::s_info);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double when(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->noteOn(when);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionNoteOff(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSOscillatorNode::s_info))
        return throwVMTypeError(exec);
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSOscillatorNode::s_info);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double when(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->noteOff(when);
    return JSValue::encode(jsUndefined());
}

#endif

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionSetWaveTable(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSOscillatorNode::s_info))
        return throwVMTypeError(exec);
    JSOscillatorNode* castedThis = jsCast<JSOscillatorNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSOscillatorNode::s_info);
    OscillatorNode* impl = static_cast<OscillatorNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    WaveTable* waveTable(toWaveTable(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWaveTable(waveTable);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsOscillatorNodeSINE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsOscillatorNodeSQUARE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsOscillatorNodeSAWTOOTH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsOscillatorNodeTRIANGLE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsOscillatorNodeCUSTOM(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsOscillatorNodeUNSCHEDULED_STATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsOscillatorNodeSCHEDULED_STATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsOscillatorNodePLAYING_STATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsOscillatorNodeFINISHED_STATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OscillatorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14OscillatorNodeE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, OscillatorNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSOscillatorNode>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7OscillatorNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14OscillatorNodeE[2];
#if COMPILER(CLANG)
    // If this fails OscillatorNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(OscillatorNode), OscillatorNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // OscillatorNode has subclasses. If OscillatorNode has subclasses that get passed
    // to toJS() we currently require OscillatorNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<OscillatorNode>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSOscillatorNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
