/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigator.h"

#include "DOMMimeTypeArray.h"
#include "DOMPluginArray.h"
#include "ExceptionCode.h"
#include "GamepadList.h"
#include "JSDOMBinding.h"
#include "JSDOMMimeTypeArray.h"
#include "JSDOMPluginArray.h"
#include "KURL.h"
#include "Navigator.h"
#include "NavigatorGamepad.h"
#include "NavigatorGeolocation.h"
#include "NavigatorStorageQuota.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(GAMEPAD)
#include "JSGamepadList.h"
#endif

#if ENABLE(GEOLOCATION)
#include "Geolocation.h"
#include "JSGeolocation.h"
#endif

#if ENABLE(QUOTA)
#include "JSStorageQuota.h"
#include "StorageQuota.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNavigatorTableValues[] =
{
    { "appCodeName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorAppCodeName), (intptr_t)0, NoIntrinsic },
    { "appName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorAppName), (intptr_t)0, NoIntrinsic },
    { "appVersion", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorAppVersion), (intptr_t)0, NoIntrinsic },
    { "language", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorLanguage), (intptr_t)0, NoIntrinsic },
    { "userAgent", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorUserAgent), (intptr_t)0, NoIntrinsic },
    { "platform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorPlatform), (intptr_t)0, NoIntrinsic },
    { "plugins", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorPlugins), (intptr_t)0, NoIntrinsic },
    { "mimeTypes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorMimeTypes), (intptr_t)0, NoIntrinsic },
    { "product", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorProduct), (intptr_t)0, NoIntrinsic },
    { "productSub", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorProductSub), (intptr_t)0, NoIntrinsic },
    { "vendor", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorVendor), (intptr_t)0, NoIntrinsic },
    { "vendorSub", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorVendorSub), (intptr_t)0, NoIntrinsic },
    { "cookieEnabled", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorCookieEnabled), (intptr_t)0, NoIntrinsic },
    { "onLine", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorOnLine), (intptr_t)0, NoIntrinsic },
#if ENABLE(QUOTA)
    { "webkitTemporaryStorage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorWebkitTemporaryStorage), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(QUOTA)
    { "webkitPersistentStorage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorWebkitPersistentStorage), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(GEOLOCATION)
    { "geolocation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorGeolocation), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNavigatorTable = { 68, 63, JSNavigatorTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSNavigatorConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNavigatorConstructorTable = { 1, 0, JSNavigatorConstructorTableValues, 0 };
const ClassInfo JSNavigatorConstructor::s_info = { "NavigatorConstructor", &Base::s_info, &JSNavigatorConstructorTable, 0, CREATE_METHOD_TABLE(JSNavigatorConstructor) };

JSNavigatorConstructor::JSNavigatorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSNavigatorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSNavigatorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSNavigatorConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigatorConstructor, JSDOMWrapper>(exec, &JSNavigatorConstructorTable, jsCast<JSNavigatorConstructor*>(cell), propertyName, slot);
}

bool JSNavigatorConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNavigatorConstructor, JSDOMWrapper>(exec, &JSNavigatorConstructorTable, jsCast<JSNavigatorConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSNavigatorPrototypeTableValues[] =
{
    { "javaEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionJavaEnabled), (intptr_t)0, NoIntrinsic },
    { "getStorageUpdates", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionGetStorageUpdates), (intptr_t)0, NoIntrinsic },
#if ENABLE(GAMEPAD)
    { "webkitGetGamepads", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionWebkitGetGamepads), (intptr_t)0, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNavigatorPrototypeTable = { 9, 7, JSNavigatorPrototypeTableValues, 0 };
const ClassInfo JSNavigatorPrototype::s_info = { "NavigatorPrototype", &Base::s_info, &JSNavigatorPrototypeTable, 0, CREATE_METHOD_TABLE(JSNavigatorPrototype) };

JSObject* JSNavigatorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNavigator>(exec, globalObject);
}

bool JSNavigatorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNavigatorPrototype* thisObject = jsCast<JSNavigatorPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSNavigatorPrototypeTable, thisObject, propertyName, slot);
}

bool JSNavigatorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNavigatorPrototype* thisObject = jsCast<JSNavigatorPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNavigatorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNavigator::s_info = { "Navigator", &Base::s_info, &JSNavigatorTable, 0 , CREATE_METHOD_TABLE(JSNavigator) };

JSNavigator::JSNavigator(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Navigator> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNavigator::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSNavigator::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNavigatorPrototype::create(exec->vm(), globalObject, JSNavigatorPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSNavigator::destroy(JSC::JSCell* cell)
{
    JSNavigator* thisObject = static_cast<JSNavigator*>(cell);
    thisObject->JSNavigator::~JSNavigator();
}

JSNavigator::~JSNavigator()
{
    releaseImplIfNotNull();
}

bool JSNavigator::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNavigator* thisObject = jsCast<JSNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSNavigator, Base>(exec, &JSNavigatorTable, thisObject, propertyName, slot);
}

bool JSNavigator::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNavigator* thisObject = jsCast<JSNavigator*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSNavigator, Base>(exec, &JSNavigatorTable, thisObject, propertyName, descriptor);
}

JSValue jsNavigatorAppCodeName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appCodeName());
    return result;
}


JSValue jsNavigatorAppName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appName());
    return result;
}


JSValue jsNavigatorAppVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appVersion());
    return result;
}


JSValue jsNavigatorLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->language());
    return result;
}


JSValue jsNavigatorUserAgent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->userAgent());
    return result;
}


JSValue jsNavigatorPlatform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->platform());
    return result;
}


JSValue jsNavigatorPlugins(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->plugins()));
    return result;
}


JSValue jsNavigatorMimeTypes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->mimeTypes()));
    return result;
}


JSValue jsNavigatorProduct(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->product());
    return result;
}


JSValue jsNavigatorProductSub(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->productSub());
    return result;
}


JSValue jsNavigatorVendor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->vendor());
    return result;
}


JSValue jsNavigatorVendorSub(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->vendorSub());
    return result;
}


JSValue jsNavigatorCookieEnabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsBoolean(impl->cookieEnabled());
    return result;
}


JSValue jsNavigatorOnLine(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsBoolean(impl->onLine());
    return result;
}


#if ENABLE(QUOTA)
JSValue jsNavigatorWebkitTemporaryStorage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(NavigatorStorageQuota::webkitTemporaryStorage(impl)));
    return result;
}

#endif

#if ENABLE(QUOTA)
JSValue jsNavigatorWebkitPersistentStorage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(NavigatorStorageQuota::webkitPersistentStorage(impl)));
    return result;
}

#endif

#if ENABLE(GEOLOCATION)
JSValue jsNavigatorGeolocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(NavigatorGeolocation::geolocation(impl)));
    return result;
}

#endif

JSValue jsNavigatorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* domObject = jsCast<JSNavigator*>(asObject(slotBase));
    return JSNavigator::getConstructor(exec, domObject->globalObject());
}

JSValue JSNavigator::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigatorConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionJavaEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->javaEnabled());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionGetStorageUpdates(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    impl->getStorageUpdates();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(GAMEPAD)
EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionWebkitGetGamepads(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(NavigatorGamepad::webkitGetGamepads(impl)));
    return JSValue::encode(result);
}

#endif

static inline bool isObservable(JSNavigator* jsNavigator)
{
    if (jsNavigator->hasCustomProperties())
        return true;
    return false;
}

bool JSNavigatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNavigator* jsNavigator = jsCast<JSNavigator*>(handle.get().asCell());
    if (!isObservable(jsNavigator))
        return false;
    Frame* root = jsNavigator->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSNavigatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNavigator* jsNavigator = jsCast<JSNavigator*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigator->impl(), jsNavigator);
    jsNavigator->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Navigator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9NavigatorE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Navigator* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSNavigator>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Navigator@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9NavigatorE[2];
#if COMPILER(CLANG)
    // If this fails Navigator does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Navigator), Navigator_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Navigator has subclasses. If Navigator has subclasses that get passed
    // to toJS() we currently require Navigator you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<Navigator>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSNavigator>(exec, globalObject, impl);
}

Navigator* toNavigator(JSC::JSValue value)
{
    return value.inherits(&JSNavigator::s_info) ? jsCast<JSNavigator*>(asObject(value))->impl() : 0;
}

}
