/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MICRODATA)

#include "JSMicroDataItemValue.h"

#include "MicroDataItemValue.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSMicroDataItemValuePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMicroDataItemValuePrototypeTable = { 1, 0, JSMicroDataItemValuePrototypeTableValues, 0 };
const ClassInfo JSMicroDataItemValuePrototype::s_info = { "MicroDataItemValuePrototype", &Base::s_info, &JSMicroDataItemValuePrototypeTable, 0, CREATE_METHOD_TABLE(JSMicroDataItemValuePrototype) };

JSObject* JSMicroDataItemValuePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMicroDataItemValue>(exec, globalObject);
}

const ClassInfo JSMicroDataItemValue::s_info = { "MicroDataItemValue", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSMicroDataItemValue) };

JSMicroDataItemValue::JSMicroDataItemValue(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MicroDataItemValue> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMicroDataItemValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMicroDataItemValue::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMicroDataItemValuePrototype::create(exec->vm(), globalObject, JSMicroDataItemValuePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSMicroDataItemValue::destroy(JSC::JSCell* cell)
{
    JSMicroDataItemValue* thisObject = static_cast<JSMicroDataItemValue*>(cell);
    thisObject->JSMicroDataItemValue::~JSMicroDataItemValue();
}

JSMicroDataItemValue::~JSMicroDataItemValue()
{
    releaseImplIfNotNull();
}

static inline bool isObservable(JSMicroDataItemValue* jsMicroDataItemValue)
{
    if (jsMicroDataItemValue->hasCustomProperties())
        return true;
    return false;
}

bool JSMicroDataItemValueOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMicroDataItemValue* jsMicroDataItemValue = jsCast<JSMicroDataItemValue*>(handle.get().asCell());
    if (!isObservable(jsMicroDataItemValue))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMicroDataItemValueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMicroDataItemValue* jsMicroDataItemValue = jsCast<JSMicroDataItemValue*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMicroDataItemValue->impl(), jsMicroDataItemValue);
    jsMicroDataItemValue->releaseImpl();
}

MicroDataItemValue* toMicroDataItemValue(JSC::JSValue value)
{
    return value.inherits(&JSMicroDataItemValue::s_info) ? jsCast<JSMicroDataItemValue*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MICRODATA)
