/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSMediaSource.h"

#include "Event.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSSourceBuffer.h"
#include "JSSourceBufferList.h"
#include "KURL.h"
#include "MediaSource.h"
#include "SourceBuffer.h"
#include "SourceBufferList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaSourceTableValues[] =
{
    { "sourceBuffers", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceSourceBuffers), (intptr_t)0, NoIntrinsic },
    { "activeSourceBuffers", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceActiveSourceBuffers), (intptr_t)0, NoIntrinsic },
    { "duration", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceDuration), (intptr_t)setJSMediaSourceDuration, NoIntrinsic },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceReadyState), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaSourceTable = { 16, 15, JSMediaSourceTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaSourceConstructorTableValues[] =
{
    { "isTypeSupported", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourceConstructorFunctionIsTypeSupported), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaSourceConstructorTable = { 1, 0, JSMediaSourceConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMediaSourceConstructor::constructJSMediaSource(ExecState* exec)
{
    JSMediaSourceConstructor* castedThis = jsCast<JSMediaSourceConstructor*>(exec->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "MediaSource constructor associated document is unavailable"));
    RefPtr<MediaSource> object = MediaSource::create(context);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSMediaSourceConstructor::s_info = { "WebKitMediaSourceConstructor", &Base::s_info, &JSMediaSourceConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaSourceConstructor) };

JSMediaSourceConstructor::JSMediaSourceConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaSourceConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaSourcePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaSourceConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSMediaSourceConstructor, JSDOMWrapper>(exec, &JSMediaSourceConstructorTable, jsCast<JSMediaSourceConstructor*>(cell), propertyName, slot);
}

bool JSMediaSourceConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSMediaSourceConstructor, JSDOMWrapper>(exec, &JSMediaSourceConstructorTable, jsCast<JSMediaSourceConstructor*>(object), propertyName, descriptor);
}

ConstructType JSMediaSourceConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMediaSource;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMediaSourcePrototypeTableValues[] =
{
    { "addSourceBuffer", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionAddSourceBuffer), (intptr_t)1, NoIntrinsic },
    { "removeSourceBuffer", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionRemoveSourceBuffer), (intptr_t)1, NoIntrinsic },
    { "endOfStream", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionEndOfStream), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaSourcePrototypeTable = { 17, 15, JSMediaSourcePrototypeTableValues, 0 };
const ClassInfo JSMediaSourcePrototype::s_info = { "WebKitMediaSourcePrototype", &Base::s_info, &JSMediaSourcePrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaSourcePrototype) };

JSObject* JSMediaSourcePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaSource>(exec, globalObject);
}

bool JSMediaSourcePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaSourcePrototype* thisObject = jsCast<JSMediaSourcePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaSourcePrototypeTable, thisObject, propertyName, slot);
}

bool JSMediaSourcePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaSourcePrototype* thisObject = jsCast<JSMediaSourcePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMediaSourcePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMediaSource::s_info = { "WebKitMediaSource", &Base::s_info, &JSMediaSourceTable, 0 , CREATE_METHOD_TABLE(JSMediaSource) };

JSMediaSource::JSMediaSource(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaSource> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMediaSource::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaSource::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaSourcePrototype::create(exec->vm(), globalObject, JSMediaSourcePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSMediaSource::destroy(JSC::JSCell* cell)
{
    JSMediaSource* thisObject = static_cast<JSMediaSource*>(cell);
    thisObject->JSMediaSource::~JSMediaSource();
}

JSMediaSource::~JSMediaSource()
{
    releaseImplIfNotNull();
}

bool JSMediaSource::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaSource* thisObject = jsCast<JSMediaSource*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaSource, Base>(exec, &JSMediaSourceTable, thisObject, propertyName, slot);
}

bool JSMediaSource::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaSource* thisObject = jsCast<JSMediaSource*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaSource, Base>(exec, &JSMediaSourceTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaSourceSourceBuffers(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->sourceBuffers()));
    return result;
}


JSValue jsMediaSourceActiveSourceBuffers(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->activeSourceBuffers()));
    return result;
}


JSValue jsMediaSourceDuration(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    JSValue result = jsNumber(impl->duration());
    return result;
}


JSValue jsMediaSourceReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->readyState());
    return result;
}


JSValue jsMediaSourceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaSource* domObject = jsCast<JSMediaSource*>(asObject(slotBase));
    return JSMediaSource::getConstructor(exec, domObject->globalObject());
}

void JSMediaSource::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSMediaSource* thisObject = jsCast<JSMediaSource*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSMediaSource, Base>(exec, propertyName, value, &JSMediaSourceTable, thisObject, slot);
}

void setJSMediaSourceDuration(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(thisObject);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    ExceptionCode ec = 0;
    double nativeValue(value.toNumber(exec));
    if (exec->hadException())
        return;
    impl->setDuration(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSMediaSource::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSourceConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionAddSourceBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaSource::s_info))
        return throwVMTypeError(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaSource::s_info);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->addSourceBuffer(type, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionRemoveSourceBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaSource::s_info))
        return throwVMTypeError(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaSource::s_info);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    SourceBuffer* buffer(toSourceBuffer(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->removeSourceBuffer(buffer, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionEndOfStream(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaSource::s_info))
        return throwVMTypeError(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaSource::s_info);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& error(argumentOrNull(exec, 0).isEmpty() ? String() : argumentOrNull(exec, 0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->endOfStream(error, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourceConstructorFunctionIsTypeSupported(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(MediaSource::isTypeSupported(type));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaSource::s_info))
        return throwVMTypeError(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaSource::s_info);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaSource::s_info))
        return throwVMTypeError(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaSource::s_info);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaSource::s_info))
        return throwVMTypeError(exec);
    JSMediaSource* castedThis = jsCast<JSMediaSource*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaSource::s_info);
    MediaSource* impl = static_cast<MediaSource*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* event(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSMediaSource::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSMediaSource* thisObject = jsCast<JSMediaSource*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSMediaSource* jsMediaSource)
{
    if (jsMediaSource->hasCustomProperties())
        return true;
    if (jsMediaSource->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSMediaSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMediaSource* jsMediaSource = jsCast<JSMediaSource*>(handle.get().asCell());
    if (jsMediaSource->impl()->hasPendingActivity())
        return true;
    if (jsMediaSource->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsMediaSource))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMediaSource* jsMediaSource = jsCast<JSMediaSource*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaSource->impl(), jsMediaSource);
    jsMediaSource->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaSource@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11MediaSourceE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaSource* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaSource>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaSource@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11MediaSourceE[2];
#if COMPILER(CLANG)
    // If this fails MediaSource does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaSource), MediaSource_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaSource has subclasses. If MediaSource has subclasses that get passed
    // to toJS() we currently require MediaSource you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<MediaSource>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSMediaSource>(exec, globalObject, impl);
}

MediaSource* toMediaSource(JSC::JSValue value)
{
    return value.inherits(&JSMediaSource::s_info) ? jsCast<JSMediaSource*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_SOURCE)
