/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(ENCRYPTED_MEDIA_V2)

#include "JSMediaKeys.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSMediaKeySession.h"
#include "JSUint8Array.h"
#include "KURL.h"
#include "MediaKeySession.h"
#include "MediaKeys.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaKeysTableValues[] =
{
    { "keySystem", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeysKeySystem), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeysConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeysTable = { 4, 3, JSMediaKeysTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaKeysConstructorTableValues[] =
{
    { "isTypeSupported", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeysConstructorFunctionIsTypeSupported), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeysConstructorTable = { 1, 0, JSMediaKeysConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMediaKeysConstructor::constructJSMediaKeys(ExecState* exec)
{
    JSMediaKeysConstructor* castedThis = jsCast<JSMediaKeysConstructor*>(exec->callee());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& keySystem(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<MediaKeys> object = MediaKeys::create(keySystem, ec);
    if (ec) {
        setDOMException(exec, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSMediaKeysConstructor::s_info = { "WebKitMediaKeysConstructor", &Base::s_info, &JSMediaKeysConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaKeysConstructor) };

JSMediaKeysConstructor::JSMediaKeysConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaKeysConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaKeysPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaKeysConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSMediaKeysConstructor, JSDOMWrapper>(exec, &JSMediaKeysConstructorTable, jsCast<JSMediaKeysConstructor*>(cell), propertyName, slot);
}

bool JSMediaKeysConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSMediaKeysConstructor, JSDOMWrapper>(exec, &JSMediaKeysConstructorTable, jsCast<JSMediaKeysConstructor*>(object), propertyName, descriptor);
}

ConstructType JSMediaKeysConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMediaKeys;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMediaKeysPrototypeTableValues[] =
{
    { "createSession", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeysPrototypeFunctionCreateSession), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeysPrototypeTable = { 4, 3, JSMediaKeysPrototypeTableValues, 0 };
const ClassInfo JSMediaKeysPrototype::s_info = { "WebKitMediaKeysPrototype", &Base::s_info, &JSMediaKeysPrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaKeysPrototype) };

JSObject* JSMediaKeysPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaKeys>(exec, globalObject);
}

bool JSMediaKeysPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeysPrototype* thisObject = jsCast<JSMediaKeysPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaKeysPrototypeTable, thisObject, propertyName, slot);
}

bool JSMediaKeysPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeysPrototype* thisObject = jsCast<JSMediaKeysPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMediaKeysPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMediaKeys::s_info = { "WebKitMediaKeys", &Base::s_info, &JSMediaKeysTable, 0 , CREATE_METHOD_TABLE(JSMediaKeys) };

JSMediaKeys::JSMediaKeys(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaKeys> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMediaKeys::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaKeys::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaKeysPrototype::create(exec->vm(), globalObject, JSMediaKeysPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSMediaKeys::destroy(JSC::JSCell* cell)
{
    JSMediaKeys* thisObject = static_cast<JSMediaKeys*>(cell);
    thisObject->JSMediaKeys::~JSMediaKeys();
}

JSMediaKeys::~JSMediaKeys()
{
    releaseImplIfNotNull();
}

bool JSMediaKeys::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeys* thisObject = jsCast<JSMediaKeys*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaKeys, Base>(exec, &JSMediaKeysTable, thisObject, propertyName, slot);
}

bool JSMediaKeys::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeys* thisObject = jsCast<JSMediaKeys*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaKeys, Base>(exec, &JSMediaKeysTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaKeysKeySystem(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeys* castedThis = jsCast<JSMediaKeys*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeys* impl = static_cast<MediaKeys*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->keySystem());
    return result;
}


JSValue jsMediaKeysConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeys* domObject = jsCast<JSMediaKeys*>(asObject(slotBase));
    return JSMediaKeys::getConstructor(exec, domObject->globalObject());
}

JSValue JSMediaKeys::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaKeysConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaKeysPrototypeFunctionCreateSession(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaKeys::s_info))
        return throwVMTypeError(exec);
    JSMediaKeys* castedThis = jsCast<JSMediaKeys*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaKeys::s_info);
    MediaKeys* impl = static_cast<MediaKeys*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Uint8Array* initData(toUint8Array(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSession(scriptContext, type, initData, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaKeysConstructorFunctionIsTypeSupported(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& keySystem(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& type(argumentOrNull(exec, 1).isEmpty() ? String() : argumentOrNull(exec, 1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(MediaKeys::isTypeSupported(keySystem, type));
    return JSValue::encode(result);
}

static inline bool isObservable(JSMediaKeys* jsMediaKeys)
{
    if (jsMediaKeys->hasCustomProperties())
        return true;
    return false;
}

bool JSMediaKeysOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMediaKeys* jsMediaKeys = jsCast<JSMediaKeys*>(handle.get().asCell());
    if (!isObservable(jsMediaKeys))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaKeysOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMediaKeys* jsMediaKeys = jsCast<JSMediaKeys*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaKeys->impl(), jsMediaKeys);
    jsMediaKeys->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaKeys@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9MediaKeysE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaKeys* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaKeys>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaKeys@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9MediaKeysE[2];
#if COMPILER(CLANG)
    // If this fails MediaKeys does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaKeys), MediaKeys_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaKeys has subclasses. If MediaKeys has subclasses that get passed
    // to toJS() we currently require MediaKeys you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<MediaKeys>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSMediaKeys>(exec, globalObject, impl);
}

MediaKeys* toMediaKeys(JSC::JSValue value)
{
    return value.inherits(&JSMediaKeys::s_info) ? jsCast<JSMediaKeys*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(ENCRYPTED_MEDIA_V2)
