/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSMediaKeySession_h
#define JSMediaKeySession_h

#if ENABLE(ENCRYPTED_MEDIA_V2)

#include "JSDOMBinding.h"
#include "MediaKeySession.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSMediaKeySession : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSMediaKeySession* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaKeySession> impl)
    {
        JSMediaKeySession* ptr = new (NotNull, JSC::allocateCell<JSMediaKeySession>(globalObject->vm().heap)) JSMediaKeySession(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void destroy(JSC::JSCell*);
    ~JSMediaKeySession();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    MediaKeySession* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    MediaKeySession* m_impl;
protected:
    JSMediaKeySession(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<MediaKeySession>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSMediaKeySessionOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, MediaKeySession*)
{
    DEFINE_STATIC_LOCAL(JSMediaKeySessionOwner, jsMediaKeySessionOwner, ());
    return &jsMediaKeySessionOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, MediaKeySession*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, MediaKeySession*);
MediaKeySession* toMediaKeySession(JSC::JSValue);

class JSMediaKeySessionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSMediaKeySessionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaKeySessionPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaKeySessionPrototype>(vm.heap)) JSMediaKeySessionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSMediaKeySessionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSMediaKeySessionConstructor : public DOMConstructorObject {
private:
    JSMediaKeySessionConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSMediaKeySessionConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSMediaKeySessionConstructor* ptr = new (NotNull, JSC::allocateCell<JSMediaKeySessionConstructor>(*exec->heap())) JSMediaKeySessionConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionUpdate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsMediaKeySessionError(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaKeySessionKeySystem(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaKeySessionSessionId(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaKeySessionOnwebkitkeyadded(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaKeySessionOnwebkitkeyadded(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaKeySessionOnwebkitkeyerror(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaKeySessionOnwebkitkeyerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaKeySessionOnwebkitkeymessage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaKeySessionOnwebkitkeymessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaKeySessionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(ENCRYPTED_MEDIA_V2)

#endif
