/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(ENCRYPTED_MEDIA_V2)

#include "JSMediaKeySession.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSMediaKeyError.h"
#include "JSUint8Array.h"
#include "KURL.h"
#include "MediaKeyError.h"
#include "MediaKeySession.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaKeySessionTableValues[] =
{
    { "error", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionError), (intptr_t)0, NoIntrinsic },
    { "keySystem", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionKeySystem), (intptr_t)0, NoIntrinsic },
    { "sessionId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionSessionId), (intptr_t)0, NoIntrinsic },
    { "onwebkitkeyadded", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionOnwebkitkeyadded), (intptr_t)setJSMediaKeySessionOnwebkitkeyadded, NoIntrinsic },
    { "onwebkitkeyerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionOnwebkitkeyerror), (intptr_t)setJSMediaKeySessionOnwebkitkeyerror, NoIntrinsic },
    { "onwebkitkeymessage", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionOnwebkitkeymessage), (intptr_t)setJSMediaKeySessionOnwebkitkeymessage, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeySessionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeySessionTable = { 18, 15, JSMediaKeySessionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaKeySessionConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeySessionConstructorTable = { 1, 0, JSMediaKeySessionConstructorTableValues, 0 };
const ClassInfo JSMediaKeySessionConstructor::s_info = { "WebKitMediaKeySessionConstructor", &Base::s_info, &JSMediaKeySessionConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaKeySessionConstructor) };

JSMediaKeySessionConstructor::JSMediaKeySessionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaKeySessionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaKeySessionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaKeySessionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaKeySessionConstructor, JSDOMWrapper>(exec, &JSMediaKeySessionConstructorTable, jsCast<JSMediaKeySessionConstructor*>(cell), propertyName, slot);
}

bool JSMediaKeySessionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaKeySessionConstructor, JSDOMWrapper>(exec, &JSMediaKeySessionConstructorTable, jsCast<JSMediaKeySessionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMediaKeySessionPrototypeTableValues[] =
{
    { "update", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeySessionPrototypeFunctionUpdate), (intptr_t)1, NoIntrinsic },
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeySessionPrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeySessionPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeySessionPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMediaKeySessionPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeySessionPrototypeTable = { 17, 15, JSMediaKeySessionPrototypeTableValues, 0 };
const ClassInfo JSMediaKeySessionPrototype::s_info = { "WebKitMediaKeySessionPrototype", &Base::s_info, &JSMediaKeySessionPrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaKeySessionPrototype) };

JSObject* JSMediaKeySessionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaKeySession>(exec, globalObject);
}

bool JSMediaKeySessionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeySessionPrototype* thisObject = jsCast<JSMediaKeySessionPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaKeySessionPrototypeTable, thisObject, propertyName, slot);
}

bool JSMediaKeySessionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeySessionPrototype* thisObject = jsCast<JSMediaKeySessionPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMediaKeySessionPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMediaKeySession::s_info = { "WebKitMediaKeySession", &Base::s_info, &JSMediaKeySessionTable, 0 , CREATE_METHOD_TABLE(JSMediaKeySession) };

JSMediaKeySession::JSMediaKeySession(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaKeySession> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMediaKeySession::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaKeySession::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaKeySessionPrototype::create(exec->vm(), globalObject, JSMediaKeySessionPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSMediaKeySession::destroy(JSC::JSCell* cell)
{
    JSMediaKeySession* thisObject = static_cast<JSMediaKeySession*>(cell);
    thisObject->JSMediaKeySession::~JSMediaKeySession();
}

JSMediaKeySession::~JSMediaKeySession()
{
    releaseImplIfNotNull();
}

bool JSMediaKeySession::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeySession* thisObject = jsCast<JSMediaKeySession*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaKeySession, Base>(exec, &JSMediaKeySessionTable, thisObject, propertyName, slot);
}

bool JSMediaKeySession::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeySession* thisObject = jsCast<JSMediaKeySession*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaKeySession, Base>(exec, &JSMediaKeySessionTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaKeySessionError(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->error()));
    return result;
}


JSValue jsMediaKeySessionKeySystem(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->keySystem());
    return result;
}


JSValue jsMediaKeySessionSessionId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->sessionId());
    return result;
}


JSValue jsMediaKeySessionOnwebkitkeyadded(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitkeyadded()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsMediaKeySessionOnwebkitkeyerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitkeyerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsMediaKeySessionOnwebkitkeymessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitkeymessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsMediaKeySessionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeySession* domObject = jsCast<JSMediaKeySession*>(asObject(slotBase));
    return JSMediaKeySession::getConstructor(exec, domObject->globalObject());
}

void JSMediaKeySession::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSMediaKeySession* thisObject = jsCast<JSMediaKeySession*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSMediaKeySession, Base>(exec, propertyName, value, &JSMediaKeySessionTable, thisObject, slot);
}

void setJSMediaKeySessionOnwebkitkeyadded(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(thisObject);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    impl->setOnwebkitkeyadded(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSMediaKeySessionOnwebkitkeyerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(thisObject);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    impl->setOnwebkitkeyerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSMediaKeySessionOnwebkitkeymessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(thisObject);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    impl->setOnwebkitkeymessage(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSMediaKeySession::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaKeySessionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionUpdate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaKeySession::s_info))
        return throwVMTypeError(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaKeySession::s_info);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Uint8Array* key(toUint8Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->update(key, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaKeySession::s_info))
        return throwVMTypeError(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaKeySession::s_info);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaKeySession::s_info))
        return throwVMTypeError(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaKeySession::s_info);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaKeySession::s_info))
        return throwVMTypeError(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaKeySession::s_info);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaKeySessionPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMediaKeySession::s_info))
        return throwVMTypeError(exec);
    JSMediaKeySession* castedThis = jsCast<JSMediaKeySession*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMediaKeySession::s_info);
    MediaKeySession* impl = static_cast<MediaKeySession*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSMediaKeySession::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSMediaKeySession* thisObject = jsCast<JSMediaKeySession*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSMediaKeySession* jsMediaKeySession)
{
    if (jsMediaKeySession->hasCustomProperties())
        return true;
    if (jsMediaKeySession->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSMediaKeySessionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMediaKeySession* jsMediaKeySession = jsCast<JSMediaKeySession*>(handle.get().asCell());
    if (jsMediaKeySession->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsMediaKeySession))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaKeySessionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMediaKeySession* jsMediaKeySession = jsCast<JSMediaKeySession*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaKeySession->impl(), jsMediaKeySession);
    jsMediaKeySession->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaKeySession@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15MediaKeySessionE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaKeySession* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaKeySession>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaKeySession@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15MediaKeySessionE[2];
#if COMPILER(CLANG)
    // If this fails MediaKeySession does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaKeySession), MediaKeySession_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaKeySession has subclasses. If MediaKeySession has subclasses that get passed
    // to toJS() we currently require MediaKeySession you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<MediaKeySession>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSMediaKeySession>(exec, globalObject, impl);
}

MediaKeySession* toMediaKeySession(JSC::JSValue value)
{
    return value.inherits(&JSMediaKeySession::s_info) ? jsCast<JSMediaKeySession*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(ENCRYPTED_MEDIA_V2)
