/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(ENCRYPTED_MEDIA_V2)

#include "JSMediaKeyNeededEvent.h"

#include "JSDictionary.h"
#include "JSUint8Array.h"
#include "MediaKeyNeededEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>
#include <wtf/Uint8Array.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaKeyNeededEventTableValues[] =
{
    { "initData", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyNeededEventInitData), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyNeededEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyNeededEventTable = { 5, 3, JSMediaKeyNeededEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaKeyNeededEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyNeededEventConstructorTable = { 1, 0, JSMediaKeyNeededEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMediaKeyNeededEventConstructor::constructJSMediaKeyNeededEvent(ExecState* exec)
{
    JSMediaKeyNeededEventConstructor* jsConstructor = jsCast<JSMediaKeyNeededEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    MediaKeyNeededEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillMediaKeyNeededEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<MediaKeyNeededEvent> event = MediaKeyNeededEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillMediaKeyNeededEventInit(MediaKeyNeededEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    return true;
}

const ClassInfo JSMediaKeyNeededEventConstructor::s_info = { "MediaKeyNeededEventConstructor", &Base::s_info, &JSMediaKeyNeededEventConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaKeyNeededEventConstructor) };

JSMediaKeyNeededEventConstructor::JSMediaKeyNeededEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaKeyNeededEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaKeyNeededEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaKeyNeededEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaKeyNeededEventConstructor, JSDOMWrapper>(exec, &JSMediaKeyNeededEventConstructorTable, jsCast<JSMediaKeyNeededEventConstructor*>(cell), propertyName, slot);
}

bool JSMediaKeyNeededEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaKeyNeededEventConstructor, JSDOMWrapper>(exec, &JSMediaKeyNeededEventConstructorTable, jsCast<JSMediaKeyNeededEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSMediaKeyNeededEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMediaKeyNeededEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMediaKeyNeededEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyNeededEventPrototypeTable = { 1, 0, JSMediaKeyNeededEventPrototypeTableValues, 0 };
const ClassInfo JSMediaKeyNeededEventPrototype::s_info = { "MediaKeyNeededEventPrototype", &Base::s_info, &JSMediaKeyNeededEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaKeyNeededEventPrototype) };

JSObject* JSMediaKeyNeededEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaKeyNeededEvent>(exec, globalObject);
}

const ClassInfo JSMediaKeyNeededEvent::s_info = { "MediaKeyNeededEvent", &Base::s_info, &JSMediaKeyNeededEventTable, 0 , CREATE_METHOD_TABLE(JSMediaKeyNeededEvent) };

JSMediaKeyNeededEvent::JSMediaKeyNeededEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaKeyNeededEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSMediaKeyNeededEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaKeyNeededEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaKeyNeededEventPrototype::create(exec->vm(), globalObject, JSMediaKeyNeededEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSMediaKeyNeededEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeyNeededEvent* thisObject = jsCast<JSMediaKeyNeededEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaKeyNeededEvent, Base>(exec, &JSMediaKeyNeededEventTable, thisObject, propertyName, slot);
}

bool JSMediaKeyNeededEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeyNeededEvent* thisObject = jsCast<JSMediaKeyNeededEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaKeyNeededEvent, Base>(exec, &JSMediaKeyNeededEventTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaKeyNeededEventInitData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyNeededEvent* castedThis = jsCast<JSMediaKeyNeededEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyNeededEvent* impl = static_cast<MediaKeyNeededEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->initData()));
    return result;
}


JSValue jsMediaKeyNeededEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyNeededEvent* domObject = jsCast<JSMediaKeyNeededEvent*>(asObject(slotBase));
    return JSMediaKeyNeededEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMediaKeyNeededEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaKeyNeededEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(ENCRYPTED_MEDIA_V2)
