/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(ENCRYPTED_MEDIA_V2)

#include "JSMediaKeyMessageEvent.h"

#include "JSDictionary.h"
#include "JSUint8Array.h"
#include "KURL.h"
#include "MediaKeyMessageEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/Uint8Array.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaKeyMessageEventTableValues[] =
{
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyMessageEventMessage), (intptr_t)0, NoIntrinsic },
    { "destinationURL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyMessageEventDestinationURL), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyMessageEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyMessageEventTable = { 8, 7, JSMediaKeyMessageEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaKeyMessageEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyMessageEventConstructorTable = { 1, 0, JSMediaKeyMessageEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMediaKeyMessageEventConstructor::constructJSMediaKeyMessageEvent(ExecState* exec)
{
    JSMediaKeyMessageEventConstructor* jsConstructor = jsCast<JSMediaKeyMessageEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    MediaKeyMessageEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillMediaKeyMessageEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<MediaKeyMessageEvent> event = MediaKeyMessageEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillMediaKeyMessageEventInit(MediaKeyMessageEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("destinationURL", eventInit.destinationURL))
        return false;
    return true;
}

const ClassInfo JSMediaKeyMessageEventConstructor::s_info = { "WebKitMediaKeyMessageEventConstructor", &Base::s_info, &JSMediaKeyMessageEventConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaKeyMessageEventConstructor) };

JSMediaKeyMessageEventConstructor::JSMediaKeyMessageEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaKeyMessageEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaKeyMessageEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaKeyMessageEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaKeyMessageEventConstructor, JSDOMWrapper>(exec, &JSMediaKeyMessageEventConstructorTable, jsCast<JSMediaKeyMessageEventConstructor*>(cell), propertyName, slot);
}

bool JSMediaKeyMessageEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaKeyMessageEventConstructor, JSDOMWrapper>(exec, &JSMediaKeyMessageEventConstructorTable, jsCast<JSMediaKeyMessageEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSMediaKeyMessageEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMediaKeyMessageEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMediaKeyMessageEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyMessageEventPrototypeTable = { 1, 0, JSMediaKeyMessageEventPrototypeTableValues, 0 };
const ClassInfo JSMediaKeyMessageEventPrototype::s_info = { "WebKitMediaKeyMessageEventPrototype", &Base::s_info, &JSMediaKeyMessageEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaKeyMessageEventPrototype) };

JSObject* JSMediaKeyMessageEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaKeyMessageEvent>(exec, globalObject);
}

const ClassInfo JSMediaKeyMessageEvent::s_info = { "WebKitMediaKeyMessageEvent", &Base::s_info, &JSMediaKeyMessageEventTable, 0 , CREATE_METHOD_TABLE(JSMediaKeyMessageEvent) };

JSMediaKeyMessageEvent::JSMediaKeyMessageEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaKeyMessageEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSMediaKeyMessageEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaKeyMessageEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaKeyMessageEventPrototype::create(exec->vm(), globalObject, JSMediaKeyMessageEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSMediaKeyMessageEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeyMessageEvent* thisObject = jsCast<JSMediaKeyMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaKeyMessageEvent, Base>(exec, &JSMediaKeyMessageEventTable, thisObject, propertyName, slot);
}

bool JSMediaKeyMessageEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeyMessageEvent* thisObject = jsCast<JSMediaKeyMessageEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaKeyMessageEvent, Base>(exec, &JSMediaKeyMessageEventTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaKeyMessageEventMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyMessageEvent* castedThis = jsCast<JSMediaKeyMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyMessageEvent* impl = static_cast<MediaKeyMessageEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->message()));
    return result;
}


JSValue jsMediaKeyMessageEventDestinationURL(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyMessageEvent* castedThis = jsCast<JSMediaKeyMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyMessageEvent* impl = static_cast<MediaKeyMessageEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->destinationURL());
    return result;
}


JSValue jsMediaKeyMessageEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyMessageEvent* domObject = jsCast<JSMediaKeyMessageEvent*>(asObject(slotBase));
    return JSMediaKeyMessageEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMediaKeyMessageEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaKeyMessageEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(ENCRYPTED_MEDIA_V2)
