/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(ENCRYPTED_MEDIA)

#include "JSMediaKeyEvent.h"

#include "JSDictionary.h"
#include "JSMediaKeyError.h"
#include "JSUint8Array.h"
#include "KURL.h"
#include "MediaKeyError.h"
#include "MediaKeyEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/Uint8Array.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaKeyEventTableValues[] =
{
    { "keySystem", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventKeySystem), (intptr_t)0, NoIntrinsic },
    { "sessionId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventSessionId), (intptr_t)0, NoIntrinsic },
    { "initData", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventInitData), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventMessage), (intptr_t)0, NoIntrinsic },
    { "defaultURL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventDefaultURL), (intptr_t)0, NoIntrinsic },
    { "errorCode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventErrorCode), (intptr_t)0, NoIntrinsic },
    { "systemCode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventSystemCode), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaKeyEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyEventTable = { 18, 15, JSMediaKeyEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaKeyEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyEventConstructorTable = { 1, 0, JSMediaKeyEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMediaKeyEventConstructor::constructJSMediaKeyEvent(ExecState* exec)
{
    JSMediaKeyEventConstructor* jsConstructor = jsCast<JSMediaKeyEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    MediaKeyEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillMediaKeyEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<MediaKeyEvent> event = MediaKeyEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillMediaKeyEventInit(MediaKeyEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("keySystem", eventInit.keySystem))
        return false;
    if (!dictionary.tryGetProperty("sessionId", eventInit.sessionId))
        return false;
    if (!dictionary.tryGetProperty("initData", eventInit.initData))
        return false;
    if (!dictionary.tryGetProperty("message", eventInit.message))
        return false;
    if (!dictionary.tryGetProperty("defaultURL", eventInit.defaultURL))
        return false;
    if (!dictionary.tryGetProperty("errorCode", eventInit.errorCode))
        return false;
    if (!dictionary.tryGetProperty("systemCode", eventInit.systemCode))
        return false;
    return true;
}

const ClassInfo JSMediaKeyEventConstructor::s_info = { "MediaKeyEventConstructor", &Base::s_info, &JSMediaKeyEventConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaKeyEventConstructor) };

JSMediaKeyEventConstructor::JSMediaKeyEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaKeyEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaKeyEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaKeyEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaKeyEventConstructor, JSDOMWrapper>(exec, &JSMediaKeyEventConstructorTable, jsCast<JSMediaKeyEventConstructor*>(cell), propertyName, slot);
}

bool JSMediaKeyEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaKeyEventConstructor, JSDOMWrapper>(exec, &JSMediaKeyEventConstructorTable, jsCast<JSMediaKeyEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSMediaKeyEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMediaKeyEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMediaKeyEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaKeyEventPrototypeTable = { 1, 0, JSMediaKeyEventPrototypeTableValues, 0 };
const ClassInfo JSMediaKeyEventPrototype::s_info = { "MediaKeyEventPrototype", &Base::s_info, &JSMediaKeyEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaKeyEventPrototype) };

JSObject* JSMediaKeyEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaKeyEvent>(exec, globalObject);
}

const ClassInfo JSMediaKeyEvent::s_info = { "MediaKeyEvent", &Base::s_info, &JSMediaKeyEventTable, 0 , CREATE_METHOD_TABLE(JSMediaKeyEvent) };

JSMediaKeyEvent::JSMediaKeyEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaKeyEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSMediaKeyEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaKeyEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaKeyEventPrototype::create(exec->vm(), globalObject, JSMediaKeyEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSMediaKeyEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaKeyEvent* thisObject = jsCast<JSMediaKeyEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaKeyEvent, Base>(exec, &JSMediaKeyEventTable, thisObject, propertyName, slot);
}

bool JSMediaKeyEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaKeyEvent* thisObject = jsCast<JSMediaKeyEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaKeyEvent, Base>(exec, &JSMediaKeyEventTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaKeyEventKeySystem(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->keySystem());
    return result;
}


JSValue jsMediaKeyEventSessionId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->sessionId());
    return result;
}


JSValue jsMediaKeyEventInitData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->initData()));
    return result;
}


JSValue jsMediaKeyEventMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->message()));
    return result;
}


JSValue jsMediaKeyEventDefaultURL(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->defaultURL());
    return result;
}


JSValue jsMediaKeyEventErrorCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->errorCode()));
    return result;
}


JSValue jsMediaKeyEventSystemCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* castedThis = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaKeyEvent* impl = static_cast<MediaKeyEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->systemCode());
    return result;
}


JSValue jsMediaKeyEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaKeyEvent* domObject = jsCast<JSMediaKeyEvent*>(asObject(slotBase));
    return JSMediaKeyEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMediaKeyEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaKeyEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(ENCRYPTED_MEDIA)
