/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)

#include "JSMediaElementAudioSourceNode.h"

#include "HTMLMediaElement.h"
#include "JSHTMLMediaElement.h"
#include "MediaElementAudioSourceNode.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaElementAudioSourceNodeTableValues[] =
{
    { "mediaElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaElementAudioSourceNodeMediaElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaElementAudioSourceNodeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaElementAudioSourceNodeTable = { 4, 3, JSMediaElementAudioSourceNodeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaElementAudioSourceNodeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaElementAudioSourceNodeConstructorTable = { 1, 0, JSMediaElementAudioSourceNodeConstructorTableValues, 0 };
const ClassInfo JSMediaElementAudioSourceNodeConstructor::s_info = { "MediaElementAudioSourceNodeConstructor", &Base::s_info, &JSMediaElementAudioSourceNodeConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNodeConstructor) };

JSMediaElementAudioSourceNodeConstructor::JSMediaElementAudioSourceNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaElementAudioSourceNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMediaElementAudioSourceNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSMediaElementAudioSourceNodeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaElementAudioSourceNodeConstructor, JSDOMWrapper>(exec, &JSMediaElementAudioSourceNodeConstructorTable, jsCast<JSMediaElementAudioSourceNodeConstructor*>(cell), propertyName, slot);
}

bool JSMediaElementAudioSourceNodeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaElementAudioSourceNodeConstructor, JSDOMWrapper>(exec, &JSMediaElementAudioSourceNodeConstructorTable, jsCast<JSMediaElementAudioSourceNodeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMediaElementAudioSourceNodePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaElementAudioSourceNodePrototypeTable = { 1, 0, JSMediaElementAudioSourceNodePrototypeTableValues, 0 };
const ClassInfo JSMediaElementAudioSourceNodePrototype::s_info = { "MediaElementAudioSourceNodePrototype", &Base::s_info, &JSMediaElementAudioSourceNodePrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNodePrototype) };

JSObject* JSMediaElementAudioSourceNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaElementAudioSourceNode>(exec, globalObject);
}

const ClassInfo JSMediaElementAudioSourceNode::s_info = { "MediaElementAudioSourceNode", &Base::s_info, &JSMediaElementAudioSourceNodeTable, 0 , CREATE_METHOD_TABLE(JSMediaElementAudioSourceNode) };

JSMediaElementAudioSourceNode::JSMediaElementAudioSourceNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaElementAudioSourceNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSMediaElementAudioSourceNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaElementAudioSourceNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaElementAudioSourceNodePrototype::create(exec->vm(), globalObject, JSMediaElementAudioSourceNodePrototype::createStructure(exec->vm(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSMediaElementAudioSourceNode::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaElementAudioSourceNode* thisObject = jsCast<JSMediaElementAudioSourceNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaElementAudioSourceNode, Base>(exec, &JSMediaElementAudioSourceNodeTable, thisObject, propertyName, slot);
}

bool JSMediaElementAudioSourceNode::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaElementAudioSourceNode* thisObject = jsCast<JSMediaElementAudioSourceNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaElementAudioSourceNode, Base>(exec, &JSMediaElementAudioSourceNodeTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaElementAudioSourceNodeMediaElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaElementAudioSourceNode* castedThis = jsCast<JSMediaElementAudioSourceNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaElementAudioSourceNode* impl = static_cast<MediaElementAudioSourceNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->mediaElement()));
    return result;
}


JSValue jsMediaElementAudioSourceNodeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaElementAudioSourceNode* domObject = jsCast<JSMediaElementAudioSourceNode*>(asObject(slotBase));
    return JSMediaElementAudioSourceNode::getConstructor(exec, domObject->globalObject());
}

JSValue JSMediaElementAudioSourceNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaElementAudioSourceNodeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaElementAudioSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27MediaElementAudioSourceNodeE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaElementAudioSourceNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaElementAudioSourceNode>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaElementAudioSourceNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27MediaElementAudioSourceNodeE[2];
#if COMPILER(CLANG)
    // If this fails MediaElementAudioSourceNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaElementAudioSourceNode), MediaElementAudioSourceNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaElementAudioSourceNode has subclasses. If MediaElementAudioSourceNode has subclasses that get passed
    // to toJS() we currently require MediaElementAudioSourceNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<MediaElementAudioSourceNode>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSMediaElementAudioSourceNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
