/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MANX_HTMLTILE)

#include "JSLocationChangeEvent.h"

#include "JSDictionary.h"
#include "KURL.h"
#include "LocationChangeEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSLocationChangeEventTableValues[] =
{
    { "url", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationChangeEventUrl), (intptr_t)0, NoIntrinsic },
    { "locationChangeAllowed", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationChangeEventLocationChangeAllowed), (intptr_t)setJSLocationChangeEventLocationChangeAllowed, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationChangeEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSLocationChangeEventTable = { 8, 7, JSLocationChangeEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSLocationChangeEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSLocationChangeEventConstructorTable = { 1, 0, JSLocationChangeEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSLocationChangeEventConstructor::constructJSLocationChangeEvent(ExecState* exec)
{
    JSLocationChangeEventConstructor* jsConstructor = jsCast<JSLocationChangeEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    LocationChangeEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillLocationChangeEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<LocationChangeEvent> event = LocationChangeEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillLocationChangeEventInit(LocationChangeEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("url", eventInit.url))
        return false;
    if (!dictionary.tryGetProperty("locationChangeAllowed", eventInit.locationChangeAllowed))
        return false;
    return true;
}

const ClassInfo JSLocationChangeEventConstructor::s_info = { "LocationChangeEventConstructor", &Base::s_info, &JSLocationChangeEventConstructorTable, 0, CREATE_METHOD_TABLE(JSLocationChangeEventConstructor) };

JSLocationChangeEventConstructor::JSLocationChangeEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSLocationChangeEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSLocationChangeEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSLocationChangeEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSLocationChangeEventConstructor, JSDOMWrapper>(exec, &JSLocationChangeEventConstructorTable, jsCast<JSLocationChangeEventConstructor*>(cell), propertyName, slot);
}

bool JSLocationChangeEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSLocationChangeEventConstructor, JSDOMWrapper>(exec, &JSLocationChangeEventConstructorTable, jsCast<JSLocationChangeEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSLocationChangeEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSLocationChangeEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSLocationChangeEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSLocationChangeEventPrototypeTable = { 1, 0, JSLocationChangeEventPrototypeTableValues, 0 };
const ClassInfo JSLocationChangeEventPrototype::s_info = { "LocationChangeEventPrototype", &Base::s_info, &JSLocationChangeEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSLocationChangeEventPrototype) };

JSObject* JSLocationChangeEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSLocationChangeEvent>(exec, globalObject);
}

const ClassInfo JSLocationChangeEvent::s_info = { "LocationChangeEvent", &Base::s_info, &JSLocationChangeEventTable, 0 , CREATE_METHOD_TABLE(JSLocationChangeEvent) };

JSLocationChangeEvent::JSLocationChangeEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<LocationChangeEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSLocationChangeEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSLocationChangeEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSLocationChangeEventPrototype::create(exec->vm(), globalObject, JSLocationChangeEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSLocationChangeEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSLocationChangeEvent* thisObject = jsCast<JSLocationChangeEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSLocationChangeEvent, Base>(exec, &JSLocationChangeEventTable, thisObject, propertyName, slot);
}

bool JSLocationChangeEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSLocationChangeEvent* thisObject = jsCast<JSLocationChangeEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSLocationChangeEvent, Base>(exec, &JSLocationChangeEventTable, thisObject, propertyName, descriptor);
}

JSValue jsLocationChangeEventUrl(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSLocationChangeEvent* castedThis = jsCast<JSLocationChangeEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    LocationChangeEvent* impl = static_cast<LocationChangeEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->url());
    return result;
}


JSValue jsLocationChangeEventLocationChangeAllowed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSLocationChangeEvent* castedThis = jsCast<JSLocationChangeEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    LocationChangeEvent* impl = static_cast<LocationChangeEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->locationChangeAllowed());
    return result;
}


JSValue jsLocationChangeEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSLocationChangeEvent* domObject = jsCast<JSLocationChangeEvent*>(asObject(slotBase));
    return JSLocationChangeEvent::getConstructor(exec, domObject->globalObject());
}

void JSLocationChangeEvent::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSLocationChangeEvent* thisObject = jsCast<JSLocationChangeEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSLocationChangeEvent, Base>(exec, propertyName, value, &JSLocationChangeEventTable, thisObject, slot);
}

void setJSLocationChangeEventLocationChangeAllowed(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSLocationChangeEvent* castedThis = jsCast<JSLocationChangeEvent*>(thisObject);
    LocationChangeEvent* impl = static_cast<LocationChangeEvent*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setLocationChangeAllowed(nativeValue);
}


JSValue JSLocationChangeEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSLocationChangeEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(MANX_HTMLTILE)
