/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternalSettingsGenerated.h"

#include "ExceptionCode.h"
#include "InternalSettingsGenerated.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSInternalSettingsGeneratedPrototypeTableValues[] =
{
    { "setDOMPasteAllowed", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDOMPasteAllowed), (intptr_t)1, NoIntrinsic },
    { "setAccelerated2dCanvasEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAccelerated2dCanvasEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingFor3DTransformsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingFor3DTransformsEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForAnimationEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForAnimationEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForCanvasEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForCanvasEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForFixedPositionEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForFixedPositionEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForOverflowScrollEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForOverflowScrollEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForPluginsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForPluginsEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForScrollableFramesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForScrollableFramesEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedCompositingForVideoEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForVideoEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedDrawingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedDrawingEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedFiltersEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedFiltersEnabled), (intptr_t)1, NoIntrinsic },
    { "setAllowCustomScrollbarInMainFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAllowCustomScrollbarInMainFrame), (intptr_t)1, NoIntrinsic },
    { "setAllowDisplayOfInsecureContent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAllowDisplayOfInsecureContent), (intptr_t)1, NoIntrinsic },
    { "setAllowFileAccessFromFileURLs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAllowFileAccessFromFileURLs), (intptr_t)1, NoIntrinsic },
    { "setAllowRunningOfInsecureContent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAllowRunningOfInsecureContent), (intptr_t)1, NoIntrinsic },
    { "setAllowScriptsToCloseWindows", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAllowScriptsToCloseWindows), (intptr_t)1, NoIntrinsic },
    { "setAllowUniversalAccessFromFileURLs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAllowUniversalAccessFromFileURLs), (intptr_t)1, NoIntrinsic },
    { "setAntialiased2dCanvasEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAntialiased2dCanvasEnabled), (intptr_t)1, NoIntrinsic },
    { "setApplicationChromeMode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetApplicationChromeMode), (intptr_t)1, NoIntrinsic },
    { "setApplyDeviceScaleFactorInCompositor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetApplyDeviceScaleFactorInCompositor), (intptr_t)1, NoIntrinsic },
    { "setApplyPageScaleFactorInCompositor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetApplyPageScaleFactorInCompositor), (intptr_t)1, NoIntrinsic },
    { "setAsynchronousSpellCheckingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAsynchronousSpellCheckingEnabled), (intptr_t)1, NoIntrinsic },
    { "setAuthorAndUserStylesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAuthorAndUserStylesEnabled), (intptr_t)1, NoIntrinsic },
    { "setAutostartOriginPlugInSnapshottingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetAutostartOriginPlugInSnapshottingEnabled), (intptr_t)1, NoIntrinsic },
    { "setBackForwardCacheExpirationInterval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetBackForwardCacheExpirationInterval), (intptr_t)1, NoIntrinsic },
    { "setBackspaceKeyNavigationEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetBackspaceKeyNavigationEnabled), (intptr_t)1, NoIntrinsic },
    { "setCanvasUsesAcceleratedDrawing", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetCanvasUsesAcceleratedDrawing), (intptr_t)1, NoIntrinsic },
    { "setCaretBrowsingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetCaretBrowsingEnabled), (intptr_t)1, NoIntrinsic },
    { "setCompositedScrollingForFramesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetCompositedScrollingForFramesEnabled), (intptr_t)1, NoIntrinsic },
    { "setCookieEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetCookieEnabled), (intptr_t)1, NoIntrinsic },
    { "setCrossOriginCheckInGetMatchedCSSRulesDisabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetCrossOriginCheckInGetMatchedCSSRulesDisabled), (intptr_t)1, NoIntrinsic },
    { "setCSSGridLayoutEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetCSSGridLayoutEnabled), (intptr_t)1, NoIntrinsic },
    { "setDefaultFixedFontSize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDefaultFixedFontSize), (intptr_t)1, NoIntrinsic },
    { "setDefaultFontSize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDefaultFontSize), (intptr_t)1, NoIntrinsic },
    { "setDefaultTextEncodingName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDefaultTextEncodingName), (intptr_t)1, NoIntrinsic },
    { "setDefaultVideoPosterURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDefaultVideoPosterURL), (intptr_t)1, NoIntrinsic },
    { "setDeveloperExtrasEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDeveloperExtrasEnabled), (intptr_t)1, NoIntrinsic },
    { "setDeviceHeight", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDeviceHeight), (intptr_t)1, NoIntrinsic },
    { "setDeviceSupportsMouse", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDeviceSupportsMouse), (intptr_t)1, NoIntrinsic },
    { "setDeviceSupportsTouch", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDeviceSupportsTouch), (intptr_t)1, NoIntrinsic },
    { "setDeviceWidth", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDeviceWidth), (intptr_t)1, NoIntrinsic },
    { "setDiagnosticLoggingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDiagnosticLoggingEnabled), (intptr_t)1, NoIntrinsic },
    { "setDownloadableBinaryFontsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetDownloadableBinaryFontsEnabled), (intptr_t)1, NoIntrinsic },
    { "setEnforceCSSMIMETypeInNoQuirksMode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetEnforceCSSMIMETypeInNoQuirksMode), (intptr_t)1, NoIntrinsic },
    { "setExperimentalNotificationsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetExperimentalNotificationsEnabled), (intptr_t)1, NoIntrinsic },
    { "setFixedElementsLayoutRelativeToFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetFixedElementsLayoutRelativeToFrame), (intptr_t)1, NoIntrinsic },
    { "setFixedPositionCreatesStackingContext", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetFixedPositionCreatesStackingContext), (intptr_t)1, NoIntrinsic },
    { "setForceCompositingMode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetForceCompositingMode), (intptr_t)1, NoIntrinsic },
    { "setForceFTPDirectoryListings", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetForceFTPDirectoryListings), (intptr_t)1, NoIntrinsic },
    { "setFrameFlatteningEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetFrameFlatteningEnabled), (intptr_t)1, NoIntrinsic },
    { "setFTPDirectoryTemplatePath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetFTPDirectoryTemplatePath), (intptr_t)1, NoIntrinsic },
    { "setFullScreenEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetFullScreenEnabled), (intptr_t)1, NoIntrinsic },
    { "setHyperlinkAuditingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetHyperlinkAuditingEnabled), (intptr_t)1, NoIntrinsic },
    { "setIncrementalRenderingSuppressionTimeoutInSeconds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetIncrementalRenderingSuppressionTimeoutInSeconds), (intptr_t)1, NoIntrinsic },
    { "setInteractiveFormValidationEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetInteractiveFormValidationEnabled), (intptr_t)1, NoIntrinsic },
    { "setJavaScriptCanAccessClipboard", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetJavaScriptCanAccessClipboard), (intptr_t)1, NoIntrinsic },
    { "setJavaScriptCanOpenWindowsAutomatically", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetJavaScriptCanOpenWindowsAutomatically), (intptr_t)1, NoIntrinsic },
    { "setJavaScriptExperimentsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetJavaScriptExperimentsEnabled), (intptr_t)1, NoIntrinsic },
    { "setLayoutFallbackWidth", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLayoutFallbackWidth), (intptr_t)1, NoIntrinsic },
    { "setLoadDeferringEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLoadDeferringEnabled), (intptr_t)1, NoIntrinsic },
    { "setLoadsSiteIconsIgnoringImageLoadingSetting", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLoadsSiteIconsIgnoringImageLoadingSetting), (intptr_t)1, NoIntrinsic },
    { "setLocalFileContentSniffingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLocalFileContentSniffingEnabled), (intptr_t)1, NoIntrinsic },
    { "setLocalStorageDatabasePath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLocalStorageDatabasePath), (intptr_t)1, NoIntrinsic },
    { "setLocalStorageEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLocalStorageEnabled), (intptr_t)1, NoIntrinsic },
    { "setLogsPageMessagesToSystemConsoleEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetLogsPageMessagesToSystemConsoleEnabled), (intptr_t)1, NoIntrinsic },
    { "setMaximumDecodedImageSize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMaximumDecodedImageSize), (intptr_t)1, NoIntrinsic },
    { "setMaximumHTMLParserDOMTreeDepth", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMaximumHTMLParserDOMTreeDepth), (intptr_t)1, NoIntrinsic },
    { "setMaximumPlugInSnapshotAttempts", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMaximumPlugInSnapshotAttempts), (intptr_t)1, NoIntrinsic },
    { "setMediaEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMediaEnabled), (intptr_t)1, NoIntrinsic },
    { "setMediaPlaybackAllowsInline", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMediaPlaybackAllowsInline), (intptr_t)1, NoIntrinsic },
    { "setMediaPlaybackRequiresUserGesture", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMediaPlaybackRequiresUserGesture), (intptr_t)1, NoIntrinsic },
    { "setMinimumAccelerated2dCanvasSize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMinimumAccelerated2dCanvasSize), (intptr_t)1, NoIntrinsic },
    { "setMinimumFontSize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMinimumFontSize), (intptr_t)1, NoIntrinsic },
    { "setMinimumLogicalFontSize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetMinimumLogicalFontSize), (intptr_t)1, NoIntrinsic },
    { "setNeedsDidFinishLoadOrderQuirk", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetNeedsDidFinishLoadOrderQuirk), (intptr_t)1, NoIntrinsic },
    { "setNeedsIsLoadingInAPISenseQuirk", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetNeedsIsLoadingInAPISenseQuirk), (intptr_t)1, NoIntrinsic },
    { "setNeedsKeyboardEventDisambiguationQuirks", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetNeedsKeyboardEventDisambiguationQuirks), (intptr_t)1, NoIntrinsic },
    { "setNeedsSiteSpecificQuirks", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetNeedsSiteSpecificQuirks), (intptr_t)1, NoIntrinsic },
    { "setNotificationsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetNotificationsEnabled), (intptr_t)1, NoIntrinsic },
    { "setOfflineWebApplicationCacheEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetOfflineWebApplicationCacheEnabled), (intptr_t)1, NoIntrinsic },
    { "setOpenGLMultisamplingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetOpenGLMultisamplingEnabled), (intptr_t)1, NoIntrinsic },
    { "setPageCacheSupportsPlugins", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPageCacheSupportsPlugins), (intptr_t)1, NoIntrinsic },
    { "setPaginateDuringLayoutEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPaginateDuringLayoutEnabled), (intptr_t)1, NoIntrinsic },
    { "setPasswordEchoDurationInSeconds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPasswordEchoDurationInSeconds), (intptr_t)1, NoIntrinsic },
    { "setPasswordEchoEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPasswordEchoEnabled), (intptr_t)1, NoIntrinsic },
    { "setPlugInSnapshottingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPlugInSnapshottingEnabled), (intptr_t)1, NoIntrinsic },
    { "setPrimaryPlugInSnapshotDetectionEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPrimaryPlugInSnapshotDetectionEnabled), (intptr_t)1, NoIntrinsic },
    { "setPrivilegedWebGLExtensionsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetPrivilegedWebGLExtensionsEnabled), (intptr_t)1, NoIntrinsic },
    { "setRegionBasedColumnsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetRegionBasedColumnsEnabled), (intptr_t)1, NoIntrinsic },
    { "setRequestAnimationFrameEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetRequestAnimationFrameEnabled), (intptr_t)1, NoIntrinsic },
    { "setScriptMarkupEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetScriptMarkupEnabled), (intptr_t)1, NoIntrinsic },
    { "setScrollAnimatorEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetScrollAnimatorEnabled), (intptr_t)1, NoIntrinsic },
    { "setScrollingCoordinatorEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetScrollingCoordinatorEnabled), (intptr_t)1, NoIntrinsic },
    { "setSelectTrailingWhitespaceEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSelectTrailingWhitespaceEnabled), (intptr_t)1, NoIntrinsic },
    { "setSelectionIncludesAltImageText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSelectionIncludesAltImageText), (intptr_t)1, NoIntrinsic },
    { "setSessionStorageQuota", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSessionStorageQuota), (intptr_t)1, NoIntrinsic },
    { "setShouldDisplayCaptions", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShouldDisplayCaptions), (intptr_t)1, NoIntrinsic },
    { "setShouldDisplaySubtitles", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShouldDisplaySubtitles), (intptr_t)1, NoIntrinsic },
    { "setShouldDisplayTextDescriptions", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShouldDisplayTextDescriptions), (intptr_t)1, NoIntrinsic },
    { "setShouldInjectUserScriptsInInitialEmptyDocument", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShouldInjectUserScriptsInInitialEmptyDocument), (intptr_t)1, NoIntrinsic },
    { "setShouldPrintBackgrounds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShouldPrintBackgrounds), (intptr_t)1, NoIntrinsic },
    { "setShouldRespectImageOrientation", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShouldRespectImageOrientation), (intptr_t)1, NoIntrinsic },
    { "setShowDebugBorders", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShowDebugBorders), (intptr_t)1, NoIntrinsic },
    { "setShowRepaintCounter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShowRepaintCounter), (intptr_t)1, NoIntrinsic },
    { "setShowsToolTipOverTruncatedText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShowsToolTipOverTruncatedText), (intptr_t)1, NoIntrinsic },
    { "setShowsURLsInToolTips", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShowsURLsInToolTips), (intptr_t)1, NoIntrinsic },
    { "setShrinksStandaloneImagesToFit", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetShrinksStandaloneImagesToFit), (intptr_t)1, NoIntrinsic },
    { "setSmartInsertDeleteEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSmartInsertDeleteEnabled), (intptr_t)1, NoIntrinsic },
    { "setSnapshotAllPlugIns", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSnapshotAllPlugIns), (intptr_t)1, NoIntrinsic },
    { "setSpatialNavigationEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSpatialNavigationEnabled), (intptr_t)1, NoIntrinsic },
    { "setSupportsMultipleWindows", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSupportsMultipleWindows), (intptr_t)1, NoIntrinsic },
    { "setSuppressesIncrementalRendering", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSuppressesIncrementalRendering), (intptr_t)1, NoIntrinsic },
    { "setSyncXHRInDocumentsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetSyncXHRInDocumentsEnabled), (intptr_t)1, NoIntrinsic },
    { "setTextAreasAreResizable", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetTextAreasAreResizable), (intptr_t)1, NoIntrinsic },
    { "setThreadedHTMLParser", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetThreadedHTMLParser), (intptr_t)1, NoIntrinsic },
    { "setTouchAdjustmentEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetTouchAdjustmentEnabled), (intptr_t)1, NoIntrinsic },
    { "setTouchDragDropEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetTouchDragDropEnabled), (intptr_t)1, NoIntrinsic },
    { "setTreatsAnyTextCSSLinkAsStylesheet", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetTreatsAnyTextCSSLinkAsStylesheet), (intptr_t)1, NoIntrinsic },
    { "setUnifiedTextCheckerEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUnifiedTextCheckerEnabled), (intptr_t)1, NoIntrinsic },
    { "setUnsafePluginPastingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUnsafePluginPastingEnabled), (intptr_t)1, NoIntrinsic },
    { "setUseLegacyBackgroundSizeShorthandBehavior", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior), (intptr_t)1, NoIntrinsic },
    { "setUsePreHTML5ParserQuirks", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUsePreHTML5ParserQuirks), (intptr_t)1, NoIntrinsic },
    { "setUseThreadedHTMLParserForDataURLs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUseThreadedHTMLParserForDataURLs), (intptr_t)1, NoIntrinsic },
    { "setUsesDashboardBackwardCompatibilityMode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUsesDashboardBackwardCompatibilityMode), (intptr_t)1, NoIntrinsic },
    { "setUsesEncodingDetector", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetUsesEncodingDetector), (intptr_t)1, NoIntrinsic },
    { "setValidationMessageTimerMagnification", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetValidationMessageTimerMagnification), (intptr_t)1, NoIntrinsic },
    { "setVisualWordMovementEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetVisualWordMovementEnabled), (intptr_t)1, NoIntrinsic },
    { "setWantsBalancedSetDefersLoadingBehavior", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWantsBalancedSetDefersLoadingBehavior), (intptr_t)1, NoIntrinsic },
    { "setWebArchiveDebugModeEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWebArchiveDebugModeEnabled), (intptr_t)1, NoIntrinsic },
    { "setWebAudioEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWebAudioEnabled), (intptr_t)1, NoIntrinsic },
    { "setWebGLEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWebGLEnabled), (intptr_t)1, NoIntrinsic },
    { "setWebGLErrorsToConsoleEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWebGLErrorsToConsoleEnabled), (intptr_t)1, NoIntrinsic },
    { "setWebSecurityEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWebSecurityEnabled), (intptr_t)1, NoIntrinsic },
    { "setWindowFocusRestricted", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetWindowFocusRestricted), (intptr_t)1, NoIntrinsic },
    { "setXSSAuditorEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsGeneratedPrototypeFunctionSetXSSAuditorEnabled), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalSettingsGeneratedPrototypeTable = { 529, 511, JSInternalSettingsGeneratedPrototypeTableValues, 0 };
const ClassInfo JSInternalSettingsGeneratedPrototype::s_info = { "InternalSettingsGeneratedPrototype", &Base::s_info, &JSInternalSettingsGeneratedPrototypeTable, 0, CREATE_METHOD_TABLE(JSInternalSettingsGeneratedPrototype) };

JSObject* JSInternalSettingsGeneratedPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInternalSettingsGenerated>(exec, globalObject);
}

bool JSInternalSettingsGeneratedPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternalSettingsGeneratedPrototype* thisObject = jsCast<JSInternalSettingsGeneratedPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSInternalSettingsGeneratedPrototypeTable, thisObject, propertyName, slot);
}

bool JSInternalSettingsGeneratedPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternalSettingsGeneratedPrototype* thisObject = jsCast<JSInternalSettingsGeneratedPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInternalSettingsGeneratedPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInternalSettingsGenerated::s_info = { "InternalSettingsGenerated", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSInternalSettingsGenerated) };

JSInternalSettingsGenerated::JSInternalSettingsGenerated(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InternalSettingsGenerated> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSInternalSettingsGenerated::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSInternalSettingsGenerated::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInternalSettingsGeneratedPrototype::create(exec->vm(), globalObject, JSInternalSettingsGeneratedPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSInternalSettingsGenerated::destroy(JSC::JSCell* cell)
{
    JSInternalSettingsGenerated* thisObject = static_cast<JSInternalSettingsGenerated*>(cell);
    thisObject->JSInternalSettingsGenerated::~JSInternalSettingsGenerated();
}

JSInternalSettingsGenerated::~JSInternalSettingsGenerated()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDOMPasteAllowed(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool DOMPasteAllowed(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDOMPasteAllowed(DOMPasteAllowed);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAccelerated2dCanvasEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool accelerated2dCanvasEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAccelerated2dCanvasEnabled(accelerated2dCanvasEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingEnabled(acceleratedCompositingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingFor3DTransformsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingFor3DTransformsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingFor3DTransformsEnabled(acceleratedCompositingFor3DTransformsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForAnimationEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForAnimationEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForAnimationEnabled(acceleratedCompositingForAnimationEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForCanvasEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForCanvasEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForCanvasEnabled(acceleratedCompositingForCanvasEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForFixedPositionEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForFixedPositionEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForFixedPositionEnabled(acceleratedCompositingForFixedPositionEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForOverflowScrollEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForOverflowScrollEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForOverflowScrollEnabled(acceleratedCompositingForOverflowScrollEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForPluginsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForPluginsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForPluginsEnabled(acceleratedCompositingForPluginsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForScrollableFramesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForScrollableFramesEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForScrollableFramesEnabled(acceleratedCompositingForScrollableFramesEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedCompositingForVideoEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedCompositingForVideoEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedCompositingForVideoEnabled(acceleratedCompositingForVideoEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedDrawingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedDrawingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedDrawingEnabled(acceleratedDrawingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAcceleratedFiltersEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool acceleratedFiltersEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedFiltersEnabled(acceleratedFiltersEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAllowCustomScrollbarInMainFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool allowCustomScrollbarInMainFrame(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAllowCustomScrollbarInMainFrame(allowCustomScrollbarInMainFrame);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAllowDisplayOfInsecureContent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool allowDisplayOfInsecureContent(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAllowDisplayOfInsecureContent(allowDisplayOfInsecureContent);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAllowFileAccessFromFileURLs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool allowFileAccessFromFileURLs(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAllowFileAccessFromFileURLs(allowFileAccessFromFileURLs);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAllowRunningOfInsecureContent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool allowRunningOfInsecureContent(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAllowRunningOfInsecureContent(allowRunningOfInsecureContent);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAllowScriptsToCloseWindows(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool allowScriptsToCloseWindows(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAllowScriptsToCloseWindows(allowScriptsToCloseWindows);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAllowUniversalAccessFromFileURLs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool allowUniversalAccessFromFileURLs(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAllowUniversalAccessFromFileURLs(allowUniversalAccessFromFileURLs);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAntialiased2dCanvasEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool antialiased2dCanvasEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAntialiased2dCanvasEnabled(antialiased2dCanvasEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetApplicationChromeMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool applicationChromeMode(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setApplicationChromeMode(applicationChromeMode);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetApplyDeviceScaleFactorInCompositor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool applyDeviceScaleFactorInCompositor(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setApplyDeviceScaleFactorInCompositor(applyDeviceScaleFactorInCompositor);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetApplyPageScaleFactorInCompositor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool applyPageScaleFactorInCompositor(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setApplyPageScaleFactorInCompositor(applyPageScaleFactorInCompositor);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAsynchronousSpellCheckingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool asynchronousSpellCheckingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAsynchronousSpellCheckingEnabled(asynchronousSpellCheckingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAuthorAndUserStylesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool authorAndUserStylesEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAuthorAndUserStylesEnabled(authorAndUserStylesEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetAutostartOriginPlugInSnapshottingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool autostartOriginPlugInSnapshottingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutostartOriginPlugInSnapshottingEnabled(autostartOriginPlugInSnapshottingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetBackForwardCacheExpirationInterval(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double backForwardCacheExpirationInterval(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setBackForwardCacheExpirationInterval(backForwardCacheExpirationInterval);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetBackspaceKeyNavigationEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool backspaceKeyNavigationEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setBackspaceKeyNavigationEnabled(backspaceKeyNavigationEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetCanvasUsesAcceleratedDrawing(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool canvasUsesAcceleratedDrawing(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCanvasUsesAcceleratedDrawing(canvasUsesAcceleratedDrawing);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetCaretBrowsingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool caretBrowsingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCaretBrowsingEnabled(caretBrowsingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetCompositedScrollingForFramesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool compositedScrollingForFramesEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCompositedScrollingForFramesEnabled(compositedScrollingForFramesEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetCookieEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool cookieEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCookieEnabled(cookieEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetCrossOriginCheckInGetMatchedCSSRulesDisabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool crossOriginCheckInGetMatchedCSSRulesDisabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCrossOriginCheckInGetMatchedCSSRulesDisabled(crossOriginCheckInGetMatchedCSSRulesDisabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetCSSGridLayoutEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool cssGridLayoutEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCSSGridLayoutEnabled(cssGridLayoutEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDefaultFixedFontSize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int defaultFixedFontSize(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDefaultFixedFontSize(defaultFixedFontSize);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDefaultFontSize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int defaultFontSize(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDefaultFontSize(defaultFontSize);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDefaultTextEncodingName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& defaultTextEncodingName(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDefaultTextEncodingName(defaultTextEncodingName);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDefaultVideoPosterURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& defaultVideoPosterURL(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDefaultVideoPosterURL(defaultVideoPosterURL);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDeveloperExtrasEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool developerExtrasEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeveloperExtrasEnabled(developerExtrasEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDeviceHeight(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int deviceHeight(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeviceHeight(deviceHeight);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDeviceSupportsMouse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool deviceSupportsMouse(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeviceSupportsMouse(deviceSupportsMouse);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDeviceSupportsTouch(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool deviceSupportsTouch(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeviceSupportsTouch(deviceSupportsTouch);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDeviceWidth(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int deviceWidth(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeviceWidth(deviceWidth);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDiagnosticLoggingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool diagnosticLoggingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDiagnosticLoggingEnabled(diagnosticLoggingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetDownloadableBinaryFontsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool downloadableBinaryFontsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDownloadableBinaryFontsEnabled(downloadableBinaryFontsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetEnforceCSSMIMETypeInNoQuirksMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool enforceCSSMIMETypeInNoQuirksMode(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEnforceCSSMIMETypeInNoQuirksMode(enforceCSSMIMETypeInNoQuirksMode);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetExperimentalNotificationsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool experimentalNotificationsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setExperimentalNotificationsEnabled(experimentalNotificationsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetFixedElementsLayoutRelativeToFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool fixedElementsLayoutRelativeToFrame(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFixedElementsLayoutRelativeToFrame(fixedElementsLayoutRelativeToFrame);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetFixedPositionCreatesStackingContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool fixedPositionCreatesStackingContext(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFixedPositionCreatesStackingContext(fixedPositionCreatesStackingContext);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetForceCompositingMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool forceCompositingMode(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setForceCompositingMode(forceCompositingMode);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetForceFTPDirectoryListings(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool forceFTPDirectoryListings(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setForceFTPDirectoryListings(forceFTPDirectoryListings);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetFrameFlatteningEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool frameFlatteningEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFrameFlatteningEnabled(frameFlatteningEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetFTPDirectoryTemplatePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& ftpDirectoryTemplatePath(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFTPDirectoryTemplatePath(ftpDirectoryTemplatePath);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetFullScreenEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool fullScreenEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFullScreenEnabled(fullScreenEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetHyperlinkAuditingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool hyperlinkAuditingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setHyperlinkAuditingEnabled(hyperlinkAuditingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetIncrementalRenderingSuppressionTimeoutInSeconds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double incrementalRenderingSuppressionTimeoutInSeconds(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setIncrementalRenderingSuppressionTimeoutInSeconds(incrementalRenderingSuppressionTimeoutInSeconds);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetInteractiveFormValidationEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool interactiveFormValidationEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setInteractiveFormValidationEnabled(interactiveFormValidationEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetJavaScriptCanAccessClipboard(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool javaScriptCanAccessClipboard(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setJavaScriptCanAccessClipboard(javaScriptCanAccessClipboard);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetJavaScriptCanOpenWindowsAutomatically(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool javaScriptCanOpenWindowsAutomatically(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setJavaScriptCanOpenWindowsAutomatically(javaScriptCanOpenWindowsAutomatically);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetJavaScriptExperimentsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool javaScriptExperimentsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setJavaScriptExperimentsEnabled(javaScriptExperimentsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLayoutFallbackWidth(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int layoutFallbackWidth(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLayoutFallbackWidth(layoutFallbackWidth);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLoadDeferringEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool loadDeferringEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLoadDeferringEnabled(loadDeferringEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLoadsSiteIconsIgnoringImageLoadingSetting(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool loadsSiteIconsIgnoringImageLoadingSetting(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLoadsSiteIconsIgnoringImageLoadingSetting(loadsSiteIconsIgnoringImageLoadingSetting);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLocalFileContentSniffingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool localFileContentSniffingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLocalFileContentSniffingEnabled(localFileContentSniffingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLocalStorageDatabasePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& localStorageDatabasePath(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLocalStorageDatabasePath(localStorageDatabasePath);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLocalStorageEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool localStorageEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLocalStorageEnabled(localStorageEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetLogsPageMessagesToSystemConsoleEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool logsPageMessagesToSystemConsoleEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLogsPageMessagesToSystemConsoleEnabled(logsPageMessagesToSystemConsoleEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMaximumDecodedImageSize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned maximumDecodedImageSize(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMaximumDecodedImageSize(maximumDecodedImageSize);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMaximumHTMLParserDOMTreeDepth(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned maximumHTMLParserDOMTreeDepth(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMaximumHTMLParserDOMTreeDepth(maximumHTMLParserDOMTreeDepth);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMaximumPlugInSnapshotAttempts(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned maximumPlugInSnapshotAttempts(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMaximumPlugInSnapshotAttempts(maximumPlugInSnapshotAttempts);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMediaEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool mediaEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMediaEnabled(mediaEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMediaPlaybackAllowsInline(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool mediaPlaybackAllowsInline(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMediaPlaybackAllowsInline(mediaPlaybackAllowsInline);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMediaPlaybackRequiresUserGesture(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool mediaPlaybackRequiresUserGesture(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMediaPlaybackRequiresUserGesture(mediaPlaybackRequiresUserGesture);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMinimumAccelerated2dCanvasSize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int minimumAccelerated2dCanvasSize(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMinimumAccelerated2dCanvasSize(minimumAccelerated2dCanvasSize);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMinimumFontSize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int minimumFontSize(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMinimumFontSize(minimumFontSize);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetMinimumLogicalFontSize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int minimumLogicalFontSize(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMinimumLogicalFontSize(minimumLogicalFontSize);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetNeedsDidFinishLoadOrderQuirk(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool needsDidFinishLoadOrderQuirk(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setNeedsDidFinishLoadOrderQuirk(needsDidFinishLoadOrderQuirk);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetNeedsIsLoadingInAPISenseQuirk(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool needsIsLoadingInAPISenseQuirk(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setNeedsIsLoadingInAPISenseQuirk(needsIsLoadingInAPISenseQuirk);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetNeedsKeyboardEventDisambiguationQuirks(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool needsKeyboardEventDisambiguationQuirks(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setNeedsKeyboardEventDisambiguationQuirks(needsKeyboardEventDisambiguationQuirks);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetNeedsSiteSpecificQuirks(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool needsSiteSpecificQuirks(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setNeedsSiteSpecificQuirks(needsSiteSpecificQuirks);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetNotificationsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool notificationsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setNotificationsEnabled(notificationsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetOfflineWebApplicationCacheEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool offlineWebApplicationCacheEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setOfflineWebApplicationCacheEnabled(offlineWebApplicationCacheEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetOpenGLMultisamplingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool openGLMultisamplingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setOpenGLMultisamplingEnabled(openGLMultisamplingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPageCacheSupportsPlugins(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool pageCacheSupportsPlugins(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPageCacheSupportsPlugins(pageCacheSupportsPlugins);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPaginateDuringLayoutEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool paginateDuringLayoutEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPaginateDuringLayoutEnabled(paginateDuringLayoutEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPasswordEchoDurationInSeconds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double passwordEchoDurationInSeconds(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPasswordEchoDurationInSeconds(passwordEchoDurationInSeconds);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPasswordEchoEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool passwordEchoEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPasswordEchoEnabled(passwordEchoEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPlugInSnapshottingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool plugInSnapshottingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPlugInSnapshottingEnabled(plugInSnapshottingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPrimaryPlugInSnapshotDetectionEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool primaryPlugInSnapshotDetectionEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPrimaryPlugInSnapshotDetectionEnabled(primaryPlugInSnapshotDetectionEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetPrivilegedWebGLExtensionsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool privilegedWebGLExtensionsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPrivilegedWebGLExtensionsEnabled(privilegedWebGLExtensionsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetRegionBasedColumnsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool regionBasedColumnsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRegionBasedColumnsEnabled(regionBasedColumnsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetRequestAnimationFrameEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool requestAnimationFrameEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRequestAnimationFrameEnabled(requestAnimationFrameEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetScriptMarkupEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool scriptMarkupEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setScriptMarkupEnabled(scriptMarkupEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetScrollAnimatorEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool scrollAnimatorEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setScrollAnimatorEnabled(scrollAnimatorEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetScrollingCoordinatorEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool scrollingCoordinatorEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setScrollingCoordinatorEnabled(scrollingCoordinatorEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSelectTrailingWhitespaceEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool selectTrailingWhitespaceEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSelectTrailingWhitespaceEnabled(selectTrailingWhitespaceEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSelectionIncludesAltImageText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool selectionIncludesAltImageText(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSelectionIncludesAltImageText(selectionIncludesAltImageText);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSessionStorageQuota(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned sessionStorageQuota(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSessionStorageQuota(sessionStorageQuota);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShouldDisplayCaptions(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shouldDisplayCaptions(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldDisplayCaptions(shouldDisplayCaptions);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShouldDisplaySubtitles(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shouldDisplaySubtitles(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldDisplaySubtitles(shouldDisplaySubtitles);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShouldDisplayTextDescriptions(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shouldDisplayTextDescriptions(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldDisplayTextDescriptions(shouldDisplayTextDescriptions);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShouldInjectUserScriptsInInitialEmptyDocument(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shouldInjectUserScriptsInInitialEmptyDocument(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldInjectUserScriptsInInitialEmptyDocument(shouldInjectUserScriptsInInitialEmptyDocument);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShouldPrintBackgrounds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shouldPrintBackgrounds(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldPrintBackgrounds(shouldPrintBackgrounds);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShouldRespectImageOrientation(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shouldRespectImageOrientation(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldRespectImageOrientation(shouldRespectImageOrientation);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShowDebugBorders(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool showDebugBorders(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShowDebugBorders(showDebugBorders);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShowRepaintCounter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool showRepaintCounter(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShowRepaintCounter(showRepaintCounter);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShowsToolTipOverTruncatedText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool showsToolTipOverTruncatedText(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShowsToolTipOverTruncatedText(showsToolTipOverTruncatedText);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShowsURLsInToolTips(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool showsURLsInToolTips(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShowsURLsInToolTips(showsURLsInToolTips);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetShrinksStandaloneImagesToFit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool shrinksStandaloneImagesToFit(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShrinksStandaloneImagesToFit(shrinksStandaloneImagesToFit);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSmartInsertDeleteEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool smartInsertDeleteEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSmartInsertDeleteEnabled(smartInsertDeleteEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSnapshotAllPlugIns(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool snapshotAllPlugIns(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSnapshotAllPlugIns(snapshotAllPlugIns);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSpatialNavigationEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool spatialNavigationEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSpatialNavigationEnabled(spatialNavigationEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSupportsMultipleWindows(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool supportsMultipleWindows(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSupportsMultipleWindows(supportsMultipleWindows);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSuppressesIncrementalRendering(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool suppressesIncrementalRendering(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSuppressesIncrementalRendering(suppressesIncrementalRendering);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetSyncXHRInDocumentsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool syncXHRInDocumentsEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSyncXHRInDocumentsEnabled(syncXHRInDocumentsEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetTextAreasAreResizable(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool textAreasAreResizable(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAreasAreResizable(textAreasAreResizable);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetThreadedHTMLParser(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool threadedHTMLParser(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setThreadedHTMLParser(threadedHTMLParser);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetTouchAdjustmentEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool touchAdjustmentEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTouchAdjustmentEnabled(touchAdjustmentEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetTouchDragDropEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool touchDragDropEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTouchDragDropEnabled(touchDragDropEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetTreatsAnyTextCSSLinkAsStylesheet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool treatsAnyTextCSSLinkAsStylesheet(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTreatsAnyTextCSSLinkAsStylesheet(treatsAnyTextCSSLinkAsStylesheet);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUnifiedTextCheckerEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool unifiedTextCheckerEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUnifiedTextCheckerEnabled(unifiedTextCheckerEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUnsafePluginPastingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool unsafePluginPastingEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUnsafePluginPastingEnabled(unsafePluginPastingEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool useLegacyBackgroundSizeShorthandBehavior(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUseLegacyBackgroundSizeShorthandBehavior(useLegacyBackgroundSizeShorthandBehavior);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUsePreHTML5ParserQuirks(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool usePreHTML5ParserQuirks(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUsePreHTML5ParserQuirks(usePreHTML5ParserQuirks);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUseThreadedHTMLParserForDataURLs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool useThreadedHTMLParserForDataURLs(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUseThreadedHTMLParserForDataURLs(useThreadedHTMLParserForDataURLs);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUsesDashboardBackwardCompatibilityMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool usesDashboardBackwardCompatibilityMode(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUsesDashboardBackwardCompatibilityMode(usesDashboardBackwardCompatibilityMode);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetUsesEncodingDetector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool usesEncodingDetector(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUsesEncodingDetector(usesEncodingDetector);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetValidationMessageTimerMagnification(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int validationMessageTimerMagnification(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setValidationMessageTimerMagnification(validationMessageTimerMagnification);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetVisualWordMovementEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool visualWordMovementEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setVisualWordMovementEnabled(visualWordMovementEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWantsBalancedSetDefersLoadingBehavior(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool wantsBalancedSetDefersLoadingBehavior(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWantsBalancedSetDefersLoadingBehavior(wantsBalancedSetDefersLoadingBehavior);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWebArchiveDebugModeEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool webArchiveDebugModeEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWebArchiveDebugModeEnabled(webArchiveDebugModeEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWebAudioEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool webAudioEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWebAudioEnabled(webAudioEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWebGLEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool webGLEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWebGLEnabled(webGLEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWebGLErrorsToConsoleEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool webGLErrorsToConsoleEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWebGLErrorsToConsoleEnabled(webGLErrorsToConsoleEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWebSecurityEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool webSecurityEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWebSecurityEnabled(webSecurityEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetWindowFocusRestricted(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool windowFocusRestricted(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWindowFocusRestricted(windowFocusRestricted);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsGeneratedPrototypeFunctionSetXSSAuditorEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettingsGenerated::s_info))
        return throwVMTypeError(exec);
    JSInternalSettingsGenerated* castedThis = jsCast<JSInternalSettingsGenerated*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettingsGenerated::s_info);
    InternalSettingsGenerated* impl = static_cast<InternalSettingsGenerated*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool xssAuditorEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setXSSAuditorEnabled(xssAuditorEnabled);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSInternalSettingsGenerated* jsInternalSettingsGenerated)
{
    if (jsInternalSettingsGenerated->hasCustomProperties())
        return true;
    return false;
}

bool JSInternalSettingsGeneratedOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSInternalSettingsGenerated* jsInternalSettingsGenerated = jsCast<JSInternalSettingsGenerated*>(handle.get().asCell());
    if (!isObservable(jsInternalSettingsGenerated))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSInternalSettingsGeneratedOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSInternalSettingsGenerated* jsInternalSettingsGenerated = jsCast<JSInternalSettingsGenerated*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInternalSettingsGenerated->impl(), jsInternalSettingsGenerated);
    jsInternalSettingsGenerated->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InternalSettingsGenerated@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25InternalSettingsGeneratedE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InternalSettingsGenerated* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSInternalSettingsGenerated>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7InternalSettingsGenerated@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25InternalSettingsGeneratedE[2];
#if COMPILER(CLANG)
    // If this fails InternalSettingsGenerated does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(InternalSettingsGenerated), InternalSettingsGenerated_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // InternalSettingsGenerated has subclasses. If InternalSettingsGenerated has subclasses that get passed
    // to toJS() we currently require InternalSettingsGenerated you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<InternalSettingsGenerated>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSInternalSettingsGenerated>(exec, globalObject, impl);
}

InternalSettingsGenerated* toInternalSettingsGenerated(JSC::JSValue value)
{
    return value.inherits(&JSInternalSettingsGenerated::s_info) ? jsCast<JSInternalSettingsGenerated*>(asObject(value))->impl() : 0;
}

}
