/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternalSettings.h"

#include "ExceptionCode.h"
#include "InternalSettings.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSInternalSettingsPrototypeTableValues[] =
{
    { "setMockScrollbarsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMockScrollbarsEnabled), (intptr_t)1, NoIntrinsic },
    { "setTouchEventEmulationEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled), (intptr_t)1, NoIntrinsic },
    { "setShadowDOMEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetShadowDOMEnabled), (intptr_t)1, NoIntrinsic },
    { "setAuthorShadowDOMForAnyElementEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetAuthorShadowDOMForAnyElementEnabled), (intptr_t)1, NoIntrinsic },
    { "setStyleScopedEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetStyleScopedEnabled), (intptr_t)1, NoIntrinsic },
    { "setStandardFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetStandardFontFamily), (intptr_t)2, NoIntrinsic },
    { "setSerifFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetSerifFontFamily), (intptr_t)2, NoIntrinsic },
    { "setSansSerifFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily), (intptr_t)2, NoIntrinsic },
    { "setFixedFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetFixedFontFamily), (intptr_t)2, NoIntrinsic },
    { "setCursiveFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCursiveFontFamily), (intptr_t)2, NoIntrinsic },
    { "setFantasyFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetFantasyFontFamily), (intptr_t)2, NoIntrinsic },
    { "setPictographFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetPictographFontFamily), (intptr_t)2, NoIntrinsic },
    { "setTextAutosizingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled), (intptr_t)1, NoIntrinsic },
    { "setTextAutosizingWindowSizeOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride), (intptr_t)2, NoIntrinsic },
    { "setTextAutosizingFontScaleFactor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingFontScaleFactor), (intptr_t)1, NoIntrinsic },
    { "setMediaTypeOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMediaTypeOverride), (intptr_t)1, NoIntrinsic },
    { "setCSSExclusionsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCSSExclusionsEnabled), (intptr_t)1, NoIntrinsic },
    { "setCSSShapesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCSSShapesEnabled), (intptr_t)1, NoIntrinsic },
    { "setCSSVariablesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCSSVariablesEnabled), (intptr_t)1, NoIntrinsic },
    { "cssVariablesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionCssVariablesEnabled), (intptr_t)0, NoIntrinsic },
    { "setCanStartMedia", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCanStartMedia), (intptr_t)1, NoIntrinsic },
    { "setEditingBehavior", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetEditingBehavior), (intptr_t)1, NoIntrinsic },
    { "setDialogElementEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetDialogElementEnabled), (intptr_t)1, NoIntrinsic },
    { "setLangAttributeAwareFormControlUIEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetLangAttributeAwareFormControlUIEnabled), (intptr_t)1, NoIntrinsic },
#if ENABLE(VIDEO_TRACK)
    { "setShouldDisplayTrackKind", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(VIDEO_TRACK)
    { "shouldDisplayTrackKind", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind), (intptr_t)1, NoIntrinsic },
#endif
    { "setStorageBlockingPolicy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy), (intptr_t)1, NoIntrinsic },
    { "setImagesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetImagesEnabled), (intptr_t)1, NoIntrinsic },
    { "setMinimumTimerInterval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMinimumTimerInterval), (intptr_t)1, NoIntrinsic },
    { "setDefaultVideoPosterURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURL), (intptr_t)1, NoIntrinsic },
    { "setTimeWithoutMouseMovementBeforeHidingControls", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControls), (intptr_t)1, NoIntrinsic },
    { "setUseLegacyBackgroundSizeShorthandBehavior", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalSettingsPrototypeTable = { 71, 63, JSInternalSettingsPrototypeTableValues, 0 };
const ClassInfo JSInternalSettingsPrototype::s_info = { "InternalSettingsPrototype", &Base::s_info, &JSInternalSettingsPrototypeTable, 0, CREATE_METHOD_TABLE(JSInternalSettingsPrototype) };

JSObject* JSInternalSettingsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInternalSettings>(exec, globalObject);
}

bool JSInternalSettingsPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternalSettingsPrototype* thisObject = jsCast<JSInternalSettingsPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSInternalSettingsPrototypeTable, thisObject, propertyName, slot);
}

bool JSInternalSettingsPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternalSettingsPrototype* thisObject = jsCast<JSInternalSettingsPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInternalSettingsPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInternalSettings::s_info = { "InternalSettings", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSInternalSettings) };

JSInternalSettings::JSInternalSettings(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InternalSettings> impl)
    : JSInternalSettingsGenerated(structure, globalObject, impl)
{
}

void JSInternalSettings::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSInternalSettings::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInternalSettingsPrototype::create(exec->vm(), globalObject, JSInternalSettingsPrototype::createStructure(exec->vm(), globalObject, JSInternalSettingsGeneratedPrototype::self(exec, globalObject)));
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMockScrollbarsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMockScrollbarsEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTouchEventEmulationEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShadowDOMEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadowDOMEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAuthorShadowDOMForAnyElementEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool isEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAuthorShadowDOMForAnyElementEnabled(isEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStyleScopedEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool isEnabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStyleScopedEnabled(isEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStandardFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStandardFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSerifFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSerifFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSansSerifFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFixedFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFixedFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCursiveFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCursiveFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFantasyFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFantasyFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPictographFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPictographFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAutosizingEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int width(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAutosizingWindowSizeOverride(width, height, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingFontScaleFactor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    float fontScaleFactor(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAutosizingFontScaleFactor(fontScaleFactor, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaTypeOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& mediaTypeOverride(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMediaTypeOverride(mediaTypeOverride, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCSSExclusionsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCSSExclusionsEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCSSShapesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCSSShapesEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCSSVariablesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCSSVariablesEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionCssVariablesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsBoolean(impl->cssVariablesEnabled(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCanStartMedia(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCanStartMedia(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEditingBehavior(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& behavior(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEditingBehavior(behavior, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDialogElementEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDialogElementEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetLangAttributeAwareFormControlUIEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLangAttributeAwareFormControlUIEnabled(enabled);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& kind(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool enabled(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldDisplayTrackKind(kind, enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& trackKind(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->shouldDisplayTrackKind(trackKind, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& policy(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStorageBlockingPolicy(policy, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetImagesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setImagesEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMinimumTimerInterval(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    double intervalInSeconds(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMinimumTimerInterval(intervalInSeconds, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& poster(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDefaultVideoPosterURL(poster, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControls(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    double time(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTimeWithoutMouseMovementBeforeHidingControls(time, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUseLegacyBackgroundSizeShorthandBehavior(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InternalSettings@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16InternalSettingsE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InternalSettings* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSInternalSettings>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7InternalSettings@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16InternalSettingsE[2];
#if COMPILER(CLANG)
    // If this fails InternalSettings does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(InternalSettings), InternalSettings_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // InternalSettings has subclasses. If InternalSettings has subclasses that get passed
    // to toJS() we currently require InternalSettings you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<InternalSettings>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSInternalSettings>(exec, globalObject, impl);
}


}
