/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INSPECTOR)

#include "JSInjectedScriptHost.h"

#include "ExceptionCode.h"
#include "InjectedScriptHost.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSInjectedScriptHostTableValues[] =
{
    { "evaluate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInjectedScriptHostEvaluate), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInjectedScriptHostTable = { 2, 1, JSInjectedScriptHostTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSInjectedScriptHostPrototypeTableValues[] =
{
    { "clearConsoleMessages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionClearConsoleMessages), (intptr_t)0, NoIntrinsic },
    { "copyText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionCopyText), (intptr_t)1, NoIntrinsic },
    { "inspect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionInspect), (intptr_t)2, NoIntrinsic },
    { "inspectedObject", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionInspectedObject), (intptr_t)1, NoIntrinsic },
    { "internalConstructorName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionInternalConstructorName), (intptr_t)1, NoIntrinsic },
    { "isHTMLAllCollection", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionIsHTMLAllCollection), (intptr_t)1, NoIntrinsic },
    { "type", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionType), (intptr_t)1, NoIntrinsic },
    { "functionDetails", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionFunctionDetails), (intptr_t)1, NoIntrinsic },
    { "getInternalProperties", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionGetInternalProperties), (intptr_t)1, NoIntrinsic },
    { "getEventListeners", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionGetEventListeners), (intptr_t)1, NoIntrinsic },
    { "databaseId", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionDatabaseId), (intptr_t)1, NoIntrinsic },
    { "storageId", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionStorageId), (intptr_t)1, NoIntrinsic },
    { "setFunctionVariableValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionSetFunctionVariableValue), (intptr_t)4, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInjectedScriptHostPrototypeTable = { 34, 31, JSInjectedScriptHostPrototypeTableValues, 0 };
const ClassInfo JSInjectedScriptHostPrototype::s_info = { "InjectedScriptHostPrototype", &Base::s_info, &JSInjectedScriptHostPrototypeTable, 0, CREATE_METHOD_TABLE(JSInjectedScriptHostPrototype) };

JSObject* JSInjectedScriptHostPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInjectedScriptHost>(exec, globalObject);
}

bool JSInjectedScriptHostPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInjectedScriptHostPrototype* thisObject = jsCast<JSInjectedScriptHostPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSInjectedScriptHostPrototypeTable, thisObject, propertyName, slot);
}

bool JSInjectedScriptHostPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInjectedScriptHostPrototype* thisObject = jsCast<JSInjectedScriptHostPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInjectedScriptHostPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInjectedScriptHost::s_info = { "InjectedScriptHost", &Base::s_info, &JSInjectedScriptHostTable, 0 , CREATE_METHOD_TABLE(JSInjectedScriptHost) };

JSInjectedScriptHost::JSInjectedScriptHost(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InjectedScriptHost> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSInjectedScriptHost::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSInjectedScriptHost::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInjectedScriptHostPrototype::create(exec->vm(), globalObject, JSInjectedScriptHostPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSInjectedScriptHost::destroy(JSC::JSCell* cell)
{
    JSInjectedScriptHost* thisObject = static_cast<JSInjectedScriptHost*>(cell);
    thisObject->JSInjectedScriptHost::~JSInjectedScriptHost();
}

JSInjectedScriptHost::~JSInjectedScriptHost()
{
    releaseImplIfNotNull();
}

bool JSInjectedScriptHost::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInjectedScriptHost* thisObject = jsCast<JSInjectedScriptHost*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSInjectedScriptHost, Base>(exec, &JSInjectedScriptHostTable, thisObject, propertyName, slot);
}

bool JSInjectedScriptHost::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInjectedScriptHost* thisObject = jsCast<JSInjectedScriptHost*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSInjectedScriptHost, Base>(exec, &JSInjectedScriptHostTable, thisObject, propertyName, descriptor);
}

JSValue jsInjectedScriptHostEvaluate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(slotBase));
    return castedThis->evaluate(exec);
}


EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionClearConsoleMessages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    InjectedScriptHost* impl = static_cast<InjectedScriptHost*>(castedThis->impl());
    impl->clearConsoleMessages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionCopyText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    InjectedScriptHost* impl = static_cast<InjectedScriptHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& text(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->copyText(text);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->inspect(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspectedObject(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->inspectedObject(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInternalConstructorName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->internalConstructorName(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionIsHTMLAllCollection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->isHTMLAllCollection(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->type(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionFunctionDetails(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->functionDetails(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionGetInternalProperties(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->getInternalProperties(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionGetEventListeners(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->getEventListeners(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDatabaseId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->databaseId(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionStorageId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->storageId(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionSetFunctionVariableValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = jsCast<JSInjectedScriptHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInjectedScriptHost::s_info);
    return JSValue::encode(castedThis->setFunctionVariableValue(exec));
}

static inline bool isObservable(JSInjectedScriptHost* jsInjectedScriptHost)
{
    if (jsInjectedScriptHost->hasCustomProperties())
        return true;
    return false;
}

bool JSInjectedScriptHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSInjectedScriptHost* jsInjectedScriptHost = jsCast<JSInjectedScriptHost*>(handle.get().asCell());
    if (!isObservable(jsInjectedScriptHost))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSInjectedScriptHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSInjectedScriptHost* jsInjectedScriptHost = jsCast<JSInjectedScriptHost*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInjectedScriptHost->impl(), jsInjectedScriptHost);
    jsInjectedScriptHost->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InjectedScriptHost* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSInjectedScriptHost>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to InjectedScriptHost.
    COMPILE_ASSERT(!__is_polymorphic(InjectedScriptHost), InjectedScriptHost_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<InjectedScriptHost>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSInjectedScriptHost>(exec, globalObject, impl);
}

InjectedScriptHost* toInjectedScriptHost(JSC::JSValue value)
{
    return value.inherits(&JSInjectedScriptHost::s_info) ? jsCast<JSInjectedScriptHost*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INSPECTOR)
