/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBIndex.h"

#include "ExceptionCode.h"
#include "IDBAny.h"
#include "IDBIndex.h"
#include "IDBObjectStore.h"
#include "IDBRequest.h"
#include "JSDOMBinding.h"
#include "JSIDBAny.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBRequest.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBIndexTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexName), (intptr_t)0, NoIntrinsic },
    { "objectStore", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexObjectStore), (intptr_t)0, NoIntrinsic },
    { "keyPath", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexKeyPath), (intptr_t)0, NoIntrinsic },
    { "unique", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexUnique), (intptr_t)0, NoIntrinsic },
    { "multiEntry", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexMultiEntry), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBIndexTable = { 17, 15, JSIDBIndexTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBIndexConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBIndexConstructorTable = { 1, 0, JSIDBIndexConstructorTableValues, 0 };
static const HashTable* getJSIDBIndexConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBIndexConstructorTable);
}

const ClassInfo JSIDBIndexConstructor::s_info = { "IDBIndexConstructor", &Base::s_info, 0, getJSIDBIndexConstructorTable, CREATE_METHOD_TABLE(JSIDBIndexConstructor) };

JSIDBIndexConstructor::JSIDBIndexConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBIndexConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBIndexPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBIndexConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBIndexConstructor, JSDOMWrapper>(exec, getJSIDBIndexConstructorTable(exec), jsCast<JSIDBIndexConstructor*>(cell), propertyName, slot);
}

bool JSIDBIndexConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBIndexConstructor, JSDOMWrapper>(exec, getJSIDBIndexConstructorTable(exec), jsCast<JSIDBIndexConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBIndexPrototypeTableValues[] =
{
    { "openCursor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBIndexPrototypeFunctionOpenCursor), (intptr_t)0, NoIntrinsic },
    { "openKeyCursor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBIndexPrototypeFunctionOpenKeyCursor), (intptr_t)0, NoIntrinsic },
    { "get", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBIndexPrototypeFunctionGet), (intptr_t)1, NoIntrinsic },
    { "getKey", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBIndexPrototypeFunctionGetKey), (intptr_t)1, NoIntrinsic },
    { "count", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBIndexPrototypeFunctionCount), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBIndexPrototypeTable = { 33, 31, JSIDBIndexPrototypeTableValues, 0 };
static const HashTable* getJSIDBIndexPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBIndexPrototypeTable);
}

const ClassInfo JSIDBIndexPrototype::s_info = { "IDBIndexPrototype", &Base::s_info, 0, getJSIDBIndexPrototypeTable, CREATE_METHOD_TABLE(JSIDBIndexPrototype) };

JSObject* JSIDBIndexPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBIndex>(exec, globalObject);
}

bool JSIDBIndexPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBIndexPrototype* thisObject = jsCast<JSIDBIndexPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSIDBIndexPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSIDBIndexPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBIndexPrototype* thisObject = jsCast<JSIDBIndexPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSIDBIndexPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSIDBIndexTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBIndexTable);
}

const ClassInfo JSIDBIndex::s_info = { "IDBIndex", &Base::s_info, 0, getJSIDBIndexTable , CREATE_METHOD_TABLE(JSIDBIndex) };

JSIDBIndex::JSIDBIndex(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBIndex> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSIDBIndex::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBIndex::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBIndexPrototype::create(exec->vm(), globalObject, JSIDBIndexPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSIDBIndex::destroy(JSC::JSCell* cell)
{
    JSIDBIndex* thisObject = static_cast<JSIDBIndex*>(cell);
    thisObject->JSIDBIndex::~JSIDBIndex();
}

JSIDBIndex::~JSIDBIndex()
{
    releaseImplIfNotNull();
}

bool JSIDBIndex::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBIndex* thisObject = jsCast<JSIDBIndex*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBIndex, Base>(exec, getJSIDBIndexTable(exec), thisObject, propertyName, slot);
}

bool JSIDBIndex::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBIndex* thisObject = jsCast<JSIDBIndex*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBIndex, Base>(exec, getJSIDBIndexTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBIndexName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsIDBIndexObjectStore(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->objectStore()));
    return result;
}


JSValue jsIDBIndexKeyPath(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->keyPathAny()));
    return result;
}


JSValue jsIDBIndexUnique(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    JSValue result = jsBoolean(impl->unique());
    return result;
}


JSValue jsIDBIndexMultiEntry(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    JSValue result = jsBoolean(impl->multiEntry());
    return result;
}


JSValue jsIDBIndexConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBIndex* domObject = jsCast<JSIDBIndex*>(asObject(slotBase));
    return JSIDBIndex::getConstructor(exec, domObject->globalObject());
}

JSValue JSIDBIndex::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBIndexConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenCursor1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openCursor(scriptContext, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    IDBKeyRange* range(toIDBKeyRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openCursor(scriptContext, range, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    const String& direction(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openCursor(scriptContext, range, direction, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenCursor2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue key(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openCursor(scriptContext, key, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    const String& direction(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openCursor(scriptContext, key, direction, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenCursor(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if (argsCount == 0 || (argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))) || (argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))))
        return jsIDBIndexPrototypeFunctionOpenCursor1(exec);
    if (argsCount == 1 || argsCount == 2)
        return jsIDBIndexPrototypeFunctionOpenCursor2(exec);
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenKeyCursor1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openKeyCursor(scriptContext, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    IDBKeyRange* range(toIDBKeyRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openKeyCursor(scriptContext, range, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    const String& direction(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openKeyCursor(scriptContext, range, direction, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenKeyCursor2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue key(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openKeyCursor(scriptContext, key, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    const String& direction(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openKeyCursor(scriptContext, key, direction, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenKeyCursor(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if (argsCount == 0 || (argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))) || (argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))))
        return jsIDBIndexPrototypeFunctionOpenKeyCursor1(exec);
    if (argsCount == 1 || argsCount == 2)
        return jsIDBIndexPrototypeFunctionOpenKeyCursor2(exec);
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGet1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    IDBKeyRange* key(toIDBKeyRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->get(scriptContext, key, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGet2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue key(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->get(scriptContext, key, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGet(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))))
        return jsIDBIndexPrototypeFunctionGet1(exec);
    if (argsCount == 1)
        return jsIDBIndexPrototypeFunctionGet2(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetKey1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    IDBKeyRange* key(toIDBKeyRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getKey(scriptContext, key, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetKey2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue key(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getKey(scriptContext, key, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetKey(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))))
        return jsIDBIndexPrototypeFunctionGetKey1(exec);
    if (argsCount == 1)
        return jsIDBIndexPrototypeFunctionGetKey2(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionCount1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->count(scriptContext, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    IDBKeyRange* range(toIDBKeyRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->count(scriptContext, range, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionCount2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBIndex::s_info))
        return throwVMTypeError(exec);
    JSIDBIndex* castedThis = jsCast<JSIDBIndex*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBIndex::s_info);
    IDBIndex* impl = static_cast<IDBIndex*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue key(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->count(scriptContext, key, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionCount(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if (argsCount == 0 || (argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSIDBKeyRange::s_info)))))
        return jsIDBIndexPrototypeFunctionCount1(exec);
    if (argsCount == 1)
        return jsIDBIndexPrototypeFunctionCount2(exec);
    return throwVMTypeError(exec);
}

static inline bool isObservable(JSIDBIndex* jsIDBIndex)
{
    if (jsIDBIndex->hasCustomProperties())
        return true;
    return false;
}

bool JSIDBIndexOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSIDBIndex* jsIDBIndex = jsCast<JSIDBIndex*>(handle.get().asCell());
    if (!isObservable(jsIDBIndex))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBIndexOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSIDBIndex* jsIDBIndex = jsCast<JSIDBIndex*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBIndex->impl(), jsIDBIndex);
    jsIDBIndex->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBIndex* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBIndex>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IDBIndex.
    COMPILE_ASSERT(!__is_polymorphic(IDBIndex), IDBIndex_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<IDBIndex>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSIDBIndex>(exec, globalObject, impl);
}

IDBIndex* toIDBIndex(JSC::JSValue value)
{
    return value.inherits(&JSIDBIndex::s_info) ? jsCast<JSIDBIndex*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
