/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBFactory.h"

#include "ExceptionCode.h"
#include "IDBFactory.h"
#include "IDBOpenDBRequest.h"
#include "IDBRequest.h"
#include "JSDOMBinding.h"
#include "JSIDBOpenDBRequest.h"
#include "JSIDBRequest.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBFactoryTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBFactoryConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBFactoryTable = { 2, 1, JSIDBFactoryTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBFactoryConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBFactoryConstructorTable = { 1, 0, JSIDBFactoryConstructorTableValues, 0 };
static const HashTable* getJSIDBFactoryConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBFactoryConstructorTable);
}

const ClassInfo JSIDBFactoryConstructor::s_info = { "IDBFactoryConstructor", &Base::s_info, 0, getJSIDBFactoryConstructorTable, CREATE_METHOD_TABLE(JSIDBFactoryConstructor) };

JSIDBFactoryConstructor::JSIDBFactoryConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBFactoryConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBFactoryPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBFactoryConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBFactoryConstructor, JSDOMWrapper>(exec, getJSIDBFactoryConstructorTable(exec), jsCast<JSIDBFactoryConstructor*>(cell), propertyName, slot);
}

bool JSIDBFactoryConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBFactoryConstructor, JSDOMWrapper>(exec, getJSIDBFactoryConstructorTable(exec), jsCast<JSIDBFactoryConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBFactoryPrototypeTableValues[] =
{
    { "webkitGetDatabaseNames", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionWebkitGetDatabaseNames), (intptr_t)0, NoIntrinsic },
    { "open", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionOpen), (intptr_t)1, NoIntrinsic },
    { "deleteDatabase", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionDeleteDatabase), (intptr_t)1, NoIntrinsic },
    { "cmp", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionCmp), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBFactoryPrototypeTable = { 9, 7, JSIDBFactoryPrototypeTableValues, 0 };
static const HashTable* getJSIDBFactoryPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBFactoryPrototypeTable);
}

const ClassInfo JSIDBFactoryPrototype::s_info = { "IDBFactoryPrototype", &Base::s_info, 0, getJSIDBFactoryPrototypeTable, CREATE_METHOD_TABLE(JSIDBFactoryPrototype) };

JSObject* JSIDBFactoryPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBFactory>(exec, globalObject);
}

bool JSIDBFactoryPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBFactoryPrototype* thisObject = jsCast<JSIDBFactoryPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSIDBFactoryPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSIDBFactoryPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBFactoryPrototype* thisObject = jsCast<JSIDBFactoryPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSIDBFactoryPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSIDBFactoryTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBFactoryTable);
}

const ClassInfo JSIDBFactory::s_info = { "IDBFactory", &Base::s_info, 0, getJSIDBFactoryTable , CREATE_METHOD_TABLE(JSIDBFactory) };

JSIDBFactory::JSIDBFactory(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBFactory> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSIDBFactory::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBFactory::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBFactoryPrototype::create(exec->vm(), globalObject, JSIDBFactoryPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSIDBFactory::destroy(JSC::JSCell* cell)
{
    JSIDBFactory* thisObject = static_cast<JSIDBFactory*>(cell);
    thisObject->JSIDBFactory::~JSIDBFactory();
}

JSIDBFactory::~JSIDBFactory()
{
    releaseImplIfNotNull();
}

bool JSIDBFactory::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBFactory* thisObject = jsCast<JSIDBFactory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBFactory, Base>(exec, getJSIDBFactoryTable(exec), thisObject, propertyName, slot);
}

bool JSIDBFactory::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBFactory* thisObject = jsCast<JSIDBFactory*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBFactory, Base>(exec, getJSIDBFactoryTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBFactoryConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBFactory* domObject = jsCast<JSIDBFactory*>(asObject(slotBase));
    return JSIDBFactory::getConstructor(exec, domObject->globalObject());
}

JSValue JSIDBFactory::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBFactoryConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionWebkitGetDatabaseNames(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBFactory::s_info))
        return throwVMTypeError(exec);
    JSIDBFactory* castedThis = jsCast<JSIDBFactory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBFactory::s_info);
    IDBFactory* impl = static_cast<IDBFactory*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getDatabaseNames(scriptContext, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionOpen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBFactory::s_info))
        return throwVMTypeError(exec);
    JSIDBFactory* castedThis = jsCast<JSIDBFactory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBFactory::s_info);
    IDBFactory* impl = static_cast<IDBFactory*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->open(scriptContext, name, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    unsigned long long version(toUInt64(exec, exec->argument(1), EnforceRange));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->open(scriptContext, name, version, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionDeleteDatabase(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBFactory::s_info))
        return throwVMTypeError(exec);
    JSIDBFactory* castedThis = jsCast<JSIDBFactory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBFactory::s_info);
    IDBFactory* impl = static_cast<IDBFactory*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->deleteDatabase(scriptContext, name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionCmp(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBFactory::s_info))
        return throwVMTypeError(exec);
    JSIDBFactory* castedThis = jsCast<JSIDBFactory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBFactory::s_info);
    IDBFactory* impl = static_cast<IDBFactory*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    ScriptValue first(exec->vm(), exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    ScriptValue second(exec->vm(), exec->argument(1));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->cmp(scriptContext, first, second, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSIDBFactory* jsIDBFactory)
{
    if (jsIDBFactory->hasCustomProperties())
        return true;
    return false;
}

bool JSIDBFactoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSIDBFactory* jsIDBFactory = jsCast<JSIDBFactory*>(handle.get().asCell());
    if (!isObservable(jsIDBFactory))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBFactoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSIDBFactory* jsIDBFactory = jsCast<JSIDBFactory*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBFactory->impl(), jsIDBFactory);
    jsIDBFactory->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBFactory* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBFactory>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IDBFactory.
    COMPILE_ASSERT(!__is_polymorphic(IDBFactory), IDBFactory_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<IDBFactory>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSIDBFactory>(exec, globalObject, impl);
}

IDBFactory* toIDBFactory(JSC::JSValue value)
{
    return value.inherits(&JSIDBFactory::s_info) ? jsCast<JSIDBFactory*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
