/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBDatabase.h"

#include "DOMStringList.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "IDBAny.h"
#include "IDBDatabase.h"
#include "IDBObjectStore.h"
#include "IDBTransaction.h"
#include "JSDOMBinding.h"
#include "JSDOMStringList.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSIDBAny.h"
#include "JSIDBTransaction.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBDatabaseTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseName), (intptr_t)0, NoIntrinsic },
    { "version", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseVersion), (intptr_t)0, NoIntrinsic },
    { "objectStoreNames", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseObjectStoreNames), (intptr_t)0, NoIntrinsic },
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseOnabort), (intptr_t)setJSIDBDatabaseOnabort, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseOnerror), (intptr_t)setJSIDBDatabaseOnerror, NoIntrinsic },
    { "onversionchange", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseOnversionchange), (intptr_t)setJSIDBDatabaseOnversionchange, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBDatabaseTable = { 17, 15, JSIDBDatabaseTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBDatabaseConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBDatabaseConstructorTable = { 1, 0, JSIDBDatabaseConstructorTableValues, 0 };
static const HashTable* getJSIDBDatabaseConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBDatabaseConstructorTable);
}

const ClassInfo JSIDBDatabaseConstructor::s_info = { "IDBDatabaseConstructor", &Base::s_info, 0, getJSIDBDatabaseConstructorTable, CREATE_METHOD_TABLE(JSIDBDatabaseConstructor) };

JSIDBDatabaseConstructor::JSIDBDatabaseConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBDatabaseConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBDatabasePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBDatabaseConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBDatabaseConstructor, JSDOMWrapper>(exec, getJSIDBDatabaseConstructorTable(exec), jsCast<JSIDBDatabaseConstructor*>(cell), propertyName, slot);
}

bool JSIDBDatabaseConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBDatabaseConstructor, JSDOMWrapper>(exec, getJSIDBDatabaseConstructorTable(exec), jsCast<JSIDBDatabaseConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBDatabasePrototypeTableValues[] =
{
    { "createObjectStore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionCreateObjectStore), (intptr_t)1, NoIntrinsic },
    { "deleteObjectStore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionDeleteObjectStore), (intptr_t)1, NoIntrinsic },
    { "transaction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionTransaction), (intptr_t)1, NoIntrinsic },
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabasePrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBDatabasePrototypeTable = { 32, 31, JSIDBDatabasePrototypeTableValues, 0 };
static const HashTable* getJSIDBDatabasePrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBDatabasePrototypeTable);
}

const ClassInfo JSIDBDatabasePrototype::s_info = { "IDBDatabasePrototype", &Base::s_info, 0, getJSIDBDatabasePrototypeTable, CREATE_METHOD_TABLE(JSIDBDatabasePrototype) };

JSObject* JSIDBDatabasePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBDatabase>(exec, globalObject);
}

bool JSIDBDatabasePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBDatabasePrototype* thisObject = jsCast<JSIDBDatabasePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSIDBDatabasePrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSIDBDatabasePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBDatabasePrototype* thisObject = jsCast<JSIDBDatabasePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSIDBDatabasePrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSIDBDatabaseTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBDatabaseTable);
}

const ClassInfo JSIDBDatabase::s_info = { "IDBDatabase", &Base::s_info, 0, getJSIDBDatabaseTable , CREATE_METHOD_TABLE(JSIDBDatabase) };

JSIDBDatabase::JSIDBDatabase(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBDatabase> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSIDBDatabase::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBDatabase::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBDatabasePrototype::create(exec->vm(), globalObject, JSIDBDatabasePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSIDBDatabase::destroy(JSC::JSCell* cell)
{
    JSIDBDatabase* thisObject = static_cast<JSIDBDatabase*>(cell);
    thisObject->JSIDBDatabase::~JSIDBDatabase();
}

JSIDBDatabase::~JSIDBDatabase()
{
    releaseImplIfNotNull();
}

bool JSIDBDatabase::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBDatabase* thisObject = jsCast<JSIDBDatabase*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBDatabase, Base>(exec, getJSIDBDatabaseTable(exec), thisObject, propertyName, slot);
}

bool JSIDBDatabase::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBDatabase* thisObject = jsCast<JSIDBDatabase*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBDatabase, Base>(exec, getJSIDBDatabaseTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBDatabaseName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsIDBDatabaseVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->version()));
    return result;
}


JSValue jsIDBDatabaseObjectStoreNames(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->objectStoreNames()));
    return result;
}


JSValue jsIDBDatabaseOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBDatabaseOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBDatabaseOnversionchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (EventListener* listener = impl->onversionchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsIDBDatabaseConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBDatabase* domObject = jsCast<JSIDBDatabase*>(asObject(slotBase));
    return JSIDBDatabase::getConstructor(exec, domObject->globalObject());
}

void JSIDBDatabase::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSIDBDatabase* thisObject = jsCast<JSIDBDatabase*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSIDBDatabase, Base>(exec, propertyName, value, getJSIDBDatabaseTable(exec), thisObject, slot);
}

void setJSIDBDatabaseOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(thisObject);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    impl->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSIDBDatabaseOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(thisObject);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSIDBDatabaseOnversionchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(thisObject);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    impl->setOnversionchange(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSIDBDatabase::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBDatabaseConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionCreateObjectStore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    return JSValue::encode(castedThis->createObjectStore(exec));
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionDeleteObjectStore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteObjectStore(name, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionTransaction1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    RefPtr<DOMStringList> storeNames(toDOMStringList(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& mode(argumentOrNull(exec, 1).isEmpty() ? String() : argumentOrNull(exec, 1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->transaction(scriptContext, storeNames, mode, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionTransaction2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Vector<String> storeNames(toNativeArray<String>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& mode(argumentOrNull(exec, 1).isEmpty() ? String() : argumentOrNull(exec, 1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->transaction(scriptContext, storeNames, mode, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionTransaction3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& storeName(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& mode(argumentOrNull(exec, 1).isEmpty() ? String() : argumentOrNull(exec, 1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->transaction(scriptContext, storeName, mode, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionTransaction(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isObject() && asObject(arg0)->inherits(&JSDOMStringList::s_info))) || (argsCount == 2 && (arg0.isObject() && asObject(arg0)->inherits(&JSDOMStringList::s_info))))
        return jsIDBDatabasePrototypeFunctionTransaction1(exec);
    if ((argsCount == 1 && (arg0.isObject() && isJSArray(arg0))) || (argsCount == 2 && (arg0.isObject() && isJSArray(arg0))))
        return jsIDBDatabasePrototypeFunctionTransaction2(exec);
    if (argsCount == 1 || argsCount == 2)
        return jsIDBDatabasePrototypeFunctionTransaction3(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabasePrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabase::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabase* castedThis = jsCast<JSIDBDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSIDBDatabase::s_info);
    IDBDatabase* impl = static_cast<IDBDatabase*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSIDBDatabase::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSIDBDatabase* thisObject = jsCast<JSIDBDatabase*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSIDBDatabase* jsIDBDatabase)
{
    if (jsIDBDatabase->hasCustomProperties())
        return true;
    if (jsIDBDatabase->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSIDBDatabaseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSIDBDatabase* jsIDBDatabase = jsCast<JSIDBDatabase*>(handle.get().asCell());
    if (jsIDBDatabase->impl()->hasPendingActivity())
        return true;
    if (jsIDBDatabase->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsIDBDatabase))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBDatabaseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSIDBDatabase* jsIDBDatabase = jsCast<JSIDBDatabase*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBDatabase->impl(), jsIDBDatabase);
    jsIDBDatabase->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IDBDatabase@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11IDBDatabaseE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBDatabase* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBDatabase>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7IDBDatabase@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11IDBDatabaseE[2];
#if COMPILER(CLANG)
    // If this fails IDBDatabase does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(IDBDatabase), IDBDatabase_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // IDBDatabase has subclasses. If IDBDatabase has subclasses that get passed
    // to toJS() we currently require IDBDatabase you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<IDBDatabase>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSIDBDatabase>(exec, globalObject, impl);
}

IDBDatabase* toIDBDatabase(JSC::JSValue value)
{
    return value.inherits(&JSIDBDatabase::s_info) ? jsCast<JSIDBDatabase*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
