/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MANX_HTMLTILE)

#include "JSHTMLTile.h"

#include "EventListener.h"
#include "ExceptionCode.h"
#include "HTMLTile.h"
#include "ImageData.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "JSImageData.h"
#include "JSStringCallback.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTileTableValues[] =
{
    { "isValid", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileIsValid), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileHeight), (intptr_t)0, NoIntrinsic },
    { "imageData", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileImageData), (intptr_t)0, NoIntrinsic },
    { "url", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileUrl), (intptr_t)setJSHTMLTileUrl, NoIntrinsic },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileSrc), (intptr_t)setJSHTMLTileSrc, NoIntrinsic },
    { "onload", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileOnload), (intptr_t)setJSHTMLTileOnload, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileOnerror), (intptr_t)setJSHTMLTileOnerror, NoIntrinsic },
    { "onupdate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileOnupdate), (intptr_t)setJSHTMLTileOnupdate, NoIntrinsic },
    { "onlocationchange", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileOnlocationchange), (intptr_t)setJSHTMLTileOnlocationchange, NoIntrinsic },
    { "onunresponsive", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileOnunresponsive), (intptr_t)setJSHTMLTileOnunresponsive, NoIntrinsic },
    { "oncrash", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileOncrash), (intptr_t)setJSHTMLTileOncrash, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTileTable = { 34, 31, JSHTMLTileTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTileConstructorTableValues[] =
{
    { "FocusIn", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileFocusIn), (intptr_t)0, NoIntrinsic },
    { "FocusOut", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileFocusOut), (intptr_t)0, NoIntrinsic },
    { "ButtonPress", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileButtonPress), (intptr_t)0, NoIntrinsic },
    { "ButtonRelease", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileButtonRelease), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTileConstructorTable = { 8, 7, JSHTMLTileConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSHTMLTileConstructor::constructJSHTMLTile(ExecState* exec)
{
    JSHTMLTileConstructor* castedThis = jsCast<JSHTMLTileConstructor*>(exec->callee());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int x(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "HTMLTile constructor associated document is unavailable"));
    RefPtr<HTMLTile> object = HTMLTile::create(context, x, y);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSHTMLTileConstructor::s_info = { "HTMLTileConstructor", &Base::s_info, &JSHTMLTileConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTileConstructor) };

JSHTMLTileConstructor::JSHTMLTileConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTileConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLTilePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLTileConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTileConstructor, JSDOMWrapper>(exec, &JSHTMLTileConstructorTable, jsCast<JSHTMLTileConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTileConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTileConstructor, JSDOMWrapper>(exec, &JSHTMLTileConstructorTable, jsCast<JSHTMLTileConstructor*>(object), propertyName, descriptor);
}

ConstructType JSHTMLTileConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSHTMLTile;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTilePrototypeTableValues[] =
{
    { "FocusIn", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileFocusIn), (intptr_t)0, NoIntrinsic },
    { "FocusOut", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileFocusOut), (intptr_t)0, NoIntrinsic },
    { "ButtonPress", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileButtonPress), (intptr_t)0, NoIntrinsic },
    { "ButtonRelease", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTileButtonRelease), (intptr_t)0, NoIntrinsic },
    { "destroy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTilePrototypeFunctionDestroy), (intptr_t)0, NoIntrinsic },
    { "pause", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTilePrototypeFunctionPause), (intptr_t)0, NoIntrinsic },
    { "resume", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTilePrototypeFunctionResume), (intptr_t)0, NoIntrinsic },
    { "sendEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTilePrototypeFunctionSendEvent), (intptr_t)1, NoIntrinsic },
    { "eval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTilePrototypeFunctionEval), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTilePrototypeTable = { 33, 31, JSHTMLTilePrototypeTableValues, 0 };
const ClassInfo JSHTMLTilePrototype::s_info = { "HTMLTilePrototype", &Base::s_info, &JSHTMLTilePrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTilePrototype) };

JSObject* JSHTMLTilePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTile>(exec, globalObject);
}

bool JSHTMLTilePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTilePrototype* thisObject = jsCast<JSHTMLTilePrototype*>(cell);
    return getStaticPropertySlot<JSHTMLTilePrototype, JSObject>(exec, &JSHTMLTilePrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLTilePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTilePrototype* thisObject = jsCast<JSHTMLTilePrototype*>(object);
    return getStaticPropertyDescriptor<JSHTMLTilePrototype, JSObject>(exec, &JSHTMLTilePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLTile::s_info = { "HTMLTile", &Base::s_info, &JSHTMLTileTable, 0 , CREATE_METHOD_TABLE(JSHTMLTile) };

JSHTMLTile::JSHTMLTile(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTile> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSHTMLTile::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTile::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTilePrototype::create(exec->vm(), globalObject, JSHTMLTilePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSHTMLTile::destroy(JSC::JSCell* cell)
{
    JSHTMLTile* thisObject = static_cast<JSHTMLTile*>(cell);
    thisObject->JSHTMLTile::~JSHTMLTile();
}

JSHTMLTile::~JSHTMLTile()
{
    releaseImplIfNotNull();
}

bool JSHTMLTile::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTile* thisObject = jsCast<JSHTMLTile*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTile, Base>(exec, &JSHTMLTileTable, thisObject, propertyName, slot);
}

bool JSHTMLTile::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTile* thisObject = jsCast<JSHTMLTile*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTile, Base>(exec, &JSHTMLTileTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTileIsValid(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isValid());
    return result;
}


JSValue jsHTMLTileWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsHTMLTileHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsHTMLTileImageData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->imageData()));
    return result;
}


JSValue jsHTMLTileUrl(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->url());
    return result;
}


JSValue jsHTMLTileSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->url());
    return result;
}


JSValue jsHTMLTileOnload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (EventListener* listener = impl->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLTileOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLTileOnupdate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (EventListener* listener = impl->onupdate()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLTileOnlocationchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (EventListener* listener = impl->onlocationchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLTileOnunresponsive(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (EventListener* listener = impl->onunresponsive()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLTileOncrash(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (EventListener* listener = impl->oncrash()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsHTMLTileConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTile* domObject = jsCast<JSHTMLTile*>(asObject(slotBase));
    return JSHTMLTile::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTile::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTile* thisObject = jsCast<JSHTMLTile*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTile, Base>(exec, propertyName, value, &JSHTMLTileTable, thisObject, slot);
}

void setJSHTMLTileUrl(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setUrl(nativeValue);
}


void setJSHTMLTileSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setUrl(nativeValue);
}


void setJSHTMLTileOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSHTMLTileOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSHTMLTileOnupdate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->setOnupdate(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSHTMLTileOnlocationchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->setOnlocationchange(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSHTMLTileOnunresponsive(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->setOnunresponsive(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSHTMLTileOncrash(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(thisObject);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->setOncrash(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSHTMLTile::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTileConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTilePrototypeFunctionDestroy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTile::s_info))
        return throwVMTypeError(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTile::s_info);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->destroy();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTilePrototypeFunctionPause(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTile::s_info))
        return throwVMTypeError(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTile::s_info);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTilePrototypeFunctionResume(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTile::s_info))
        return throwVMTypeError(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTile::s_info);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    impl->resume();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTilePrototypeFunctionSendEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTile::s_info))
        return throwVMTypeError(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTile::s_info);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned short event(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->sendEvent(event);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTilePrototypeFunctionEval(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTile::s_info))
        return throwVMTypeError(exec);
    JSHTMLTile* castedThis = jsCast<JSHTMLTile*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTile::s_info);
    HTMLTile* impl = static_cast<HTMLTile*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& string(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<StringCallback> resultCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        resultCallback = JSStringCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    impl->eval(string, resultCallback);
    return JSValue::encode(jsUndefined());
}

void JSHTMLTile::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSHTMLTile* thisObject = jsCast<JSHTMLTile*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

// Constant getters

JSValue jsHTMLTileFocusIn(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsHTMLTileFocusOut(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsHTMLTileButtonPress(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsHTMLTileButtonRelease(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

static inline bool isObservable(JSHTMLTile* jsHTMLTile)
{
    if (jsHTMLTile->hasCustomProperties())
        return true;
    if (jsHTMLTile->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSHTMLTileOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSHTMLTile* jsHTMLTile = jsCast<JSHTMLTile*>(handle.get().asCell());
    if (jsHTMLTile->impl()->hasPendingActivity())
        return true;
    if (jsHTMLTile->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsHTMLTile))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSHTMLTileOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSHTMLTile* jsHTMLTile = jsCast<JSHTMLTile*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHTMLTile->impl(), jsHTMLTile);
    jsHTMLTile->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7HTMLTile@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8HTMLTileE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, HTMLTile* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSHTMLTile>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7HTMLTile@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore8HTMLTileE[2];
#if COMPILER(CLANG)
    // If this fails HTMLTile does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(HTMLTile), HTMLTile_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // HTMLTile has subclasses. If HTMLTile has subclasses that get passed
    // to toJS() we currently require HTMLTile you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<HTMLTile>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSHTMLTile>(exec, globalObject, impl);
}

HTMLTile* toHTMLTile(JSC::JSValue value)
{
    return value.inherits(&JSHTMLTile::s_info) ? jsCast<JSHTMLTile*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MANX_HTMLTILE)
