/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TEMPLATE_ELEMENT)

#include "JSHTMLTemplateElement.h"

#include "HTMLTemplateElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTemplateElementTableValues[] =
{
    { "content", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTemplateElementContent), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTemplateElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTemplateElementTable = { 5, 3, JSHTMLTemplateElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTemplateElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTemplateElementConstructorTable = { 1, 0, JSHTMLTemplateElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTemplateElementConstructor::s_info = { "HTMLTemplateElementConstructor", &Base::s_info, &JSHTMLTemplateElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTemplateElementConstructor) };

JSHTMLTemplateElementConstructor::JSHTMLTemplateElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTemplateElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLTemplateElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLTemplateElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTemplateElementConstructor, JSDOMWrapper>(exec, &JSHTMLTemplateElementConstructorTable, jsCast<JSHTMLTemplateElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTemplateElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTemplateElementConstructor, JSDOMWrapper>(exec, &JSHTMLTemplateElementConstructorTable, jsCast<JSHTMLTemplateElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTemplateElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTemplateElementPrototypeTable = { 1, 0, JSHTMLTemplateElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTemplateElementPrototype::s_info = { "HTMLTemplateElementPrototype", &Base::s_info, &JSHTMLTemplateElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTemplateElementPrototype) };

JSObject* JSHTMLTemplateElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTemplateElement>(exec, globalObject);
}

const ClassInfo JSHTMLTemplateElement::s_info = { "HTMLTemplateElement", &Base::s_info, &JSHTMLTemplateElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTemplateElement) };

JSHTMLTemplateElement::JSHTMLTemplateElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTemplateElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTemplateElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTemplateElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTemplateElementPrototype::create(exec->vm(), globalObject, JSHTMLTemplateElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTemplateElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTemplateElement* thisObject = jsCast<JSHTMLTemplateElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTemplateElement, Base>(exec, &JSHTMLTemplateElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTemplateElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTemplateElement* thisObject = jsCast<JSHTMLTemplateElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTemplateElement, Base>(exec, &JSHTMLTemplateElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTemplateElementContent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTemplateElement* castedThis = jsCast<JSHTMLTemplateElement*>(asObject(slotBase));
    return castedThis->content(exec);
}


JSValue jsHTMLTemplateElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTemplateElement* domObject = jsCast<JSHTMLTemplateElement*>(asObject(slotBase));
    return JSHTMLTemplateElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSHTMLTemplateElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTemplateElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(TEMPLATE_ELEMENT)
