/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLSpanElement.h"

#include "HTMLSpanElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLSpanElementTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSpanElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSpanElementTable = { 2, 1, JSHTMLSpanElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLSpanElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSpanElementConstructorTable = { 1, 0, JSHTMLSpanElementConstructorTableValues, 0 };
const ClassInfo JSHTMLSpanElementConstructor::s_info = { "HTMLSpanElementConstructor", &Base::s_info, &JSHTMLSpanElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLSpanElementConstructor) };

JSHTMLSpanElementConstructor::JSHTMLSpanElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLSpanElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLSpanElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLSpanElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSpanElementConstructor, JSDOMWrapper>(exec, &JSHTMLSpanElementConstructorTable, jsCast<JSHTMLSpanElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLSpanElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLSpanElementConstructor, JSDOMWrapper>(exec, &JSHTMLSpanElementConstructorTable, jsCast<JSHTMLSpanElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLSpanElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSpanElementPrototypeTable = { 1, 0, JSHTMLSpanElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLSpanElementPrototype::s_info = { "HTMLSpanElementPrototype", &Base::s_info, &JSHTMLSpanElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLSpanElementPrototype) };

JSObject* JSHTMLSpanElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSpanElement>(exec, globalObject);
}

const ClassInfo JSHTMLSpanElement::s_info = { "HTMLSpanElement", &Base::s_info, &JSHTMLSpanElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLSpanElement) };

JSHTMLSpanElement::JSHTMLSpanElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLSpanElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLSpanElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLSpanElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLSpanElementPrototype::create(exec->vm(), globalObject, JSHTMLSpanElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLSpanElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLSpanElement* thisObject = jsCast<JSHTMLSpanElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLSpanElement, Base>(exec, &JSHTMLSpanElementTable, thisObject, propertyName, slot);
}

bool JSHTMLSpanElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLSpanElement* thisObject = jsCast<JSHTMLSpanElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLSpanElement, Base>(exec, &JSHTMLSpanElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLSpanElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSpanElement* domObject = jsCast<JSHTMLSpanElement*>(asObject(slotBase));
    return JSHTMLSpanElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSHTMLSpanElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSpanElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
