/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MICRODATA)

#include "JSHTMLPropertiesCollection.h"

#include "DOMStringList.h"
#include "ExceptionCode.h"
#include "HTMLPropertiesCollection.h"
#include "JSDOMBinding.h"
#include "JSDOMStringList.h"
#include "JSNode.h"
#include "JSPropertyNodeList.h"
#include "Node.h"
#include "PropertyNodeList.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLPropertiesCollectionTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPropertiesCollectionLength), (intptr_t)0, NoIntrinsic },
    { "names", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPropertiesCollectionNames), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPropertiesCollectionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLPropertiesCollectionTable = { 9, 7, JSHTMLPropertiesCollectionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLPropertiesCollectionConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLPropertiesCollectionConstructorTable = { 1, 0, JSHTMLPropertiesCollectionConstructorTableValues, 0 };
const ClassInfo JSHTMLPropertiesCollectionConstructor::s_info = { "HTMLPropertiesCollectionConstructor", &Base::s_info, &JSHTMLPropertiesCollectionConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLPropertiesCollectionConstructor) };

JSHTMLPropertiesCollectionConstructor::JSHTMLPropertiesCollectionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLPropertiesCollectionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLPropertiesCollectionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLPropertiesCollectionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLPropertiesCollectionConstructor, JSDOMWrapper>(exec, &JSHTMLPropertiesCollectionConstructorTable, jsCast<JSHTMLPropertiesCollectionConstructor*>(cell), propertyName, slot);
}

bool JSHTMLPropertiesCollectionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLPropertiesCollectionConstructor, JSDOMWrapper>(exec, &JSHTMLPropertiesCollectionConstructorTable, jsCast<JSHTMLPropertiesCollectionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLPropertiesCollectionPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLPropertiesCollectionPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "namedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLPropertiesCollectionPrototypeFunctionNamedItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLPropertiesCollectionPrototypeTable = { 5, 3, JSHTMLPropertiesCollectionPrototypeTableValues, 0 };
const ClassInfo JSHTMLPropertiesCollectionPrototype::s_info = { "HTMLPropertiesCollectionPrototype", &Base::s_info, &JSHTMLPropertiesCollectionPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLPropertiesCollectionPrototype) };

JSObject* JSHTMLPropertiesCollectionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLPropertiesCollection>(exec, globalObject);
}

bool JSHTMLPropertiesCollectionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLPropertiesCollectionPrototype* thisObject = jsCast<JSHTMLPropertiesCollectionPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLPropertiesCollectionPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLPropertiesCollectionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLPropertiesCollectionPrototype* thisObject = jsCast<JSHTMLPropertiesCollectionPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLPropertiesCollectionPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLPropertiesCollection::s_info = { "HTMLPropertiesCollection", &Base::s_info, &JSHTMLPropertiesCollectionTable, 0 , CREATE_METHOD_TABLE(JSHTMLPropertiesCollection) };

JSHTMLPropertiesCollection::JSHTMLPropertiesCollection(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLPropertiesCollection> impl)
    : JSHTMLCollection(structure, globalObject, impl)
{
}

void JSHTMLPropertiesCollection::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLPropertiesCollection::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLPropertiesCollectionPrototype::create(exec->vm(), globalObject, JSHTMLPropertiesCollectionPrototype::createStructure(exec->vm(), globalObject, JSHTMLCollectionPrototype::self(exec, globalObject)));
}

bool JSHTMLPropertiesCollection::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLPropertiesCollection* thisObject = jsCast<JSHTMLPropertiesCollection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(asObject(proto))->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSHTMLPropertiesCollection>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<HTMLPropertiesCollection*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<HTMLPropertiesCollection*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLPropertiesCollection, Base>(exec, &JSHTMLPropertiesCollectionTable, thisObject, propertyName, slot);
}

bool JSHTMLPropertiesCollection::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLPropertiesCollection* thisObject = jsCast<JSHTMLPropertiesCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(asObject(proto))->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = JSHTMLPropertiesCollectionTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<HTMLPropertiesCollection*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<HTMLPropertiesCollection*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSHTMLPropertiesCollection, Base>(exec, &JSHTMLPropertiesCollectionTable, thisObject, propertyName, descriptor);
}

bool JSHTMLPropertiesCollection::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHTMLPropertiesCollection* thisObject = jsCast<JSHTMLPropertiesCollection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<HTMLPropertiesCollection*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<HTMLPropertiesCollection*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHTMLPropertiesCollectionLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLPropertiesCollection* castedThis = jsCast<JSHTMLPropertiesCollection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLPropertiesCollection* impl = static_cast<HTMLPropertiesCollection*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsHTMLPropertiesCollectionNames(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLPropertiesCollection* castedThis = jsCast<JSHTMLPropertiesCollection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLPropertiesCollection* impl = static_cast<HTMLPropertiesCollection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->names()));
    return result;
}


JSValue jsHTMLPropertiesCollectionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLPropertiesCollection* domObject = jsCast<JSHTMLPropertiesCollection*>(asObject(slotBase));
    return JSHTMLPropertiesCollection::getConstructor(exec, domObject->globalObject());
}

void JSHTMLPropertiesCollection::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSHTMLPropertiesCollection* thisObject = jsCast<JSHTMLPropertiesCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<HTMLPropertiesCollection*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSHTMLPropertiesCollection::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLPropertiesCollectionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLPropertiesCollectionPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLPropertiesCollection::s_info))
        return throwVMTypeError(exec);
    JSHTMLPropertiesCollection* castedThis = jsCast<JSHTMLPropertiesCollection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLPropertiesCollection::s_info);
    HTMLPropertiesCollection* impl = static_cast<HTMLPropertiesCollection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLPropertiesCollectionPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLPropertiesCollection::s_info))
        return throwVMTypeError(exec);
    JSHTMLPropertiesCollection* castedThis = jsCast<JSHTMLPropertiesCollection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLPropertiesCollection::s_info);
    HTMLPropertiesCollection* impl = static_cast<HTMLPropertiesCollection*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->propertyNodeList(name)));
    return JSValue::encode(result);
}


JSValue JSHTMLPropertiesCollection::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSHTMLPropertiesCollection* thisObj = jsCast<JSHTMLPropertiesCollection*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<HTMLPropertiesCollection*>(thisObj->impl())->item(index));
}

bool JSHTMLPropertiesCollection::canGetItemsForName(ExecState*, HTMLPropertiesCollection* collection, PropertyName propertyName)
{
    return collection->hasNamedItem(propertyNameToAtomicString(propertyName));
}

JSValue JSHTMLPropertiesCollection::nameGetter(ExecState* exec, JSValue slotBase, PropertyName propertyName)
{
    JSHTMLPropertiesCollection* thisObj = jsCast<JSHTMLPropertiesCollection*>(asObject(slotBase));
    return toJS(exec, thisObj->globalObject(), WTF::getPtr(static_cast<HTMLPropertiesCollection*>(thisObj->impl())->propertyNodeList(propertyNameToAtomicString(propertyName))));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7HTMLPropertiesCollection@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24HTMLPropertiesCollectionE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, HTMLPropertiesCollection* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSHTMLPropertiesCollection>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7HTMLPropertiesCollection@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24HTMLPropertiesCollectionE[2];
#if COMPILER(CLANG)
    // If this fails HTMLPropertiesCollection does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(HTMLPropertiesCollection), HTMLPropertiesCollection_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // HTMLPropertiesCollection has subclasses. If HTMLPropertiesCollection has subclasses that get passed
    // to toJS() we currently require HTMLPropertiesCollection you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<HTMLPropertiesCollection>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSHTMLPropertiesCollection>(exec, globalObject, impl);
}


}

#endif // ENABLE(MICRODATA)
