/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLLabelElement.h"

#include "HTMLElement.h"
#include "HTMLFormElement.h"
#include "HTMLLabelElement.h"
#include "HTMLNames.h"
#include "JSHTMLElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLLabelElementTableValues[] =
{
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementForm), (intptr_t)0, NoIntrinsic },
    { "htmlFor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementHtmlFor), (intptr_t)setJSHTMLLabelElementHtmlFor, NoIntrinsic },
    { "control", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementControl), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLabelElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLLabelElementTable = { 9, 7, JSHTMLLabelElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLLabelElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLLabelElementConstructorTable = { 1, 0, JSHTMLLabelElementConstructorTableValues, 0 };
const ClassInfo JSHTMLLabelElementConstructor::s_info = { "HTMLLabelElementConstructor", &Base::s_info, &JSHTMLLabelElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLLabelElementConstructor) };

JSHTMLLabelElementConstructor::JSHTMLLabelElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLLabelElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLLabelElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLLabelElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLabelElementConstructor, JSDOMWrapper>(exec, &JSHTMLLabelElementConstructorTable, jsCast<JSHTMLLabelElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLLabelElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLLabelElementConstructor, JSDOMWrapper>(exec, &JSHTMLLabelElementConstructorTable, jsCast<JSHTMLLabelElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLLabelElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLLabelElementPrototypeTable = { 1, 0, JSHTMLLabelElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLLabelElementPrototype::s_info = { "HTMLLabelElementPrototype", &Base::s_info, &JSHTMLLabelElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLLabelElementPrototype) };

JSObject* JSHTMLLabelElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLLabelElement>(exec, globalObject);
}

const ClassInfo JSHTMLLabelElement::s_info = { "HTMLLabelElement", &Base::s_info, &JSHTMLLabelElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLLabelElement) };

JSHTMLLabelElement::JSHTMLLabelElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLLabelElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLLabelElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLLabelElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLLabelElementPrototype::create(exec->vm(), globalObject, JSHTMLLabelElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLLabelElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLLabelElement* thisObject = jsCast<JSHTMLLabelElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLLabelElement, Base>(exec, &JSHTMLLabelElementTable, thisObject, propertyName, slot);
}

bool JSHTMLLabelElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLLabelElement* thisObject = jsCast<JSHTMLLabelElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLLabelElement, Base>(exec, &JSHTMLLabelElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLLabelElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLabelElement* castedThis = jsCast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* impl = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLLabelElementHtmlFor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLabelElement* castedThis = jsCast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* impl = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::forAttr));
    return result;
}


JSValue jsHTMLLabelElementControl(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLabelElement* castedThis = jsCast<JSHTMLLabelElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLabelElement* impl = static_cast<HTMLLabelElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->control()));
    return result;
}


JSValue jsHTMLLabelElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLabelElement* domObject = jsCast<JSHTMLLabelElement*>(asObject(slotBase));
    return JSHTMLLabelElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLLabelElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLLabelElement* thisObject = jsCast<JSHTMLLabelElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLLabelElement, Base>(exec, propertyName, value, &JSHTMLLabelElementTable, thisObject, slot);
}

void setJSHTMLLabelElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLLabelElement* castedThis = jsCast<JSHTMLLabelElement*>(thisObject);
    HTMLLabelElement* impl = static_cast<HTMLLabelElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::forAttr, nativeValue);
}


JSValue JSHTMLLabelElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLLabelElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
