/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFieldSetElement.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLFieldSetElement.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSHTMLCollection.h"
#include "JSHTMLFormElement.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLFieldSetElementTableValues[] =
{
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementDisabled), (intptr_t)setJSHTMLFieldSetElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementForm), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementName), (intptr_t)setJSHTMLFieldSetElementName, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementType), (intptr_t)0, NoIntrinsic },
    { "elements", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementElements), (intptr_t)0, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFieldSetElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFieldSetElementTable = { 33, 31, JSHTMLFieldSetElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLFieldSetElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFieldSetElementConstructorTable = { 1, 0, JSHTMLFieldSetElementConstructorTableValues, 0 };
const ClassInfo JSHTMLFieldSetElementConstructor::s_info = { "HTMLFieldSetElementConstructor", &Base::s_info, &JSHTMLFieldSetElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLFieldSetElementConstructor) };

JSHTMLFieldSetElementConstructor::JSHTMLFieldSetElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLFieldSetElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLFieldSetElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLFieldSetElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFieldSetElementConstructor, JSDOMWrapper>(exec, &JSHTMLFieldSetElementConstructorTable, jsCast<JSHTMLFieldSetElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLFieldSetElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFieldSetElementConstructor, JSDOMWrapper>(exec, &JSHTMLFieldSetElementConstructorTable, jsCast<JSHTMLFieldSetElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLFieldSetElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLFieldSetElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLFieldSetElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFieldSetElementPrototypeTable = { 4, 3, JSHTMLFieldSetElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLFieldSetElementPrototype::s_info = { "HTMLFieldSetElementPrototype", &Base::s_info, &JSHTMLFieldSetElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLFieldSetElementPrototype) };

JSObject* JSHTMLFieldSetElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFieldSetElement>(exec, globalObject);
}

bool JSHTMLFieldSetElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLFieldSetElementPrototype* thisObject = jsCast<JSHTMLFieldSetElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLFieldSetElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLFieldSetElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLFieldSetElementPrototype* thisObject = jsCast<JSHTMLFieldSetElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLFieldSetElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLFieldSetElement::s_info = { "HTMLFieldSetElement", &Base::s_info, &JSHTMLFieldSetElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLFieldSetElement) };

JSHTMLFieldSetElement::JSHTMLFieldSetElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLFieldSetElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLFieldSetElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLFieldSetElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLFieldSetElementPrototype::create(exec->vm(), globalObject, JSHTMLFieldSetElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLFieldSetElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLFieldSetElement* thisObject = jsCast<JSHTMLFieldSetElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLFieldSetElement, Base>(exec, &JSHTMLFieldSetElementTable, thisObject, propertyName, slot);
}

bool JSHTMLFieldSetElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLFieldSetElement* thisObject = jsCast<JSHTMLFieldSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLFieldSetElement, Base>(exec, &JSHTMLFieldSetElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLFieldSetElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLFieldSetElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLFieldSetElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLFieldSetElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLFieldSetElementElements(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->elements()));
    return result;
}


JSValue jsHTMLFieldSetElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLFieldSetElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLFieldSetElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLFieldSetElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFieldSetElement* domObject = jsCast<JSHTMLFieldSetElement*>(asObject(slotBase));
    return JSHTMLFieldSetElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLFieldSetElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLFieldSetElement* thisObject = jsCast<JSHTMLFieldSetElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLFieldSetElement, Base>(exec, propertyName, value, &JSHTMLFieldSetElementTable, thisObject, slot);
}

void setJSHTMLFieldSetElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(thisObject);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, nativeValue);
}


void setJSHTMLFieldSetElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(thisObject);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::nameAttr, nativeValue);
}


JSValue JSHTMLFieldSetElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFieldSetElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLFieldSetElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLFieldSetElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLFieldSetElement::s_info);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLFieldSetElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLFieldSetElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLFieldSetElement* castedThis = jsCast<JSHTMLFieldSetElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLFieldSetElement::s_info);
    HTMLFieldSetElement* impl = static_cast<HTMLFieldSetElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


}
