/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DIALOG_ELEMENT)

#include "JSHTMLDialogElement.h"

#include "ExceptionCode.h"
#include "HTMLDialogElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLDialogElementTableValues[] =
{
    { "open", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDialogElementOpen), (intptr_t)setJSHTMLDialogElementOpen, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDialogElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDialogElementTable = { 4, 3, JSHTMLDialogElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLDialogElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDialogElementConstructorTable = { 1, 0, JSHTMLDialogElementConstructorTableValues, 0 };
const ClassInfo JSHTMLDialogElementConstructor::s_info = { "HTMLDialogElementConstructor", &Base::s_info, &JSHTMLDialogElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLDialogElementConstructor) };

JSHTMLDialogElementConstructor::JSHTMLDialogElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLDialogElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLDialogElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLDialogElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDialogElementConstructor, JSDOMWrapper>(exec, &JSHTMLDialogElementConstructorTable, jsCast<JSHTMLDialogElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLDialogElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDialogElementConstructor, JSDOMWrapper>(exec, &JSHTMLDialogElementConstructorTable, jsCast<JSHTMLDialogElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDialogElementPrototypeTableValues[] =
{
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDialogElementPrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "show", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDialogElementPrototypeFunctionShow), (intptr_t)0, NoIntrinsic },
    { "showModal", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDialogElementPrototypeFunctionShowModal), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDialogElementPrototypeTable = { 9, 7, JSHTMLDialogElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLDialogElementPrototype::s_info = { "HTMLDialogElementPrototype", &Base::s_info, &JSHTMLDialogElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLDialogElementPrototype) };

JSObject* JSHTMLDialogElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDialogElement>(exec, globalObject);
}

bool JSHTMLDialogElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLDialogElementPrototype* thisObject = jsCast<JSHTMLDialogElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLDialogElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLDialogElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLDialogElementPrototype* thisObject = jsCast<JSHTMLDialogElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLDialogElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLDialogElement::s_info = { "HTMLDialogElement", &Base::s_info, &JSHTMLDialogElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLDialogElement) };

JSHTMLDialogElement::JSHTMLDialogElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDialogElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLDialogElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLDialogElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLDialogElementPrototype::create(exec->vm(), globalObject, JSHTMLDialogElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDialogElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLDialogElement* thisObject = jsCast<JSHTMLDialogElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLDialogElement, Base>(exec, &JSHTMLDialogElementTable, thisObject, propertyName, slot);
}

bool JSHTMLDialogElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLDialogElement* thisObject = jsCast<JSHTMLDialogElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLDialogElement, Base>(exec, &JSHTMLDialogElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLDialogElementOpen(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDialogElement* castedThis = jsCast<JSHTMLDialogElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDialogElement* impl = static_cast<HTMLDialogElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::openAttr));
    return result;
}


JSValue jsHTMLDialogElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDialogElement* domObject = jsCast<JSHTMLDialogElement*>(asObject(slotBase));
    return JSHTMLDialogElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLDialogElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLDialogElement* thisObject = jsCast<JSHTMLDialogElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLDialogElement, Base>(exec, propertyName, value, &JSHTMLDialogElementTable, thisObject, slot);
}

void setJSHTMLDialogElementOpen(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDialogElement* castedThis = jsCast<JSHTMLDialogElement*>(thisObject);
    HTMLDialogElement* impl = static_cast<HTMLDialogElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::openAttr, nativeValue);
}


JSValue JSHTMLDialogElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDialogElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDialogElementPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDialogElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLDialogElement* castedThis = jsCast<JSHTMLDialogElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDialogElement::s_info);
    HTMLDialogElement* impl = static_cast<HTMLDialogElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->close(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDialogElementPrototypeFunctionShow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDialogElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLDialogElement* castedThis = jsCast<JSHTMLDialogElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDialogElement::s_info);
    HTMLDialogElement* impl = static_cast<HTMLDialogElement*>(castedThis->impl());
    impl->show();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDialogElementPrototypeFunctionShowModal(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDialogElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLDialogElement* castedThis = jsCast<JSHTMLDialogElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDialogElement::s_info);
    HTMLDialogElement* impl = static_cast<HTMLDialogElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->showModal(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(DIALOG_ELEMENT)
