/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepadList.h"

#include "ExceptionCode.h"
#include "Gamepad.h"
#include "GamepadList.h"
#include "JSDOMBinding.h"
#include "JSGamepad.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSGamepadListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadListLength), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGamepadListTable = { 2, 1, JSGamepadListTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSGamepadListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsGamepadListPrototypeFunctionItem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGamepadListPrototypeTable = { 2, 1, JSGamepadListPrototypeTableValues, 0 };
const ClassInfo JSGamepadListPrototype::s_info = { "GamepadListPrototype", &Base::s_info, &JSGamepadListPrototypeTable, 0, CREATE_METHOD_TABLE(JSGamepadListPrototype) };

JSObject* JSGamepadListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGamepadList>(exec, globalObject);
}

bool JSGamepadListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSGamepadListPrototype* thisObject = jsCast<JSGamepadListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSGamepadListPrototypeTable, thisObject, propertyName, slot);
}

bool JSGamepadListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSGamepadListPrototype* thisObject = jsCast<JSGamepadListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSGamepadListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSGamepadList::s_info = { "GamepadList", &Base::s_info, &JSGamepadListTable, 0 , CREATE_METHOD_TABLE(JSGamepadList) };

JSGamepadList::JSGamepadList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<GamepadList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSGamepadList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSGamepadList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSGamepadListPrototype::create(exec->vm(), globalObject, JSGamepadListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSGamepadList::destroy(JSC::JSCell* cell)
{
    JSGamepadList* thisObject = static_cast<JSGamepadList*>(cell);
    thisObject->JSGamepadList::~JSGamepadList();
}

JSGamepadList::~JSGamepadList()
{
    releaseImplIfNotNull();
}

bool JSGamepadList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSGamepadList* thisObject = jsCast<JSGamepadList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSGamepadList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<GamepadList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSGamepadList, Base>(exec, &JSGamepadListTable, thisObject, propertyName, slot);
}

bool JSGamepadList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSGamepadList* thisObject = jsCast<JSGamepadList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSGamepadListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<GamepadList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSGamepadList, Base>(exec, &JSGamepadListTable, thisObject, propertyName, descriptor);
}

bool JSGamepadList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSGamepadList* thisObject = jsCast<JSGamepadList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<GamepadList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsGamepadListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGamepadList* castedThis = jsCast<JSGamepadList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    GamepadList* impl = static_cast<GamepadList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


void JSGamepadList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSGamepadList* thisObject = jsCast<JSGamepadList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<GamepadList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

EncodedJSValue JSC_HOST_CALL jsGamepadListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSGamepadList::s_info))
        return throwVMTypeError(exec);
    JSGamepadList* castedThis = jsCast<JSGamepadList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSGamepadList::s_info);
    GamepadList* impl = static_cast<GamepadList*>(castedThis->impl());
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSGamepadList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSGamepadList* thisObj = jsCast<JSGamepadList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<GamepadList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSGamepadList* jsGamepadList)
{
    if (jsGamepadList->hasCustomProperties())
        return true;
    return false;
}

bool JSGamepadListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSGamepadList* jsGamepadList = jsCast<JSGamepadList*>(handle.get().asCell());
    if (!isObservable(jsGamepadList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSGamepadListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSGamepadList* jsGamepadList = jsCast<JSGamepadList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGamepadList->impl(), jsGamepadList);
    jsGamepadList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, GamepadList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGamepadList>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GamepadList.
    COMPILE_ASSERT(!__is_polymorphic(GamepadList), GamepadList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<GamepadList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSGamepadList>(exec, globalObject, impl);
}

GamepadList* toGamepadList(JSC::JSValue value)
{
    return value.inherits(&JSGamepadList::s_info) ? jsCast<JSGamepadList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GAMEPAD)
