/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepad.h"

#include "Gamepad.h"
#include "KURL.h"
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSGamepadTableValues[] =
{
    { "id", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadId), (intptr_t)0, NoIntrinsic },
    { "index", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadIndex), (intptr_t)0, NoIntrinsic },
    { "timestamp", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadTimestamp), (intptr_t)0, NoIntrinsic },
    { "axes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadAxes), (intptr_t)0, NoIntrinsic },
    { "buttons", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadButtons), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGamepadTable = { 17, 15, JSGamepadTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSGamepadPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGamepadPrototypeTable = { 1, 0, JSGamepadPrototypeTableValues, 0 };
const ClassInfo JSGamepadPrototype::s_info = { "GamepadPrototype", &Base::s_info, &JSGamepadPrototypeTable, 0, CREATE_METHOD_TABLE(JSGamepadPrototype) };

JSObject* JSGamepadPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGamepad>(exec, globalObject);
}

const ClassInfo JSGamepad::s_info = { "Gamepad", &Base::s_info, &JSGamepadTable, 0 , CREATE_METHOD_TABLE(JSGamepad) };

JSGamepad::JSGamepad(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Gamepad> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSGamepad::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSGamepad::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSGamepadPrototype::create(exec->vm(), globalObject, JSGamepadPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSGamepad::destroy(JSC::JSCell* cell)
{
    JSGamepad* thisObject = static_cast<JSGamepad*>(cell);
    thisObject->JSGamepad::~JSGamepad();
}

JSGamepad::~JSGamepad()
{
    releaseImplIfNotNull();
}

bool JSGamepad::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSGamepad* thisObject = jsCast<JSGamepad*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSGamepad, Base>(exec, &JSGamepadTable, thisObject, propertyName, slot);
}

bool JSGamepad::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSGamepad* thisObject = jsCast<JSGamepad*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSGamepad, Base>(exec, &JSGamepadTable, thisObject, propertyName, descriptor);
}

JSValue jsGamepadId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGamepad* castedThis = jsCast<JSGamepad*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Gamepad* impl = static_cast<Gamepad*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->id());
    return result;
}


JSValue jsGamepadIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGamepad* castedThis = jsCast<JSGamepad*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Gamepad* impl = static_cast<Gamepad*>(castedThis->impl());
    JSValue result = jsNumber(impl->index());
    return result;
}


JSValue jsGamepadTimestamp(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGamepad* castedThis = jsCast<JSGamepad*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Gamepad* impl = static_cast<Gamepad*>(castedThis->impl());
    JSValue result = jsNumber(impl->timestamp());
    return result;
}


JSValue jsGamepadAxes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGamepad* castedThis = jsCast<JSGamepad*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Gamepad* impl = static_cast<Gamepad*>(castedThis->impl());
    JSValue result = jsArray(exec, castedThis->globalObject(), impl->axes());
    return result;
}


JSValue jsGamepadButtons(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGamepad* castedThis = jsCast<JSGamepad*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Gamepad* impl = static_cast<Gamepad*>(castedThis->impl());
    JSValue result = jsArray(exec, castedThis->globalObject(), impl->buttons());
    return result;
}


static inline bool isObservable(JSGamepad* jsGamepad)
{
    if (jsGamepad->hasCustomProperties())
        return true;
    return false;
}

bool JSGamepadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSGamepad* jsGamepad = jsCast<JSGamepad*>(handle.get().asCell());
    if (!isObservable(jsGamepad))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSGamepadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSGamepad* jsGamepad = jsCast<JSGamepad*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGamepad->impl(), jsGamepad);
    jsGamepad->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Gamepad* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGamepad>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Gamepad.
    COMPILE_ASSERT(!__is_polymorphic(Gamepad), Gamepad_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<Gamepad>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSGamepad>(exec, globalObject, impl);
}

Gamepad* toGamepad(JSC::JSValue value)
{
    return value.inherits(&JSGamepad::s_info) ? jsCast<JSGamepad*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GAMEPAD)
