/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSFontLoader_h
#define JSFontLoader_h

#if ENABLE(FONT_LOAD_EVENTS)

#include "FontLoader.h"
#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSFontLoader : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSFontLoader* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FontLoader> impl)
    {
        JSFontLoader* ptr = new (NotNull, JSC::allocateCell<JSFontLoader>(globalObject->vm().heap)) JSFontLoader(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void destroy(JSC::JSCell*);
    ~JSFontLoader();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    FontLoader* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    FontLoader* m_impl;
protected:
    JSFontLoader(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<FontLoader>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSFontLoaderOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, FontLoader*)
{
    DEFINE_STATIC_LOCAL(JSFontLoaderOwner, jsFontLoaderOwner, ());
    return &jsFontLoaderOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, FontLoader*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, FontLoader*);
FontLoader* toFontLoader(JSC::JSValue);

class JSFontLoaderPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSFontLoaderPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontLoaderPrototype* ptr = new (NotNull, JSC::allocateCell<JSFontLoaderPrototype>(vm.heap)) JSFontLoaderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSFontLoaderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFontLoaderPrototypeFunctionCheckFont(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontLoaderPrototypeFunctionLoadFont(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontLoaderPrototypeFunctionNotifyWhenFontsReady(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontLoaderPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontLoaderPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontLoaderPrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsFontLoaderOnloading(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSFontLoaderOnloading(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsFontLoaderOnloadingdone(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSFontLoaderOnloadingdone(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsFontLoaderOnloadstart(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSFontLoaderOnloadstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsFontLoaderOnload(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSFontLoaderOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsFontLoaderOnerror(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSFontLoaderOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsFontLoaderLoading(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(FONT_LOAD_EVENTS)

#endif
